package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.BaseRegion;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.BaseRegionBO; 
import com.wlos.app.vo.BaseRegionVO; 


import com.wlos.app.bo.where.DataQuery_YQXFWhereBO;
import com.wlos.app.bo.where.DataQuery_EUQOWhereBO;
import com.wlos.app.bo.where.DataQuery_gdkBWhereBO;

/**
 * 地区表 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface BaseRegionMapper extends BaseMapper<BaseRegion> {
      
   /**
    * 流程-根据上级编码和级别编号查询市级列表-数据查询
    * @param dataQuery_YQXFWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<BaseRegion> dataQuery_YQXF(@Param("where") DataQuery_YQXFWhereBO dataQuery_YQXFWhereBo);



      
   /**
    * 流程-查询省级列表-数据查询
    * @param dataQuery_EUQOWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<BaseRegion> dataQuery_EUQO(@Param("where") DataQuery_EUQOWhereBO dataQuery_EUQOWhereBo);



      
   /**
    * 流程-根据id获取区域信息-数据查询-区域
    * @param dataQuery_gdkBWhereBo 查询参数BO 
    * @return 查询结果集
    */
    BaseRegion dataQuery_gdkB(@Param("where") DataQuery_gdkBWhereBO dataQuery_gdkBWhereBo);




}