package com.wlos.app.bo;

import java.io.Serializable;
import java.io.Serial;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 场馆信息 数据操作通用BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:35 PM
 * @since v0.1
 */
@Data
public class VenueInformationBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 字段_id
     */
    private String id;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 场馆名称
     */
    private String venueName;

    /**
     * 所属省代码
     */
    private String province;

    /**
     * 所属市代码
     */
    private String city;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 场馆地址
     */
    private String venueAddress;

    /**
     * 场地类型
     */
    private String venueType;

    /**
     * 来源 （0代表共享，1代表私有）
     */
    private String nature;

    /**
     * 创建者id
     */
    private Long userId;

    /**
     * 上级场地id
     */
    private Long parentId;

    /**
     * 场馆介绍
     */
    private String venueIntroduction;

    /**
     * 区域位置
     */
    private String regionalLocation;

    /**
     * 营业执照地址
     */
    private String businessLicenseAddr;

    /**
     * 统一信用代码
     */
    private String unifiedCreditCode;



}