package com.wlos.app.bo;

import java.io.Serializable;
import java.io.Serial;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 问卷 数据操作通用BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Data
public class SurveyQuestionnaireBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 踏勘开始时间
     */
    private LocalDateTime beginTime;

    /**
     * 是否整改
     */
    private Boolean correction;

    /**
     * 踏勘结束时间
     */
    private LocalDateTime endTime;

    /**
     * 是否生成问卷
     */
    private Boolean generate;

    /**
     * 踏勘报告路径
     */
    private String reportPath;

    /**
     * 踏勘阶段
     */
    private String surveyStep;

    /**
     * 踏勘状态
     */
    private String taskStatus;

    /**
     * 所属活动踏勘阶段ID
     */
    private Long feedbackId;

    /**
     * 场地ID
     */
    private Long venueId;



}