package com.wlos.app.bo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 流程-根据任务和阶段查询审批通过的专家-数据查询 表关联BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:58 PM
 * @since v0.1
 */
@Data
public class DataqueryZzjmBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 踏勘阶段
     */
    private String surveyStep;

    /**
     * 申请原因
     */
    private String reason;

    /**
     * 申请的专家
     */
    private Object experts;

    /**
     * 分配类型(0任务转交;1申请专家)
     */
    private String assignType;

    /**
     * 分配状态(0未审批;1不通过;2通过;9关闭)
     */
    private String assignStatus;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 接受者
     */
    private Long accepterId;

    /**
     * 踏勘任务ID
     */
    private Long taskId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 真实姓名
     */
    private String realName;

    /**
     * 电话
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 是否激活
     */
    private String active;

    /**
     * 专家来源:public,private
     */
    private String source;

    /**
     * 专家标签:现场专家,远程专家,咨询专家
     */
    private String expertTag;

    /**
     * v5雇员Id
     */
    private String v5_employee_id;

    /**
     * 用户类型(1:踏勘人员;2:专家人员;3.两者都有)
     */
    private String userType;

    /**
     * 主键id
     */
    private String id_MjzA;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime_smZu;

    /**
     * 对应机构ID
     */
    private Long orgId;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime_tkJh;



}

