package com.wlos.app.bo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 流程-下一题-数据查询-查之后的题目 表关联BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:57 PM
 * @since v0.1
 */
@Data
public class DataqueryVlalBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 问题回答id
     */
    private Long survey_info_id;

    /**
     * 踏勘阶段
     */
    private String surveyStep;

    /**
     * 排序编号
     */
    private Long sort;

    /**
     * 问题类型
     */
    private String questionType;

    /**
     * 踏勘题目
     */
    private String question;

    /**
     * 结果提示
     */
    private String answerTip;

    /**
     * CMS中对应的问题ID
     */
    private String aid;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 主键id
     */
    private String id_Hybk;

    /**
     * 整改意见ID
     */
    private Long reformId;

    /**
     * 活动场馆阶段问卷ID
     */
    private Long questionnaireId;

    /**
     * 该问题是否已回答
     */
    private Integer replied;

    /**
     * 是否下次踏勘
     */
    private Integer nextSurvey;

    /**
     * 关联上次踏勘ID
     */
    private String lastSurveyInfoId;

    /**
     * 踏勘结果
     */
    private String answer;



}

