package com.wlos.app.bo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 流程-问卷设计列表查询-数据查询-计划列表 表关联BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:59 PM
 * @since v0.1
 */
@Data
public class DataqueryRmqqBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 总共天数
     */
    private Boolean allDay;

    /**
     * 踏勘开始时间
     */
    private LocalDateTime beginTime;

    /**
     * 踏勘结束时间
     */
    private LocalDateTime endTime;

    /**
     * 承办方负责人签字
     */
    private String purveyorSignPath;

    /**
     * 备注
     */
    private String remark;

    /**
     * 客户经理签字
     */
    private String signImgPath;

    /**
     * 踏勘阶段
     */
    private String surveyStep;

    /**
     * 踏勘状态
     */
    private String taskStatus;

    /**
     * 踏勘次数
     */
    private Integer time;

    /**
     * 对应踏勘阶段
     */
    private Long feedbackId;

    /**
     * 对应踏勘场地问题
     */
    private Long questionnaireId;

    /**
     * 踏勘任务ID
     */
    private Long taskId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 场地ID
     */
    private Long venueId;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 统一信用代码
     */
    private String unifiedCreditCode;

    /**
     * 营业执照地址
     */
    private String businessLicenseAddr;

    /**
     * 区域位置
     */
    private String regionalLocation;

    /**
     * 场馆介绍
     */
    private String venueIntroduction;

    /**
     * 上级场地id
     */
    private Long parentId;

    /**
     * 创建者id
     */
    private Long userId_fAoI;

    /**
     * 来源 （0代表共享，1代表私有）
     */
    private String nature;

    /**
     * 场地类型
     */
    private String venueType;

    /**
     * 场馆地址
     */
    private String venueAddress;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 所属市代码
     */
    private String city;

    /**
     * 所属省代码
     */
    private String province;

    /**
     * 场馆名称
     */
    private String venueName;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime_SzgY;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime_plBX;

    /**
     * 字段_id
     */
    private String id_Oixn;



}

