package com.wlos.app.bo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 流程-根据年月份查询未完成的任务列表-数据查询 表关联BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:04:00 PM
 * @since v0.1
 */
@Data
public class DataqueryBcejBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 任务名称
     */
    private String name;

    /**
     * 踏勘次数
     */
    private Integer time;

    /**
     * 踏勘状态
     */
    private String taskStatus;

    /**
     * 踏勘阶段
     */
    private String surveyStep;

    /**
     * 踏勘结束时间
     */
    private LocalDateTime endTime;

    /**
     * 踏勘开始时间
     */
    private LocalDateTime beginTime;

    /**
     * 总共天数
     */
    private Boolean allDay;

    /**
     * 统一信用代码
     */
    private String unifiedCreditCode;

    /**
     * 营业执照地址
     */
    private String businessLicenseAddr;

    /**
     * 区域位置
     */
    private String regionalLocation;

    /**
     * 场馆介绍
     */
    private String venueIntroduction;

    /**
     * 场馆名称
     */
    private String venueName;



}

