
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class VenueInformationAggregateServiceImpl implements VenueInformationAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private VenueInformationService venueInformationService;


    /**
    * 聚合查询：根据场馆id查询场馆信息-数据查询
    * @return
    */
    @Override
    public VenueInformation dataQuery_Wxdw(JSONObject paramsJsonContext,QueryVenueInformationBasedOnVenueIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String venueID0 = bo.getVenueID();
        queryParams.put("venueInformationId", venueID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_WxdwWhereBO dataQuery_WxdwWhereBO = BeanUtil.toBean(queryParams, DataQuery_WxdwWhereBO.class);
        VenueInformation queryResult = venueInformationService.selectOne(dataQuery_WxdwWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据区域查询场馆列表-数据查询
    * @return
    */
    @Override
    public List<VenueInformation> dataQuery_NIUa(JSONObject paramsJsonContext,QueryVenueLstByRgnBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String cityCode0 = bo.getCityCode();
        queryParams.put("venueInformationCity", cityCode0);
        String provincialCode1 = bo.getProvincialCode();
        queryParams.put("venueInformationProvince", provincialCode1);
        String venueType2 = bo.getVenueType();
        queryParams.put("venueInformationVenueType", venueType2);
        Integer operation3 = bo.getOperation();
        queryParams.put("venueInformationUserId", operation3);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_NIUaWhereBO dataQuery_NIUaWhereBO = BeanUtil.toBean(queryParams, DataQuery_NIUaWhereBO.class);
        List<VenueInformation> queryResult = venueInformationService.list(dataQuery_NIUaWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：修改场馆信息-数据查询
    * @return
    */
    @Override
    public VenueInformation dataQuery_Hwic(JSONObject paramsJsonContext,ModifyVenueInformationBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String venueID0 = bo.getVenueID();
        queryParams.put("venueInformationId", venueID0);
        Long userID1 = bo.getUserID();
        queryParams.put("venueInformationUserId", userID1);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_HwicWhereBO dataQuery_HwicWhereBO = BeanUtil.toBean(queryParams, DataQuery_HwicWhereBO.class);
        VenueInformation queryResult = venueInformationService.selectOne(dataQuery_HwicWhereBO);
        return queryResult;
    }


}