package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import com.wlos.app.bo.where.*;
import com.wlos.app.da.service.SurveyFeedbackService;
import com.wlos.app.da.service.SurveyQuestionnaireService;
/**
* 更新踏勘结果-报告生成未开发
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class UpdSurveyResultsReportGenerationUndevelopedService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "更新踏勘结果-报告生成未开发";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPlanAggregateService surveyPlanAggregateService;
    @Autowired
    private GatewayMatchService gatewayMatchService;    @Autowired
    private QueryPlanInformationBasedOnPlanIDService queryPlanInformationBasedOnPlanIDService;    @Autowired
    private SurveyFeedbackService surveyFeedbackService;    @Autowired
    private SurveyQuestionnaireService surveyQuestionnaireService;    @Autowired
    private GenSurveyReportService genSurveyReportService;
    /**
    * 更新踏勘结果-报告生成未开发接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(UpdSurveyResultsReportGenerationUndevelopedDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        UpdSurveyResultsReportGenerationUndevelopedBO bo = new UpdSurveyResultsReportGenerationUndevelopedBO();
        if (Objects.isNull(form)) {
            form = new UpdSurveyResultsReportGenerationUndevelopedDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //同步引用流程-计划信息
        //数据查询-未作答题目记录
        //运算-未作答记录数
        //分支-未作答等于0
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"abnormalInformation",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("abnormalInformation",boMap.get("abnormalInformation"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        synchronizeRefProcPlanInformation(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询-未作答题目记录
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryRecordOfUnansweredQuestions(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-未作答题目记录==taskIdentifier：dataQueryRecordOfUnansweredQuestions==damMethod：dataQuery_AuHN==");
        //调用数据查询
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-未作答题目记录,输入参数: {}",processName,JSON.toJSONString(bo));
        List<DataqueryAuhnBO> vo = surveyPlanAggregateService.dataQuery_AuHN(paramsJsonContext,bo);
        bo.setDataQueryRecordOfUnansweredQuestions(vo);
        log.debug("流程名称：{},方法名称: 数据查询-未作答题目记录,输出参数: {}",processName,JSON.toJSONString(vo));
        operationNumOfUnansweredRecords(paramsJsonContext, executeBO);
    }

    /**
    * 运算-未作答记录数
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationNumOfUnansweredRecords(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-未作答记录数,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nu_SearchData_U_5c68144445f24bb3bfefd31678c707d9_u.length;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_SearchData_U_5c68144445f24bb3bfefd31678c707d9_u";
        String bindType0 = "List";
        List bindValue0 = bo.getDataQueryRecordOfUnansweredQuestions();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setOperationNumOfUnansweredRecords(vo);
        log.debug("流程名称：{},方法名称: 运算-未作答记录数,输出参数: {}",processName,JSON.toJSONString(vo));
        branchUnansweredEquals0(paramsJsonContext, executeBO);
    }

    /**
    * 分支-未作答等于0
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branchUnansweredEquals0(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支-未作答等于0";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchUnansweredEquals0BranchCompletedSignature(paramsJsonContext, executeBO)){
            branchCompletedSignature(paramsJsonContext, executeBO);
        }
        else {
            paramAssignment(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchUnansweredEquals0BranchCompletedSignature(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            List dataQueryRecordOfUnansweredQuestions = bo.getDataQueryRecordOfUnansweredQuestions();
            boolean matchState = (((ObjectUtils.isNotEmpty(dataQueryRecordOfUnansweredQuestions))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String ncfwp0 = "计划问卷存在未完成作答的题目";
        bo.setAbnormalInformation(ncfwp0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 分支-是否完成签名
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branchCompletedSignature(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支-是否完成签名";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchCompletedSignatureBranchChkInOrNot(paramsJsonContext, executeBO)){
            branchChkInOrNot(paramsJsonContext, executeBO);
        }
        else {
            paramAssignment_BbvY(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchCompletedSignatureBranchChkInOrNot(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            String signatureOfAccountMgr = bo.getSynchronizeRefProcPlanInformation().getSignatureOfAccountMgr();
            String signatureOfTheResponsiblePersonOfTheOrganizer = bo.getSynchronizeRefProcPlanInformation().getSignatureOfTheResponsiblePersonOfTheOrganizer();
            boolean matchState = (((ObjectUtils.isNotEmpty(signatureOfAccountMgr)))&&((ObjectUtils.isNotEmpty(signatureOfTheResponsiblePersonOfTheOrganizer))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 同步引用流程-计划信息
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronizeRefProcPlanInformation(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程-计划信息,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                String planID0 = bo.getPlanID();
                jsonObjectNewParam.put("planID", planID0);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronizeRefProcPlanInformationExecSub(BeanUtil.mapToBean(jsonObjectNewParam, QueryPlanInformationBasedOnPlanIDDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        QueryPlanInformationBasedOnPlanIDVO vo = JSON.parseObject(JSON.toJSONString(voObj),QueryPlanInformationBasedOnPlanIDVO.class);
        bo.setSynchronizeRefProcPlanInformation(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程-计划信息,输出参数: {}",processName,JSON.toJSONString(vo));
        dataQueryRecordOfUnansweredQuestions(paramsJsonContext, executeBO);
    }

    JSONObject synchronizeRefProcPlanInformationExecSub(QueryPlanInformationBasedOnPlanIDDTO form) throws BusinessException {
        return queryPlanInformationBasedOnPlanIDService.processMainExecute(form);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_BbvY(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String oidvt0 = "部分签字未完成";
        bo.setAbnormalInformation(oidvt0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 分支-是否签到
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branchChkInOrNot(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支-是否签到";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchChkInOrNotCalculationExplorationStage(paramsJsonContext, executeBO)){
            calculationExplorationStage(paramsJsonContext, executeBO);
        }
        else {
            paramAssignment_RJzK(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchChkInOrNotCalculationExplorationStage(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            Boolean chkInOrNot = bo.getSynchronizeRefProcPlanInformation().getChkInOrNot();
            boolean matchState = ((((boolean)chkInOrNot)));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_RJzK(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String xnhnl0 = "踏勘人员未进行签到";
        bo.setAbnormalInformation(xnhnl0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 数据修改-查勘反馈状态更新
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModificationSurveyFeedbackStsUpd(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改-查勘反馈状态更新,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                Object fnvlq0 = null;
                paramMap.put("modificationTime", fnvlq0);
                Object ckwly1 = "2";
                paramMap.put("taskStatus", ckwly1);

        JSONObject whereParamMap = new JSONObject();
                String surveyFeedbackID2 = bo.getSynchronizeRefProcPlanInformation().getSurveyFeedbackID();
                whereParamMap.put("surveyFeedbackId", surveyFeedbackID2);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyFeedbackBO surveyFeedbackBO = BeanUtil.mapToBean(paramMap, SurveyFeedbackBO.class, null);
        UpdsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBO updsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBO = BeanUtil.mapToBean(whereParamMap, UpdsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBO.class, null);
        Integer vo = surveyFeedbackService.update(surveyFeedbackBO, updsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBO);
        bo.setDataModificationSurveyFeedbackStsUpd(vo);
        log.debug("流程名称：{},方法名称: 数据修改-查勘反馈状态更新,输出参数: {}",processName,JSON.toJSONString(vo));
        dataModificationQuestionnaireStsUpd(paramsJsonContext, executeBO);
    }

    /**
    * 数据修改-问卷状态更新
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModificationQuestionnaireStsUpd(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改-问卷状态更新,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                Object gnodh0 = null;
                paramMap.put("modificationTime", gnodh0);
                Object ktwqv1 = "2";
                paramMap.put("taskStatus", ktwqv1);
                String fileAddr2 = bo.getSynchronizeRefProcGenSurveyReport().getFileAddr();
                paramMap.put("reportPath", fileAddr2);

        JSONObject whereParamMap = new JSONObject();
                String questionnaireID3 = bo.getSynchronizeRefProcPlanInformation().getQuestionnaireID();
                whereParamMap.put("surveyQuestionnaireId", questionnaireID3);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyQuestionnaireBO surveyQuestionnaireBO = BeanUtil.mapToBean(paramMap, SurveyQuestionnaireBO.class, null);
        UpdsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBO updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBO = BeanUtil.mapToBean(whereParamMap, UpdsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBO.class, null);
        Integer vo = surveyQuestionnaireService.update(surveyQuestionnaireBO, updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBO);
        bo.setDataModificationQuestionnaireStsUpd(vo);
        log.debug("流程名称：{},方法名称: 数据修改-问卷状态更新,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 同步引用流程-生成踏勘报告
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronizeRefProcGenSurveyReport(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程-生成踏勘报告,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                String questionnaireID0 = bo.getSynchronizeRefProcPlanInformation().getQuestionnaireID();
                jsonObjectNewParam.put("questionnaireID", questionnaireID0);
                String activityName1 = bo.getSynchronizeRefProcPlanInformation().getActivityName();
                jsonObjectNewParam.put("taskName", activityName1);
                String venueName2 = bo.getSynchronizeRefProcPlanInformation().getVenueName();
                jsonObjectNewParam.put("venueName", venueName2);
                String calculationExplorationStage3 = bo.getCalculationExplorationStage();
                jsonObjectNewParam.put("surveyStep", calculationExplorationStage3);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronizeRefProcGenSurveyReportExecSub(BeanUtil.mapToBean(jsonObjectNewParam, GenSurveyReportDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        GenSurveyReportVO vo = JSON.parseObject(JSON.toJSONString(voObj),GenSurveyReportVO.class);
        bo.setSynchronizeRefProcGenSurveyReport(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程-生成踏勘报告,输出参数: {}",processName,JSON.toJSONString(vo));
        branch(paramsJsonContext, executeBO);
    }

    JSONObject synchronizeRefProcGenSurveyReportExecSub(GenSurveyReportDTO form) throws BusinessException {
        return genSurveyReportService.processMainExecute(form);
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchDataModificationSurveyFeedbackStsUpd(paramsJsonContext, executeBO)){
            dataModificationSurveyFeedbackStsUpd(paramsJsonContext, executeBO);
        }
        else {
            paramAssignment_Utfa(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchDataModificationSurveyFeedbackStsUpd(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            String fileAddr = bo.getSynchronizeRefProcGenSurveyReport().getFileAddr();
            boolean matchState = (((ObjectUtils.isNotEmpty(fileAddr))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 运算-踏勘阶段
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationExplorationStage(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-踏勘阶段,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nString(\'第\' + String(u_biz_flow_v2_process_output_param_U_688a05483596453ea272e7d4c1834773_u)) + \'阶段\';\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_process_output_param_U_688a05483596453ea272e7d4c1834773_u";
        String bindType0 = "Integer";
        Integer bindValue0 = bo.getSynchronizeRefProcPlanInformation().getSurveyStage();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setCalculationExplorationStage(vo);
        log.debug("流程名称：{},方法名称: 运算-踏勘阶段,输出参数: {}",processName,JSON.toJSONString(vo));
        synchronizeRefProcGenSurveyReport(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_Utfa(JSONObject paramsJsonContext, UpdSurveyResultsReportGenerationUndevelopedBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        UpdSurveyResultsReportGenerationUndevelopedBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String orypj0 = "报告生成失败";
        bo.setAbnormalInformation(orypj0);
        endEvent(paramsJsonContext, executeBO);
    }

}