package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.bo.where.*;
import com.wlos.app.da.service.SurveyPlanService;
import com.wlos.app.bo.*;
/**
* 更新计划签名
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class UpdPlanSignatureService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "更新计划签名";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPlanService surveyPlanService;
    @Autowired
    private GatewayMatchService gatewayMatchService;
    /**
    * 更新计划签名接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(UpdPlanSignatureDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        UpdPlanSignatureBO bo = new UpdPlanSignatureBO();
        if (Objects.isNull(form)) {
            form = new UpdPlanSignatureDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //路径选择
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, UpdPlanSignatureBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        pathChoice(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, UpdPlanSignatureBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据修改-踏勘人员签名
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModificationSignatureOfSurveyPersonnel(JSONObject paramsJsonContext, UpdPlanSignatureBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        UpdPlanSignatureBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改-踏勘人员签名,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                Object cqajy0 = null;
                paramMap.put("modificationTime", cqajy0);
                String signatureAddr1 = bo.getSignatureAddr();
                paramMap.put("signImgPath", signatureAddr1);

        JSONObject whereParamMap = new JSONObject();
                String planID2 = bo.getPlanID();
                whereParamMap.put("surveyPlanId", planID2);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyPlanBO surveyPlanBO = BeanUtil.mapToBean(paramMap, SurveyPlanBO.class, null);
        UpdplansignaturedataModificationSignatureOfSurveyPersonnelWhereBO updplansignaturedataModificationSignatureOfSurveyPersonnelWhereBO = BeanUtil.mapToBean(whereParamMap, UpdplansignaturedataModificationSignatureOfSurveyPersonnelWhereBO.class, null);
        Integer vo = surveyPlanService.update(surveyPlanBO, updplansignaturedataModificationSignatureOfSurveyPersonnelWhereBO);
        bo.setDataModificationSignatureOfSurveyPersonnel(vo);
        log.debug("流程名称：{},方法名称: 数据修改-踏勘人员签名,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 路径选择
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void pathChoice(JSONObject paramsJsonContext, UpdPlanSignatureBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "路径选择";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(pathChoiceDataModificationSignatureOfTheOrganizer(paramsJsonContext, executeBO)){
            dataModificationSignatureOfTheOrganizer(paramsJsonContext, executeBO);
        }
        else {
            dataModificationSignatureOfSurveyPersonnel(paramsJsonContext, executeBO);
        }
    }
    /**
    * 路径2
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean pathChoiceDataModificationSignatureOfTheOrganizer(JSONObject paramsJsonContext, UpdPlanSignatureBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            UpdPlanSignatureBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 路径2,输入参数: {}",processName,JSON.toJSONString(bo));
            Integer signatureType1SurveySignature2OrganizerSignature = bo.getSignatureType1SurveySignature2OrganizerSignature();
            boolean matchState = (((DecimalUtil.eq(new BigDecimal(signatureType1SurveySignature2OrganizerSignature+""),new BigDecimal("2"+"")))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 数据修改-承办方签名
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModificationSignatureOfTheOrganizer(JSONObject paramsJsonContext, UpdPlanSignatureBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        UpdPlanSignatureBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改-承办方签名,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                Object klenf0 = null;
                paramMap.put("modificationTime", klenf0);
                String signatureAddr1 = bo.getSignatureAddr();
                paramMap.put("purveyorSignPath", signatureAddr1);

        JSONObject whereParamMap = new JSONObject();
                String planID2 = bo.getPlanID();
                whereParamMap.put("surveyPlanId", planID2);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyPlanBO surveyPlanBO = BeanUtil.mapToBean(paramMap, SurveyPlanBO.class, null);
        UpdplansignaturedataModificationSignatureOfTheOrganizerWhereBO updplansignaturedataModificationSignatureOfTheOrganizerWhereBO = BeanUtil.mapToBean(whereParamMap, UpdplansignaturedataModificationSignatureOfTheOrganizerWhereBO.class, null);
        Integer vo = surveyPlanService.update(surveyPlanBO, updplansignaturedataModificationSignatureOfTheOrganizerWhereBO);
        bo.setDataModificationSignatureOfTheOrganizer(vo);
        log.debug("流程名称：{},方法名称: 数据修改-承办方签名,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

}