package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 任务转换
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class TskConversionService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "任务转换";
    @Autowired
    private ParamHandleService paramHandleService;

    /**
    * 任务转换接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(TskConversionDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        TskConversionBO bo = new TskConversionBO();
        if (Objects.isNull(form)) {
            form = new TskConversionDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //运算
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"startTime","endTime","name","id","address","stage",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("startTime",boMap.get("startTime"));
                vo.put("endTime",boMap.get("endTime"));
                vo.put("name",boMap.get("name"));
                vo.put("id",boMap.get("id"));
                vo.put("address",boMap.get("address"));
                vo.put("stage",boMap.get("stage"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, TskConversionBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        operation(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, TskConversionBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 运算
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operation(JSONObject paramsJsonContext, TskConversionBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        TskConversionBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nString(\'第\' + String(u_biz_flow_v2_input_param_U_63ef2e2c58ca45f78d965bc8e9dc31ae_u)) + \'阶段\';\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_input_param_U_63ef2e2c58ca45f78d965bc8e9dc31ae_u";
        String bindType0 = "String";
        String bindValue0 = bo.getActivityStage();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setOperation(vo);
        log.debug("流程名称：{},方法名称: 运算,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, TskConversionBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        TskConversionBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        LocalDateTime startsbgsw0 = bo.getStart();
        bo.setStartTime(startsbgsw0);
        LocalDateTime endfufna1 = bo.getEnd();
        bo.setEndTime(endfufna1);
        String eventNamedhdbo2 = bo.getEventName();
        bo.setName(eventNamedhdbo2);
        String encodingIDpgvxg3 = bo.getEncodingID();
        bo.setId(encodingIDpgvxg3);
        String venueAddrptfez4 = bo.getVenueAddr();
        bo.setAddress(venueAddrptfez4);
        String operationkymjm5 = bo.getOperation();
        bo.setStage(operationkymjm5);
        endEvent(paramsJsonContext, executeBO);
    }

}