package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
/**
* 暂存固定和开放问题
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class TmpStgOfFixedAndOpenIssuesService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "暂存固定和开放问题";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private GatewayMatchService gatewayMatchService;
    @Autowired
    private AddFixedIssueTmpStgService addFixedIssueTmpStgService;    @Autowired
    private TmpStgOfNewlyAddedOpenQuestionsService tmpStgOfNewlyAddedOpenQuestionsService;    @Autowired
    private BaseOpenIssueAggregateService baseOpenIssueAggregateService;    @Autowired
    private BaseFixedIssueAggregateService baseFixedIssueAggregateService;
    /**
    * 暂存固定和开放问题接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(TmpStgOfFixedAndOpenIssuesDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        TmpStgOfFixedAndOpenIssuesBO bo = new TmpStgOfFixedAndOpenIssuesBO();
        if (Objects.isNull(form)) {
            form = new TmpStgOfFixedAndOpenIssuesDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //是固定问题
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, TmpStgOfFixedAndOpenIssuesBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        itsAFixedIssue(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, TmpStgOfFixedAndOpenIssuesBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 是固定问题
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void itsAFixedIssue(JSONObject paramsJsonContext, TmpStgOfFixedAndOpenIssuesBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "是固定问题";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(itsAFixedIssueFixedIssuesWithDataQueries(paramsJsonContext, executeBO)){
            fixedIssuesWithDataQueries(paramsJsonContext, executeBO);
        }
        else {
            dataQueryDevelopment(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean itsAFixedIssueFixedIssuesWithDataQueries(JSONObject paramsJsonContext, TmpStgOfFixedAndOpenIssuesBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            TmpStgOfFixedAndOpenIssuesBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            Integer questionType1Fixed2Open = bo.getQuestionType1Fixed2Open();
            boolean matchState = (((DecimalUtil.eq(new BigDecimal(questionType1Fixed2Open+""),new BigDecimal("1"+"")))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 循环
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void loop(JSONObject paramsJsonContext, TmpStgOfFixedAndOpenIssuesBO executeBO) throws BusinessException {
        log.info("========执行循环调用过程方法=======");
        TmpStgOfFixedAndOpenIssuesBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 循环,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONArray vo = new JSONArray();
        List loopArray = bo.getFixedIssuesWithDataQueries();
        //获取需要循环的内容
        //执行循环
        if (CollectionUtils.isNotEmpty(loopArray)) {
            log.info("=============循环的数据有数据，准备执行循环子流程处理=================");
            for (int i = 0; i < loopArray.size(); i++) {
                //初始化下一个流程需要的data数据
                Map<String, Object> jsonObjectNewParam = new HashMap<>();
        JSONObject item = JSON.parseObject(JSON.toJSONString(loopArray.get(i)), JSONObject.class);
                Object sort0 =  item.get("sort");
                jsonObjectNewParam.put("sort", sort0);
                Object answerTip1 =  item.get("answerTip");
                jsonObjectNewParam.put("tips", answerTip1);
                Object question2 =  item.get("question");
                jsonObjectNewParam.put("subject", question2);
                Object id3 =  item.get("id");
                jsonObjectNewParam.put("problemID", id3);
                Long questionnaireId4 = bo.getQuestionnaireId();
                jsonObjectNewParam.put("questionnaireID", questionnaireId4);
                log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
                JSONObject returnDataJson = addFixedIssueTmpStgService.processMainExecute(BeanUtil.mapToBean(jsonObjectNewParam, AddFixedIssueTmpStgDTO.class, null));
                //取返回结果
                if (null != returnDataJson) {
                    returnDataJson.remove("system_returnBelong");
                    returnDataJson.remove("system_flow_down_file_flag");
                }
                vo.add(returnDataJson);
            }
        } else {
            log.info("=============循环的数据为空，不执行循环子流程处理=================");
        }
        bo.setLoop(vo);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 循环
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void loop_OCJS(JSONObject paramsJsonContext, TmpStgOfFixedAndOpenIssuesBO executeBO) throws BusinessException {
        log.info("========执行循环调用过程方法=======");
        TmpStgOfFixedAndOpenIssuesBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 循环,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONArray vo = new JSONArray();
        List loopArray = bo.getDataQueryDevelopment();
        //获取需要循环的内容
        //执行循环
        if (CollectionUtils.isNotEmpty(loopArray)) {
            log.info("=============循环的数据有数据，准备执行循环子流程处理=================");
            for (int i = 0; i < loopArray.size(); i++) {
                //初始化下一个流程需要的data数据
                Map<String, Object> jsonObjectNewParam = new HashMap<>();
        JSONObject item = JSON.parseObject(JSON.toJSONString(loopArray.get(i)), JSONObject.class);
                Object question0 =  item.get("question");
                jsonObjectNewParam.put("subject", question0);
                Object id1 =  item.get("id");
                jsonObjectNewParam.put("problemID", id1);
                Long questionnaireId2 = bo.getQuestionnaireId();
                jsonObjectNewParam.put("questionnaireID", questionnaireId2);
                log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
                JSONObject returnDataJson = tmpStgOfNewlyAddedOpenQuestionsService.processMainExecute(BeanUtil.mapToBean(jsonObjectNewParam, TmpStgOfNewlyAddedOpenQuestionsDTO.class, null));
                //取返回结果
                if (null != returnDataJson) {
                    returnDataJson.remove("system_returnBelong");
                    returnDataJson.remove("system_flow_down_file_flag");
                }
                vo.add(returnDataJson);
            }
        } else {
            log.info("=============循环的数据为空，不执行循环子流程处理=================");
        }
        bo.setLoop_OCJS(vo);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询开发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryDevelopment(JSONObject paramsJsonContext, TmpStgOfFixedAndOpenIssuesBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询开发==taskIdentifier：dataQueryDevelopment==damMethod：dataQuery_vikA==");
        //调用数据查询
        TmpStgOfFixedAndOpenIssuesBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询开发,输入参数: {}",processName,JSON.toJSONString(bo));
        List<BaseOpenIssue> vo = baseOpenIssueAggregateService.dataQuery_vikA(paramsJsonContext,bo);
        bo.setDataQueryDevelopment(vo);
        log.debug("流程名称：{},方法名称: 数据查询开发,输出参数: {}",processName,JSON.toJSONString(vo));
        loop_OCJS(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询固定问题
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void fixedIssuesWithDataQueries(JSONObject paramsJsonContext, TmpStgOfFixedAndOpenIssuesBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询固定问题==taskIdentifier：fixedIssuesWithDataQueries==damMethod：dataQuery_ltrJ==");
        //调用数据查询
        TmpStgOfFixedAndOpenIssuesBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询固定问题,输入参数: {}",processName,JSON.toJSONString(bo));
        List<BaseFixedIssue> vo = baseFixedIssueAggregateService.dataQuery_ltrJ(paramsJsonContext,bo);
        bo.setFixedIssuesWithDataQueries(vo);
        log.debug("流程名称：{},方法名称: 数据查询固定问题,输出参数: {}",processName,JSON.toJSONString(vo));
        loop(paramsJsonContext, executeBO);
    }

}