
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class SurveyTaskAggregateServiceImpl implements SurveyTaskAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyTaskService surveyTaskService;


    /**
    * 聚合查询：查询任务详情-数据查询
    * @return
    */
    @Override
    public SurveyTask dataQuery_dykB(JSONObject paramsJsonContext,QueryTskDetailsBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String tskID0 = bo.getTskID();
        queryParams.put("surveyTaskId", tskID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_dykBWhereBO dataQuery_dykBWhereBO = BeanUtil.toBean(queryParams, DataQuery_dykBWhereBO.class);
        SurveyTask queryResult = surveyTaskService.selectOne(dataQuery_dykBWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据用户id查询进行中的任务列-数据查询
    * @return
    */
    @Override
    public List<SurveyTask> dataQuery_EQSh(JSONObject paramsJsonContext,QueryOngoingTskColumnsBasedOnUserIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Integer calculationUserID0 = bo.getCalculationUserID();
        queryParams.put("surveyTaskUserId", calculationUserID0);
        Object nrmcg1 = "1";
        queryParams.put("surveyTaskSurveyTaskStatus", nrmcg1);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_EQShWhereBO dataQuery_EQShWhereBO = BeanUtil.toBean(queryParams, DataQuery_EQShWhereBO.class);
        List<SurveyTask> queryResult = surveyTaskService.list(dataQuery_EQShWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：模糊搜索任务-数据查询
    * @return
    */
    @Override
    public Page<DataQueryBO> dataQuery(JSONObject paramsJsonContext,FuzzySrchTskBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Integer numOfItems0 = bo.getNumOfItems();
        queryParams.put("size", numOfItems0);
        Integer theNumOfPages1 = bo.getTheNumOfPages();
        queryParams.put("current", theNumOfPages1);
        Integer calculationUserID2 = bo.getCalculationUserID();
        queryParams.put("surveyTaskUserId", calculationUserID2);
        String tskName3 = bo.getTskName();
        queryParams.put("surveyTaskName", tskName3);
        Object mimia4 = "0";
        queryParams.put("surveyTaskSurveyTaskStatus", mimia4);
        queryParams.put("current", Optional.ofNullable(queryParams.get("current")).orElse(1));
        queryParams.put("size", Optional.ofNullable(queryParams.get("size")).orElse(10));
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQueryWhereBO dataQueryWhereBO = BeanUtil.toBean(queryParams, DataQueryWhereBO.class);
        Page<DataQueryBO> queryResult = surveyTaskService.page(dataQueryWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：不含未接受的任务列表-数据查询
    * @return
    */
    @Override
    public Page<DataqueryJvfiBO> dataQuery_JvFI(JSONObject paramsJsonContext,ExcludingUnacceptedTskLstBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Integer numOfItems0 = bo.getNumOfItems();
        queryParams.put("size", numOfItems0);
        Integer theNumOfPages1 = bo.getTheNumOfPages();
        queryParams.put("current", theNumOfPages1);
        Integer calculationUserID2 = bo.getCalculationUserID();
        queryParams.put("surveyTaskUserId", calculationUserID2);
        String tskName3 = bo.getTskName();
        queryParams.put("surveyTaskName", tskName3);
        Object fdhtu4 = "0";
        queryParams.put("surveyTaskSurveyTaskStatus", fdhtu4);
        queryParams.put("current", Optional.ofNullable(queryParams.get("current")).orElse(1));
        queryParams.put("size", Optional.ofNullable(queryParams.get("size")).orElse(10));
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_JvFIWhereBO dataQuery_JvFIWhereBO = BeanUtil.toBean(queryParams, DataQuery_JvFIWhereBO.class);
        Page<DataqueryJvfiBO> queryResult = surveyTaskService.page(dataQuery_JvFIWhereBO);
        return queryResult;
    }


}