
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class SurveyTagAggregateServiceImpl implements SurveyTagAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyTagService surveyTagService;


    /**
    * 聚合查询：标签列表查询-数据查询-查询标签
    * @return
    */
    @Override
    public List<SurveyTag> dataQuery_RSqB(JSONObject paramsJsonContext,LabelLstQueryBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Object craxd0 = "1";
        queryParams.put("surveyTagLevel", craxd0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_RSqBWhereBO dataQuery_RSqBWhereBO = BeanUtil.toBean(queryParams, DataQuery_RSqBWhereBO.class);
        List<SurveyTag> queryResult = surveyTagService.list(dataQuery_RSqBWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据分类id查询分类名称-数据查询
    * @return
    */
    @Override
    public SurveyTag dataQuery_ufRX(JSONObject paramsJsonContext,QueryTheClassificationNameBasedOnTheClassificationIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String classificationID0 = bo.getClassificationID();
        queryParams.put("surveyTagId", classificationID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_ufRXWhereBO dataQuery_ufRXWhereBO = BeanUtil.toBean(queryParams, DataQuery_ufRXWhereBO.class);
        SurveyTag queryResult = surveyTagService.selectOne(dataQuery_ufRXWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据父级id查询标签列表-数据查询-标签列表
    * @return
    */
    @Override
    public List<SurveyTag> dataQuery_eHuG(JSONObject paramsJsonContext,QueryLabelLstBasedOnParentIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
            String kwnjeScript = "\n\n\nNumber(u_biz_flow_v2_input_param_U_0c854d90522d4a36a6877ee9da9e23ba_u);\n";
        List<BlocklyBindParamDto> ycceiBindparams = new ArrayList<>();
        String bindKeycevlf0 = "u_biz_flow_v2_input_param_U_0c854d90522d4a36a6877ee9da9e23ba_u";
        String bindTypekkybm0 = "String";
        String bindValuehzwzr0 = bo.getParentID();
        BlocklyBindParamDto paramDtoVariableNameshesh0 = BlocklyBindParamDto.builder()
            .bindValue(bindValuehzwzr0)
            .bindKey(bindKeycevlf0)
            .bindType(bindTypekkybm0)
            .build();
        ycceiBindparams.add(paramDtoVariableNameshesh0);
        Object tqsbn0Value = BlocklyUtils.exe(kwnjeScript, ycceiBindparams);
        Object tqsbn0 = tqsbn0Value;

        queryParams.put("surveyTagParentId", tqsbn0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_eHuGWhereBO dataQuery_eHuGWhereBO = BeanUtil.toBean(queryParams, DataQuery_eHuGWhereBO.class);
        List<SurveyTag> queryResult = surveyTagService.list(dataQuery_eHuGWhereBO);
        return queryResult;
    }


}