
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class SurveyQuestionnaireAggregateServiceImpl implements SurveyQuestionnaireAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyQuestionnaireService surveyQuestionnaireService;


    /**
    * 聚合查询：生成问卷-数据查询-问卷信息
    * @return
    */
    @Override
    public SurveyQuestionnaire dataQuery_dqCr(JSONObject paramsJsonContext,GenQuestionnaireBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
            String lgujaScript = "\n\n\nu_biz_flow_v2_input_param_U_8636fc8311864a21a8482f86d086c128_u;\n";
        List<BlocklyBindParamDto> eeevqBindparams = new ArrayList<>();
        String bindKeyjfauf0 = "u_biz_flow_v2_input_param_U_8636fc8311864a21a8482f86d086c128_u";
        String bindTypeptjak0 = "BigInteger";
        Long bindValuevfxra0 = bo.getQuestionnaireID();
        BlocklyBindParamDto paramDtoVariableNamethycw0 = BlocklyBindParamDto.builder()
            .bindValue(bindValuevfxra0)
            .bindKey(bindKeyjfauf0)
            .bindType(bindTypeptjak0)
            .build();
        eeevqBindparams.add(paramDtoVariableNamethycw0);
        Object dmxqn0Value = BlocklyUtils.exe(lgujaScript, eeevqBindparams);
        Object dmxqn0 = dmxqn0Value;

        queryParams.put("surveyQuestionnaireId", dmxqn0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_dqCrWhereBO dataQuery_dqCrWhereBO = BeanUtil.toBean(queryParams, DataQuery_dqCrWhereBO.class);
        SurveyQuestionnaire queryResult = surveyQuestionnaireService.selectOne(dataQuery_dqCrWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据计划id和问题类型查询问题列表-数据查询-问卷
    * @return
    */
    @Override
    public SurveyQuestionnaire dataQuery_iKAY(JSONObject paramsJsonContext,QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
            String kcvroScript = "\n\n\nString(u_biz_flow_v2_process_output_param_U_f85f2d3fbdc849d5a8abd65f27f41b6f_u) + \'\';\n";
        List<BlocklyBindParamDto> ampguBindparams = new ArrayList<>();
        String bindKeyuxpug0 = "u_BasicCalculate_U_7dbb43c938a64f2fad8da6ea2dcb919b_u";
        String bindTypervrcm0 = "";
        Object bindValueaafok0 = null;
        BlocklyBindParamDto paramDtoVariableNameqtidf0 = BlocklyBindParamDto.builder()
            .bindValue(bindValueaafok0)
            .bindKey(bindKeyuxpug0)
            .bindType(bindTypervrcm0)
            .build();
        ampguBindparams.add(paramDtoVariableNameqtidf0);
        String bindKeylhkmj1 = "u_biz_flow_v2_process_output_param_U_f85f2d3fbdc849d5a8abd65f27f41b6f_u";
        String bindTypemvpxu1 = "BigInteger";
        Long bindValueotkuw1 = bo.getDataQueryPlan().getQuestionnaireId();
        BlocklyBindParamDto paramDtoVariableNamecvavg1 = BlocklyBindParamDto.builder()
            .bindValue(bindValueotkuw1)
            .bindKey(bindKeylhkmj1)
            .bindType(bindTypemvpxu1)
            .build();
        ampguBindparams.add(paramDtoVariableNamecvavg1);
        Object rnnts0Value = BlocklyUtils.exe(kcvroScript, ampguBindparams);
        Object rnnts0 = rnnts0Value;

        queryParams.put("surveyQuestionnaireId", rnnts0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_iKAYWhereBO dataQuery_iKAYWhereBO = BeanUtil.toBean(queryParams, DataQuery_iKAYWhereBO.class);
        SurveyQuestionnaire queryResult = surveyQuestionnaireService.selectOne(dataQuery_iKAYWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：新增问卷补充问题记录-数据查询-获取问卷信息
    * @return
    */
    @Override
    public SurveyQuestionnaire dataQuery_yeFL(JSONObject paramsJsonContext,AddSupplementaryQuestionnaireQuestionRecordsBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String calcAndConvQuestionnaireID0 = bo.getCalcAndConvQuestionnaireID();
        queryParams.put("surveyQuestionnaireId", calcAndConvQuestionnaireID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_yeFLWhereBO dataQuery_yeFLWhereBO = BeanUtil.toBean(queryParams, DataQuery_yeFLWhereBO.class);
        SurveyQuestionnaire queryResult = surveyQuestionnaireService.selectOne(dataQuery_yeFLWhereBO);
        return queryResult;
    }


}