
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class SurveyPlanAggregateServiceImpl implements SurveyPlanAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPlanService surveyPlanService;


    /**
    * 聚合查询：根据问卷id查询计划-数据查询
    * @return
    */
    @Override
    public SurveyPlan dataQuery_BsWD(JSONObject paramsJsonContext,QueryPlanBasedOnQuestionnaireIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long questionnaireID0 = bo.getQuestionnaireID();
        queryParams.put("surveyPlanQuestionnaireId", questionnaireID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_BsWDWhereBO dataQuery_BsWDWhereBO = BeanUtil.toBean(queryParams, DataQuery_BsWDWhereBO.class);
        SurveyPlan queryResult = surveyPlanService.selectOne(dataQuery_BsWDWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据任务id查询踏勘计划次数-数据查询
    * @return
    */
    @Override
    public List<SurveyPlan> dataQuery_bAiC(JSONObject paramsJsonContext,QueryTheNumOfExplorationPlansBasedOnTskIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long tskID0 = bo.getTskID();
        queryParams.put("surveyPlanTaskId", tskID0);
        Integer stage1 = bo.getStage();
        queryParams.put("surveyPlanSurveyStep", stage1);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_bAiCWhereBO dataQuery_bAiCWhereBO = BeanUtil.toBean(queryParams, DataQuery_bAiCWhereBO.class);
        List<SurveyPlan> queryResult = surveyPlanService.list(dataQuery_bAiCWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据计划id查询计划-数据查询
    * @return
    */
    @Override
    public SurveyPlan dataQuery_aiPC_GqBo(JSONObject paramsJsonContext,QueryPlanBasedOnPlanIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String planID0 = bo.getPlanID();
        queryParams.put("surveyPlanId", planID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_aiPC_GqBoWhereBO dataQuery_aiPC_GqBoWhereBO = BeanUtil.toBean(queryParams, DataQuery_aiPC_GqBoWhereBO.class);
        SurveyPlan queryResult = surveyPlanService.selectOne(dataQuery_aiPC_GqBoWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据计划id和问题类型查询问题列表-数据查询-计划
    * @return
    */
    @Override
    public SurveyPlan dataQuery_zloF(JSONObject paramsJsonContext,QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String planID0 = bo.getPlanID();
        queryParams.put("surveyPlanId", planID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_zloFWhereBO dataQuery_zloFWhereBO = BeanUtil.toBean(queryParams, DataQuery_zloFWhereBO.class);
        SurveyPlan queryResult = surveyPlanService.selectOne(dataQuery_zloFWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据任务id查询最大计划次数-数据查询-倒序查询次数
    * @return
    */
    @Override
    public List<SurveyPlan> dataQuery_okFg(JSONObject paramsJsonContext,QueryMaxNumOfPlansBasedOnTskIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long tskID0 = bo.getTskID();
        queryParams.put("surveyPlanTaskId", tskID0);
        Object ejzoh1 = "2";
        queryParams.put("surveyPlanTaskStatus", ejzoh1);
        Object tnsbv2 = "3";
        queryParams.put("surveyPlanTaskStatus1", tnsbv2);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_okFgWhereBO dataQuery_okFgWhereBO = BeanUtil.toBean(queryParams, DataQuery_okFgWhereBO.class);
        List<SurveyPlan> queryResult = surveyPlanService.list(dataQuery_okFgWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据任务id和次数查询勘查计划-数据查询
    * @return
    */
    @Override
    public List<SurveyPlan> dataQuery_sOdz(JSONObject paramsJsonContext,QueryExplorationPlanBasedOnTskIDAndNumOfTimesBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long tskID0 = bo.getTskID();
        queryParams.put("surveyPlanTaskId", tskID0);
        Object sfpxc1 = "2";
        queryParams.put("surveyPlanTaskStatus", sfpxc1);
        Object qnhtp2 = "3";
        queryParams.put("surveyPlanTaskStatus1", qnhtp2);
        Integer freq3 = bo.getFreq();
        queryParams.put("surveyPlanTime", freq3);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_sOdzWhereBO dataQuery_sOdzWhereBO = BeanUtil.toBean(queryParams, DataQuery_sOdzWhereBO.class);
        List<SurveyPlan> queryResult = surveyPlanService.list(dataQuery_sOdzWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据任务id查询次数列表-数据查询
    * @return
    */
    @Override
    public List<SurveyPlan> dataQuery_CncC(JSONObject paramsJsonContext,LstOfQueryTimesBasedOnTskIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long tskID0 = bo.getTskID();
        queryParams.put("surveyPlanTaskId", tskID0);
        Object imktc1 = "3";
        queryParams.put("surveyPlanTaskStatus1", imktc1);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_CncCWhereBO dataQuery_CncCWhereBO = BeanUtil.toBean(queryParams, DataQuery_CncCWhereBO.class);
        List<SurveyPlan> queryResult = surveyPlanService.list(dataQuery_CncCWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：更新踏勘结果-报告生成未开发-数据查询-未作答题目记录
    * @return
    */
    @Override
    public List<DataqueryAuhnBO> dataQuery_AuHN(JSONObject paramsJsonContext,UpdSurveyResultsReportGenerationUndevelopedBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String planID0 = bo.getPlanID();
        queryParams.put("surveyPlanId", planID0);
        Integer extremelyShortIntegerNo1 = ElementConstants.extremelyShortIntegerNo;
        queryParams.put("surveyInfoReplied", extremelyShortIntegerNo1);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_AuHNWhereBO dataQuery_AuHNWhereBO = BeanUtil.toBean(queryParams, DataQuery_AuHNWhereBO.class);
        List<DataqueryAuhnBO> queryResult = surveyPlanService.list(dataQuery_AuHNWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：问卷设计列表查询-数据查询-计划列表
    * @return
    */
    @Override
    public List<DataqueryRmqqBO> dataQuery_rMQq(JSONObject paramsJsonContext,QuestionnaireDesignLstQueryBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long tskID0 = bo.getTskID();
        queryParams.put("surveyPlanTaskId", tskID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_rMQqWhereBO dataQuery_rMQqWhereBO = BeanUtil.toBean(queryParams, DataQuery_rMQqWhereBO.class);
        List<DataqueryRmqqBO> queryResult = surveyPlanService.list(dataQuery_rMQqWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据年月份查询未完成的任务列表-数据查询
    * @return
    */
    @Override
    public List<DataqueryBcejBO> dataQuery_BcEj(JSONObject paramsJsonContext,QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long userID0 = bo.getUserID();
        queryParams.put("surveyPlanUserId", userID0);
        LocalDateTime calculationStart1 = bo.getCalculationStart();
        queryParams.put("surveyPlanBeginTime", calculationStart1);
        LocalDateTime operationEnd2 = bo.getOperationEnd();
        queryParams.put("surveyPlanEndTime", operationEnd2);
        Object pxcyj3 = "0";
        queryParams.put("surveyPlanTaskStatus", pxcyj3);
        Object afhkf4 = "1";
        queryParams.put("surveyPlanTaskStatus1", afhkf4);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_BcEjWhereBO dataQuery_BcEjWhereBO = BeanUtil.toBean(queryParams, DataQuery_BcEjWhereBO.class);
        List<DataqueryBcejBO> queryResult = surveyPlanService.list(dataQuery_BcEjWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据计划id查询计划详情-数据查询
    * @return
    */
    @Override
    public DataqueryAipcBO dataQuery_aiPC(JSONObject paramsJsonContext,QueryPlanDetailsBasedOnPlanIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String planID0 = bo.getPlanID();
        queryParams.put("surveyPlanId", planID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_aiPCWhereBO dataQuery_aiPCWhereBO = BeanUtil.toBean(queryParams, DataQuery_aiPCWhereBO.class);
        DataqueryAipcBO queryResult = surveyPlanService.selectOne(dataQuery_aiPCWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据计划id查询计划信息-数据查询-踏勘计划
    * @return
    */
    @Override
    public DataqueryGstwBO dataQuery_gsTW(JSONObject paramsJsonContext,QueryPlanInformationBasedOnPlanIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
            String clqjtScript = "\n\n\nNumber(u_biz_flow_v2_input_param_U_77f96994870b4082938baf1cca21e86c_u);\n";
        List<BlocklyBindParamDto> whebpBindparams = new ArrayList<>();
        String bindKeysreuj0 = "u_biz_flow_v2_input_param_U_77f96994870b4082938baf1cca21e86c_u";
        String bindTypegygtp0 = "String";
        String bindValueatrxf0 = bo.getPlanID();
        BlocklyBindParamDto paramDtoVariableNamepkrjt0 = BlocklyBindParamDto.builder()
            .bindValue(bindValueatrxf0)
            .bindKey(bindKeysreuj0)
            .bindType(bindTypegygtp0)
            .build();
        whebpBindparams.add(paramDtoVariableNamepkrjt0);
        Object kqcgt0Value = BlocklyUtils.exe(clqjtScript, whebpBindparams);
        Object kqcgt0 = kqcgt0Value;

        queryParams.put("surveyPlanId", kqcgt0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_gsTWWhereBO dataQuery_gsTWWhereBO = BeanUtil.toBean(queryParams, DataQuery_gsTWWhereBO.class);
        DataqueryGstwBO queryResult = surveyPlanService.selectOne(dataQuery_gsTWWhereBO);
        return queryResult;
    }


}