
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class SurveyPhotoAggregateServiceImpl implements SurveyPhotoAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPhotoService surveyPhotoService;


    /**
    * 聚合查询：根据回答id查询附件列表-数据查询
    * @return
    */
    @Override
    public List<SurveyPhoto> dataQuery_TVAC(JSONObject paramsJsonContext,QueryAttachmentLstBasedOnAnswerIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Integer operation0 = bo.getOperation();
        queryParams.put("surveyPhotoSurveyInfoId", operation0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_TVACWhereBO dataQuery_TVACWhereBO = BeanUtil.toBean(queryParams, DataQuery_TVACWhereBO.class);
        List<SurveyPhoto> queryResult = surveyPhotoService.list(dataQuery_TVACWhereBO);
        return queryResult;
    }


}