
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;




import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class SurveyInfoAggregateServiceImpl implements SurveyInfoAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyInfoService surveyInfoService;


    /**
    * 聚合查询：根据问卷id查询所有问题列表-数据查询
    * @return
    */
    @Override
    public List<DataqueryOouxBO> dataQuery_OouX(JSONObject paramsJsonContext,QueryAllQuestionListsBasedOnQuestionnaireIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        List<DataqueryOouxBO> queryResult = surveyInfoService.dataQuery_OouX();
        return queryResult;
    }


    /**
    * 聚合查询：根据回答id查询问题信息-数据查询-问题详情
    * @return
    */
    @Override
    public DataqueryKbpxBO dataQuery_kBPx(JSONObject paramsJsonContext,QueryQuestionInformationBasedOnAnswerIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String operation0 = bo.getOperation();
        queryParams.put("surveyInfoId", operation0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_kBPxWhereBO dataQuery_kBPxWhereBO = BeanUtil.toBean(queryParams, DataQuery_kBPxWhereBO.class);
        DataqueryKbpxBO queryResult = surveyInfoService.selectOne(dataQuery_kBPxWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：下一题-数据查询-查之后的题目
    * @return
    */
    @Override
    public List<DataqueryVlalBO> dataQuery_VLaL(JSONObject paramsJsonContext,NxtQuestionBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long questionnaireID0 = bo.getQuestionnaireID();
        queryParams.put("surveyInfoQuestionnaireId", questionnaireID0);
        String problemType1 = bo.getProblemType();
        queryParams.put("surveyProjectQuestionType", problemType1);
        Integer serialNum2 = bo.getSerialNum();
        queryParams.put("surveyProjectSort", serialNum2);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_VLaLWhereBO dataQuery_VLaLWhereBO = BeanUtil.toBean(queryParams, DataQuery_VLaLWhereBO.class);
        List<DataqueryVlalBO> queryResult = surveyInfoService.list(dataQuery_VLaLWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：生成问卷-问卷的问题列表
    * @return
    */
    @Override
    public List<SurveyInfo> dataQuery_rLQS(JSONObject paramsJsonContext,GenQuestionnaireBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long questionnaireID0 = bo.getQuestionnaireID();
        queryParams.put("surveyInfoQuestionnaireId", questionnaireID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_rLQSWhereBO dataQuery_rLQSWhereBO = BeanUtil.toBean(queryParams, DataQuery_rLQSWhereBO.class);
        List<SurveyInfo> queryResult = surveyInfoService.list(dataQuery_rLQSWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据计划id和问题类型查询问题列表-数据查询-问题
    * @return
    */
    @Override
    public List<DataqueryGxahBO> dataQuery_gXAH(JSONObject paramsJsonContext,QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String problemType0 = bo.getProblemType();
        queryParams.put("surveyProjectQuestionType", problemType0);
        Integer codeBlk1 = bo.getCodeBlk();
        queryParams.put("surveyInfoQuestionnaireId", codeBlk1);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_gXAHWhereBO dataQuery_gXAHWhereBO = BeanUtil.toBean(queryParams, DataQuery_gXAHWhereBO.class);
        List<DataqueryGxahBO> queryResult = surveyInfoService.list(dataQuery_gXAHWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据计划id和问题类型查询问题列表-数据查询-已答问题
    * @return
    */
    @Override
    public List<DataqueryYsjpBO> dataQuery_YsjP(JSONObject paramsJsonContext,QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Integer theExtremelyShortIntegerIs0 = ElementConstants.theExtremelyShortIntegerIs;
        queryParams.put("surveyInfoReplied", theExtremelyShortIntegerIs0);
        Integer codeBlk1 = bo.getCodeBlk();
        queryParams.put("surveyInfoQuestionnaireId", codeBlk1);
        String problemType2 = bo.getProblemType();
        queryParams.put("surveyProjectQuestionType", problemType2);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_YsjPWhereBO dataQuery_YsjPWhereBO = BeanUtil.toBean(queryParams, DataQuery_YsjPWhereBO.class);
        List<DataqueryYsjpBO> queryResult = surveyInfoService.list(dataQuery_YsjPWhereBO);
        return queryResult;
    }


}