package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
/**
* 当前用户信息设置到缓存
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class SetCurUserInformationToCacheService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "当前用户信息设置到缓存";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private RedisUtil redisService;

    /**
    * 当前用户信息设置到缓存接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(SetCurUserInformationToCacheDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        SetCurUserInformationToCacheBO bo = new SetCurUserInformationToCacheBO();
        if (Objects.isNull(form)) {
            form = new SetCurUserInformationToCacheDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //Redis新增
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, SetCurUserInformationToCacheBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        redisAdded(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, SetCurUserInformationToCacheBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * Redis新增
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void redisAdded(JSONObject paramsJsonContext, SetCurUserInformationToCacheBO executeBO) throws BusinessException {
        log.info("========do set value to redis method=======");
        String taskName = "Redis新增";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        SetCurUserInformationToCacheBO bo = executeBO;
        log.debug("流程名称：{},方法名称: Redis新增,输入参数: {}",processName,JSON.toJSONString(bo));
        boolean success = false;
        String tokenVKey0 = bo.getToken();
        Long tokenVValue0 = bo.getTokenV();
        Long timeout0 = Long.valueOf(-1);
        if (ObjectUtils.isNotEmpty(tokenVKey0)) {
            success = redisService.set(String.valueOf(tokenVKey0), tokenVValue0, timeout0);
        }
        bo.setRedisAdded(success);
        endEvent(paramsJsonContext, executeBO);
    }

}