package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
/**
* 问卷设计列表查询
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QuestionnaireDesignLstQueryService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "问卷设计列表查询";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private QueryTskDetailsService queryTskDetailsService;
    @Autowired
    private SurveyPlanAggregateService surveyPlanAggregateService;
    /**
    * 问卷设计列表查询接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QuestionnaireDesignLstQueryDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QuestionnaireDesignLstQueryBO bo = new QuestionnaireDesignLstQueryBO();
        if (Objects.isNull(form)) {
            form = new QuestionnaireDesignLstQueryDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //同步引用流程
        //参数赋值
        //数据查询-计划列表
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"tskInformation","lstOfSurveyPlans",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("tskInformation",boMap.get("tskInformation"));
                vo.put("lstOfSurveyPlans",boMap.get("lstOfSurveyPlans"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QuestionnaireDesignLstQueryBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        synchronousRefProc(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QuestionnaireDesignLstQueryBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 同步引用流程
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronousRefProc(JSONObject paramsJsonContext, QuestionnaireDesignLstQueryBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        QuestionnaireDesignLstQueryBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                Long personnelID0 = bo.getPersonnelID();
                jsonObjectNewParam.put("personnelID", personnelID0);
                Long tskID1 = bo.getTskID();
                jsonObjectNewParam.put("tskID", tskID1);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronousRefProcExecSub(BeanUtil.mapToBean(jsonObjectNewParam, QueryTskDetailsDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        QueryTskDetailsVO vo = JSON.parseObject(JSON.toJSONString(voObj),QueryTskDetailsVO.class);
        bo.setSynchronousRefProc(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    JSONObject synchronousRefProcExecSub(QueryTskDetailsDTO form) throws BusinessException {
        return queryTskDetailsService.processMainExecute(form);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QuestionnaireDesignLstQueryBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QuestionnaireDesignLstQueryBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Object tskDetailsxupzy0 = bo.getSynchronousRefProc().getTskDetails();
        bo.setTskInformation(tskDetailsxupzy0);
        dataQueryPlanLst(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询-计划列表
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryPlanLst(JSONObject paramsJsonContext, QuestionnaireDesignLstQueryBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-计划列表==taskIdentifier：dataQueryPlanLst==damMethod：dataQuery_rMQq==");
        //调用数据查询
        QuestionnaireDesignLstQueryBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-计划列表,输入参数: {}",processName,JSON.toJSONString(bo));
        List<DataqueryRmqqBO> vo = surveyPlanAggregateService.dataQuery_rMQq(paramsJsonContext,bo);
        bo.setDataQueryPlanLst(vo);
        log.debug("流程名称：{},方法名称: 数据查询-计划列表,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment_hBFu(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_hBFu(JSONObject paramsJsonContext, QuestionnaireDesignLstQueryBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QuestionnaireDesignLstQueryBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        List dataQueryPlanLstdlpmp0 = bo.getDataQueryPlanLst();
        bo.setLstOfSurveyPlans(dataQueryPlanLstdlpmp0);
        endEvent(paramsJsonContext, executeBO);
    }

}