package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 根据区域查询场馆列表
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryVenueLstByRgnService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据区域查询场馆列表";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private VenueInformationAggregateService venueInformationAggregateService;

    /**
    * 根据区域查询场馆列表接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryVenueLstByRgnDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryVenueLstByRgnBO bo = new QueryVenueLstByRgnBO();
        if (Objects.isNull(form)) {
            form = new QueryVenueLstByRgnDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //运算
        //数据查询
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"rsltData",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("rsltData",boMap.get("rsltData"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryVenueLstByRgnBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        operation(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryVenueLstByRgnBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, QueryVenueLstByRgnBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_NIUa==");
        //调用数据查询
        QueryVenueLstByRgnBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        List<VenueInformation> vo = venueInformationAggregateService.dataQuery_NIUa(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryVenueLstByRgnBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryVenueLstByRgnBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        List dataQueryzfzin0 = bo.getDataQuery();
        bo.setRsltData(dataQueryzfzin0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 运算
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operation(JSONObject paramsJsonContext, QueryVenueLstByRgnBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryVenueLstByRgnBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nNumber(u_biz_flow_v2_input_param_U_075f4915c837407781c1a33df2425cef_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_input_param_U_075f4915c837407781c1a33df2425cef_u";
        String bindType0 = "String";
        String bindValue0 = bo.getUserID();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setOperation(vo);
        log.debug("流程名称：{},方法名称: 运算,输出参数: {}",processName,JSON.toJSONString(vo));
        dataQuery(paramsJsonContext, executeBO);
    }

}