package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
/**
* 根据机构Id和类型查询用户列表
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryUserLstBasedOnInstitutionIDAndTypeService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据机构Id和类型查询用户列表";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private QueryCurUserInformationService queryCurUserInformationService;
    @Autowired
    private SurveyUserAggregateService surveyUserAggregateService;    @Autowired
    private RedisUtil redisService;
    /**
    * 根据机构Id和类型查询用户列表接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryUserLstBasedOnInstitutionIDAndTypeDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryUserLstBasedOnInstitutionIDAndTypeBO bo = new QueryUserLstBasedOnInstitutionIDAndTypeBO();
        if (Objects.isNull(form)) {
            form = new QueryUserLstBasedOnInstitutionIDAndTypeDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //Redis查询
        //同步引用流程
        //数据查询
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"userLst",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("userLst",boMap.get("userLst"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryUserLstBasedOnInstitutionIDAndTypeBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        redisQuery(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryUserLstBasedOnInstitutionIDAndTypeBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 同步引用流程
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronousRefProc(JSONObject paramsJsonContext, QueryUserLstBasedOnInstitutionIDAndTypeBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        QueryUserLstBasedOnInstitutionIDAndTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                String personnelID0 = bo.getPersonnelID();
                jsonObjectNewParam.put("personnelID", personnelID0);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronousRefProcExecSub(BeanUtil.mapToBean(jsonObjectNewParam, QueryCurUserInformationDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        QueryCurUserInformationVO vo = JSON.parseObject(JSON.toJSONString(voObj),QueryCurUserInformationVO.class);
        bo.setSynchronousRefProc(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程,输出参数: {}",processName,JSON.toJSONString(vo));
        dataQuery(paramsJsonContext, executeBO);
    }

    JSONObject synchronousRefProcExecSub(QueryCurUserInformationDTO form) throws BusinessException {
        return queryCurUserInformationService.processMainExecute(form);
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, QueryUserLstBasedOnInstitutionIDAndTypeBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_khZh==");
        //调用数据查询
        QueryUserLstBasedOnInstitutionIDAndTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        List<SurveyUser> vo = surveyUserAggregateService.dataQuery_khZh(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * Redis查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void redisQuery(JSONObject paramsJsonContext, QueryUserLstBasedOnInstitutionIDAndTypeBO executeBO) throws BusinessException {
        log.info("========do search value from redis method=======");
        String taskName = "Redis查询";
        String errorSuffix = "[" + processName + "-" + taskName + "]";

        QueryUserLstBasedOnInstitutionIDAndTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: Redis查询,输入参数: {}",processName,JSON.toJSONString(bo));


        String personnelIDKey = bo.getPersonnelID();
        if (ObjectUtils.isEmpty(personnelIDKey)) {
            throw new BusinessException("查询key为空" + errorSuffix);
        }
        String key = String.valueOf(personnelIDKey);
        //获取值
        Object valueObj = redisService.get(key);
        log.info("========do search value from redis method vo : {}",JSON.toJSONString(valueObj));
        if (!ObjectUtils.isEmpty(valueObj)) {
            //类型转换，赋值
            String vo = String.valueOf(valueObj);
            bo.setRedisQuery(vo);
        }
        synchronousRefProc(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryUserLstBasedOnInstitutionIDAndTypeBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryUserLstBasedOnInstitutionIDAndTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        List dataQueryydehe0 = bo.getDataQuery();
        bo.setUserLst(dataQueryydehe0);
        endEvent(paramsJsonContext, executeBO);
    }

}