package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 根据年月份查询未完成的任务列表
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据年月份查询未完成的任务列表";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPlanAggregateService surveyPlanAggregateService;
    @Autowired
    private TskConversionService tskConversionService;
    /**
    * 根据年月份查询未完成的任务列表接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO bo = new QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO();
        if (Objects.isNull(form)) {
            form = new QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //运算-开始
        //运算-结束
        //数据查询
        //循环
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"lstOfUnfinishedPlans","jSONCol",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("lstOfUnfinishedPlans",boMap.get("lstOfUnfinishedPlans"));
                vo.put("jSONCol",boMap.get("jSONCol"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        calculationStart(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        List dataQueryrjnbs0 = bo.getDataQuery();
        bo.setLstOfUnfinishedPlans(dataQueryrjnbs0);
        List looprekfv1 = bo.getLoop();
        bo.setJSONCol(looprekfv1);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_BcEj==");
        //调用数据查询
        QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        List<DataqueryBcejBO> vo = surveyPlanAggregateService.dataQuery_BcEj(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        loop(paramsJsonContext, executeBO);
    }

    /**
    * 循环
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void loop(JSONObject paramsJsonContext, QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO executeBO) throws BusinessException {
        log.info("========执行循环调用过程方法=======");
        QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 循环,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONArray vo = new JSONArray();
        List loopArray = bo.getDataQuery();
        //获取需要循环的内容
        //执行循环
        if (CollectionUtils.isNotEmpty(loopArray)) {
            log.info("=============循环的数据有数据，准备执行循环子流程处理=================");
            for (int i = 0; i < loopArray.size(); i++) {
                //初始化下一个流程需要的data数据
                Map<String, Object> jsonObjectNewParam = new HashMap<>();
        JSONObject item = JSON.parseObject(JSON.toJSONString(loopArray.get(i)), JSONObject.class);
                Object beginTime0 =  item.get("beginTime");
                jsonObjectNewParam.put("start", beginTime0);
                Object endTime1 =  item.get("endTime");
                jsonObjectNewParam.put("end", endTime1);
                Object name2 =  item.get("name");
                jsonObjectNewParam.put("eventName", name2);
                Object id3 =  item.get("id");
                jsonObjectNewParam.put("encodingID", id3);
                Object venueName4 =  item.get("venueName");
                jsonObjectNewParam.put("venueAddr", venueName4);
                Object surveyStep5 =  item.get("surveyStep");
                jsonObjectNewParam.put("activityStage", surveyStep5);
                log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
                JSONObject returnDataJson = tskConversionService.processMainExecute(BeanUtil.mapToBean(jsonObjectNewParam, TskConversionDTO.class, null));
                //取返回结果
                if (null != returnDataJson) {
                    returnDataJson.remove("system_returnBelong");
                    returnDataJson.remove("system_flow_down_file_flag");
                }
                vo.add(returnDataJson);
            }
        } else {
            log.info("=============循环的数据为空，不执行循环子流程处理=================");
        }
        bo.setLoop(vo);
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 运算-开始
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationStart(JSONObject paramsJsonContext, QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-开始,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nu_biz_flow_v2_input_param_U_8adea25e044448998caea49bf61db422_u;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_input_param_U_8adea25e044448998caea49bf61db422_u";
        String bindType0 = "String";
        String bindValue0 = bo.getStartTime();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        LocalDateTime vo = JSON.parseObject(JSON.toJSONString(evalValue),LocalDateTime.class);
        bo.setCalculationStart(vo);
        log.debug("流程名称：{},方法名称: 运算-开始,输出参数: {}",processName,JSON.toJSONString(vo));
        operationEnd(paramsJsonContext, executeBO);
    }

    /**
    * 运算-结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationEnd(JSONObject paramsJsonContext, QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryTheLstOfUnfinishedTasksBasedOnYearAndMonthBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-结束,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nu_biz_flow_v2_input_param_U_4ad6b9bff6854ddd919890e4b68632da_u;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_input_param_U_4ad6b9bff6854ddd919890e4b68632da_u";
        String bindType0 = "String";
        String bindValue0 = bo.getEndTime();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        LocalDateTime vo = JSON.parseObject(JSON.toJSONString(evalValue),LocalDateTime.class);
        bo.setOperationEnd(vo);
        log.debug("流程名称：{},方法名称: 运算-结束,输出参数: {}",processName,JSON.toJSONString(vo));
        dataQuery(paramsJsonContext, executeBO);
    }

}