package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import org.springframework.scheduling.annotation.Async;
/**
* 根据计划id和问题类型查询问题列表
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryProblemLstBasedOnPlanIDAndProblemTypeService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据计划id和问题类型查询问题列表";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPlanAggregateService surveyPlanAggregateService;
    @Autowired
    private SurveyQuestionnaireAggregateService surveyQuestionnaireAggregateService;    @Autowired
    private SurveyInfoAggregateService surveyInfoAggregateService;
    /**
    * 根据计划id和问题类型查询问题列表接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryProblemLstBasedOnPlanIDAndProblemTypeDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo = new QueryProblemLstBasedOnPlanIDAndProblemTypeBO();
        if (Objects.isNull(form)) {
            form = new QueryProblemLstBasedOnPlanIDAndProblemTypeDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询-计划
        //数据查询-问卷
        //代码块
        //数据查询-问题
        //数据查询-已答问题
        //运算-总题数
        //运算-已答题数
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"problemLst","totNumOfQuestions","numOfAnsweredQuestions",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("problemLst",boMap.get("problemLst"));
                vo.put("totNumOfQuestions",boMap.get("totNumOfQuestions"));
                vo.put("numOfAnsweredQuestions",boMap.get("numOfAnsweredQuestions"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryProblemLstBasedOnPlanIDAndProblemTypeBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQueryPlan(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryProblemLstBasedOnPlanIDAndProblemTypeBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询-计划
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryPlan(JSONObject paramsJsonContext, QueryProblemLstBasedOnPlanIDAndProblemTypeBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-计划==taskIdentifier：dataQueryPlan==damMethod：dataQuery_zloF==");
        //调用数据查询
        QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-计划,输入参数: {}",processName,JSON.toJSONString(bo));
        SurveyPlan vo = surveyPlanAggregateService.dataQuery_zloF(paramsJsonContext,bo);
        bo.setDataQueryPlan(vo);
        log.debug("流程名称：{},方法名称: 数据查询-计划,输出参数: {}",processName,JSON.toJSONString(vo));
        dataQueryQuestionnaire(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询-问卷
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryQuestionnaire(JSONObject paramsJsonContext, QueryProblemLstBasedOnPlanIDAndProblemTypeBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-问卷==taskIdentifier：dataQueryQuestionnaire==damMethod：dataQuery_iKAY==");
        //调用数据查询
        QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-问卷,输入参数: {}",processName,JSON.toJSONString(bo));
        SurveyQuestionnaire vo = surveyQuestionnaireAggregateService.dataQuery_iKAY(paramsJsonContext,bo);
        bo.setDataQueryQuestionnaire(vo);
        log.debug("流程名称：{},方法名称: 数据查询-问卷,输出参数: {}",processName,JSON.toJSONString(vo));
        codeBlk(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询-问题
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryQuestion(JSONObject paramsJsonContext, QueryProblemLstBasedOnPlanIDAndProblemTypeBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-问题==taskIdentifier：dataQueryQuestion==damMethod：dataQuery_gXAH==");
        //调用数据查询
        QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-问题,输入参数: {}",processName,JSON.toJSONString(bo));
        List<DataqueryGxahBO> vo = surveyInfoAggregateService.dataQuery_gXAH(paramsJsonContext,bo);
        bo.setDataQueryQuestion(vo);
        log.debug("流程名称：{},方法名称: 数据查询-问题,输出参数: {}",processName,JSON.toJSONString(vo));
        dataQueryAnsweredQuestions(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryProblemLstBasedOnPlanIDAndProblemTypeBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        List dataQueryQuestiontkbms0 = bo.getDataQueryQuestion();
        bo.setProblemLst(dataQueryQuestiontkbms0);
        Integer operationTotNumOfQuestionsqfnbf1 = bo.getOperationTotNumOfQuestions();
        bo.setTotNumOfQuestions(operationTotNumOfQuestionsqfnbf1);
        Integer operationNumOfAnsweredQuestionsfrgoz2 = bo.getOperationNumOfAnsweredQuestions();
        bo.setNumOfAnsweredQuestions(operationNumOfAnsweredQuestionsfrgoz2);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 运算-总题数
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationTotNumOfQuestions(JSONObject paramsJsonContext, QueryProblemLstBasedOnPlanIDAndProblemTypeBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-总题数,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nu_SearchData_U_6b9bb45193304af394a4ccd6eb690536_u.length;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_SearchData_U_6b9bb45193304af394a4ccd6eb690536_u";
        String bindType0 = "List";
        List bindValue0 = bo.getDataQueryQuestion();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setOperationTotNumOfQuestions(vo);
        log.debug("流程名称：{},方法名称: 运算-总题数,输出参数: {}",processName,JSON.toJSONString(vo));
        operationNumOfAnsweredQuestions(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询-已答问题
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryAnsweredQuestions(JSONObject paramsJsonContext, QueryProblemLstBasedOnPlanIDAndProblemTypeBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-已答问题==taskIdentifier：dataQueryAnsweredQuestions==damMethod：dataQuery_YsjP==");
        //调用数据查询
        QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-已答问题,输入参数: {}",processName,JSON.toJSONString(bo));
        List<DataqueryYsjpBO> vo = surveyInfoAggregateService.dataQuery_YsjP(paramsJsonContext,bo);
        bo.setDataQueryAnsweredQuestions(vo);
        log.debug("流程名称：{},方法名称: 数据查询-已答问题,输出参数: {}",processName,JSON.toJSONString(vo));
        operationTotNumOfQuestions(paramsJsonContext, executeBO);
    }

    /**
    * 运算-已答题数
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationNumOfAnsweredQuestions(JSONObject paramsJsonContext, QueryProblemLstBasedOnPlanIDAndProblemTypeBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-已答题数,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nu_SearchData_U_ed83580c9dcb4cda9878941993732a5e_u.length;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_SearchData_U_ed83580c9dcb4cda9878941993732a5e_u";
        String bindType0 = "List";
        List bindValue0 = bo.getDataQueryAnsweredQuestions();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setOperationNumOfAnsweredQuestions(vo);
        log.debug("流程名称：{},方法名称: 运算-已答题数,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 代码块
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void codeBlk(JSONObject paramsJsonContext, QueryProblemLstBasedOnPlanIDAndProblemTypeBO executeBO) throws BusinessException {
        log.info("========执行代码块方法=======");
        QueryProblemLstBasedOnPlanIDAndProblemTypeBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 代码块,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJson = new JSONObject();
        String id0 = bo.getDataQueryQuestionnaire().getId();
        paramsJson.put("questionnaire_id", id0);
        Integer vo = codeBlkCodeBlock(paramsJson);
        bo.setCodeBlk(vo);
        dataQueryQuestion(paramsJsonContext, executeBO);
    }

    /**
     * 代码块执行代码块方法体
     * @param params
     * param questionnaire_id 问卷id
     * @return 返回值
     */
    public Integer codeBlkCodeBlock(JSONObject params) throws BusinessException{
        //自定义代码块逻辑
        
return params.getInteger("questionnaire_id");













    }

}