package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
/**
* 根据父级id查询标签列表
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryLabelLstBasedOnParentIDService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据父级id查询标签列表";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyTagAggregateService surveyTagAggregateService;

    /**
    * 根据父级id查询标签列表接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryLabelLstBasedOnParentIDDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryLabelLstBasedOnParentIDBO bo = new QueryLabelLstBasedOnParentIDBO();
        if (Objects.isNull(form)) {
            form = new QueryLabelLstBasedOnParentIDDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询-标签列表
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"lstOfResultsTags",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("lstOfResultsTags",boMap.get("lstOfResultsTags"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryLabelLstBasedOnParentIDBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQueryTagLst(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryLabelLstBasedOnParentIDBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询-标签列表
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryTagLst(JSONObject paramsJsonContext, QueryLabelLstBasedOnParentIDBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-标签列表==taskIdentifier：dataQueryTagLst==damMethod：dataQuery_eHuG==");
        //调用数据查询
        QueryLabelLstBasedOnParentIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-标签列表,输入参数: {}",processName,JSON.toJSONString(bo));
        List<SurveyTag> vo = surveyTagAggregateService.dataQuery_eHuG(paramsJsonContext,bo);
        bo.setDataQueryTagLst(vo);
        log.debug("流程名称：{},方法名称: 数据查询-标签列表,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryLabelLstBasedOnParentIDBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryLabelLstBasedOnParentIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        List dataQueryTagLstmkagv0 = bo.getDataQueryTagLst();
        bo.setLstOfResultsTags(dataQueryTagLstmkagv0);
        endEvent(paramsJsonContext, executeBO);
    }

}