package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
/**
* 查询当前用户信息
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryCurUserInformationService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "查询当前用户信息";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private RedisUtil redisService;
    @Autowired
    private SurveyUserAggregateService surveyUserAggregateService;
    /**
    * 查询当前用户信息接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryCurUserInformationDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryCurUserInformationBO bo = new QueryCurUserInformationBO();
        if (Objects.isNull(form)) {
            form = new QueryCurUserInformationDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //Redis查询
        //数据查询
        //参数赋值
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"userDetails",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("userDetails",boMap.get("userDetails"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryCurUserInformationBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        redisQuery(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryCurUserInformationBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * Redis查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void redisQuery(JSONObject paramsJsonContext, QueryCurUserInformationBO executeBO) throws BusinessException {
        log.info("========do search value from redis method=======");
        String taskName = "Redis查询";
        String errorSuffix = "[" + processName + "-" + taskName + "]";

        QueryCurUserInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: Redis查询,输入参数: {}",processName,JSON.toJSONString(bo));


        String personnelIDKey = bo.getPersonnelID();
        if (ObjectUtils.isEmpty(personnelIDKey)) {
            throw new BusinessException("查询key为空" + errorSuffix);
        }
        String key = String.valueOf(personnelIDKey);
        //获取值
        Object valueObj = redisService.get(key);
        log.info("========do search value from redis method vo : {}",JSON.toJSONString(valueObj));
        if (!ObjectUtils.isEmpty(valueObj)) {
            //类型转换，赋值
            String vo = String.valueOf(valueObj);
            bo.setRedisQuery(vo);
        }
        dataQuery(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, QueryCurUserInformationBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_emOB==");
        //调用数据查询
        QueryCurUserInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        SurveyUser vo = surveyUserAggregateService.dataQuery_emOB(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryCurUserInformationBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryCurUserInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Object dataQuerywjbbm0 = bo.getDataQuery();
        bo.setUserDetails(dataQuerywjbbm0);
        endEvent(paramsJsonContext, executeBO);
    }

}