package com.wlos.app.bl.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.wlos.app.bl.ParamHandleService;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import java.math.BigDecimal;
import java.util.*;

/**
 * 流程执行参数获取处理实现类
 * @author
 * @date 2024-08-30 17:02:53
 */
@Service
public class ParamHandleServiceImpl implements ParamHandleService{
    private transient Logger log = LoggerFactory.getLogger(getClass());
    Configuration configuration = Configuration.builder().options(Option.DEFAULT_PATH_LEAF_TO_NULL).build();

    @Override
    public Object getParamValue(JSONObject paramsJsonContext, Object paramKey, String paramSourceType) throws BusinessException {
        log.info("==================获取参数值开始=====paramKey:"+paramKey+"=======paramSourceType:"+paramSourceType);
        //如果取值的key为空，则直接返回空值，避免空key取值异常
        if (ObjectUtils.isEmpty(paramKey) || ObjectUtils.isEmpty(paramSourceType)) {
            return null;
        }

        Object paramValue = null;
        if (Constants.INPUT_PARAM_SOURCE_TYPE_0.equals(paramSourceType)) {
            //传入的参数
            try {
                //此处处理路径读取值时，路径不存在的问题
                paramValue = JsonPath.parse(paramsJsonContext.toJSONString(JSONWriter.Feature.WriteMapNullValue), configuration).read(String.valueOf(paramKey));
            } catch (Exception e) {
                paramValue = null;
            }
        } else if (Constants.INPUT_PARAM_SOURCE_TYPE_1.equals(paramSourceType)) {
            //循环参数体
        } else if (Constants.INPUT_PARAM_SOURCE_TYPE_11.equals(paramSourceType)) {
            //数据字典
            try {
                //此处处理路径读取值时，路径不存在的问题
                paramValue = JsonPath.parse(paramsJsonContext.toJSONString(JSONWriter.Feature.WriteMapNullValue), configuration).read(String.valueOf("$.pageParam." + paramKey));
            } catch (Exception e) {
                paramValue = null;
            }
        } else if (Constants.INPUT_PARAM_SOURCE_TYPE_3.equals(paramSourceType)
            || Constants.INPUT_PARAM_SOURCE_TYPE_8.equals(paramSourceType)
            || Constants.INPUT_PARAM_SOURCE_TYPE_12.equals(paramSourceType)
            || Constants.INPUT_PARAM_SOURCE_TYPE_13.equals(paramSourceType)) {
            //固定值，写死的，则直接key获取到的就是值
            paramValue = paramKey;
        } else if (Constants.INPUT_PARAM_SOURCE_TYPE_5.equals(paramSourceType)
                ||Constants.INPUT_PARAM_SOURCE_TYPE_6.equals(paramSourceType)) {
            //固定值，写死的，则直接key获取到的就是值
            paramValue = paramKey;
        } else if (Constants.INPUT_PARAM_SOURCE_TYPE_9.equals(paramSourceType)) {
            paramValue = this.getBlocklyValue(paramsJsonContext, paramKey);
        }

        if (JSON.toJSONString(paramValue).length() > 1000) {
            log.info("======获取参数值结束=====paramKey:" + paramKey + "=====paramSourceType:" + paramSourceType + "=====获取到的值==" + JSON.toJSONString(paramValue).substring(0, 1000));
        } else {
            log.info("======获取参数值结束=====paramKey:" + paramKey + "=====paramSourceType:" + paramSourceType + "=====获取到的值==" +JSON.toJSONString(paramValue));
        }
        return paramValue;
    }

    /**
     * 获取blockly执行结果-非聚合查询中取值
     * @param paramsJsonContext
     * @param paramKey
     * @return
     * @throws BusinessException
     */
    @Override
    public Object getBlocklyValue(JSONObject paramsJsonContext, Object paramKey) throws BusinessException{
        return handelBlockly("1", paramsJsonContext, null, paramKey);
    }

    /**
     * 聚合查询中blockly取值
     * @param paramsJsonContext
     * @param currentData
     * @param paramKey
     * @return
     * @throws BusinessException
     */
    @Override
    public Object getBlocklyValue(JSONObject paramsJsonContext, Object currentData, Object paramKey) throws BusinessException {
        return handelBlockly("2", paramsJsonContext, currentData, paramKey);
    }

    /**
     *
     * @param from 来源：1-非聚合查询来源 2-聚合查询来源
     * @param paramsJsonContext --非聚合查询调用请求参数
     * @param currentData --聚合查询参数
     * @param paramKey blockly计算公式及参数
     * @return
     */
    public Object handelBlockly(String from, JSONObject paramsJsonContext, Object currentData, Object paramKey) {
        try {
            //blockly
            JSONObject paramKeyJson = (JSONObject) paramKey;
            //获取执行脚本
            String script = paramKeyJson.getString("script");
            if (StringUtils.isBlank(script)) {
                return null;
            }
            //获取绑定参数
            JSONArray bindParams = paramKeyJson.getJSONArray("bindParam");
            Map<String, Object> bindings = new HashMap<>();
            Map<String, Object> bindingsListMap = new HashMap<>();
            if (null != bindParams && bindParams.size() > 0) {
                for (int i = 0; i < bindParams.size(); i++) {
                    JSONObject bindParamJson = bindParams.getJSONObject(i);
                    String bindKey = bindParamJson.getString("bindKey");
                    //循环外部参数
                    Object bindValueKey = bindParamJson.get("bindValue");
                    String paramSourceType = bindParamJson.getString("paramSourceType");
                    Object bindValue = null;
                    if ("1".equals(from)) {
                        //非聚合查询取值
                        bindValue = this.getParamValue(paramsJsonContext, bindValueKey, paramSourceType);
                    } else {
                        //聚合查询取值
                        if (Constants.INPUT_PARAM_SOURCE_TYPE_10.equals(paramSourceType)) {
                            bindValue = currentData;
                        } else if (Constants.INPUT_PARAM_SOURCE_TYPE_14.equals(paramSourceType)) {
                            try {
                                bindValue = JsonPath.read(currentData, String.valueOf(bindValueKey));
                            } catch (Exception e){
                            }
                        } else {
                            bindValue = this.getParamValue(paramsJsonContext, bindValueKey, paramSourceType);
                        }
                    }
                    log.info("bindKey===" + bindKey + "=====bindValue====" + bindValue);
                    //获取参数类型：根据参数的类型转换值：如果值类型是字符串的话，运算会a+b会变成字符串的拼接而不是数值运算
                    String bindType = bindParamJson.getString("bindType");
                    bindValue = ProcessUtil.transValueType(bindValue, bindType);
                    //判断参数类型，如果是数组或者集合参数，则拼接到script中传入，非以上类型，则bingings类型传入
                    if (null!=bindValue && (bindValue instanceof List || bindValue.getClass().isArray() || bindValue instanceof JSONObject || bindValue instanceof JSONArray)) {
                        bindingsListMap.put(bindKey, bindValue);
                    } else {
                        if (null == bindValue || "".equals(bindValue)) {
                            if (Constants.DM_DATA_TYPE_AMOUNT.equals(bindType)
                                    || Constants.DM_DATA_TYPE_DECIMAL.equals(bindType)
                                    || Constants.DM_DATA_TYPE_DOUBLE.equals(bindType)
                                    || Constants.DM_DATA_TYPE_INTEGER.equals(bindType)
                            ) {
                                bindValue = BigDecimal.ZERO;
                            } else {
                                bindValue = "";
                            }
                        }
                        bindings.put(bindKey, bindValue);
                    }
                }
            }

            //执行脚本语言
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("nashorn");
            Object evalValue = engine.eval(bindingsListMap + ";" + script, new SimpleBindings(bindings));
            log.info("=====blockly js执行输出的结果====" + JSON.toJSONString(evalValue));
            boolean isArray = false;
            //js执行返回的结果是ScriptObjectMirror类型
            if (evalValue instanceof ScriptObjectMirror) {
                ScriptObjectMirror som = (ScriptObjectMirror) evalValue;
                if (som.isArray()) {
                    isArray = true;
                }
            }
            if (isArray) {
                List<Object> list = new ArrayList<>();
                ScriptObjectMirror mirror = (ScriptObjectMirror) evalValue;
                for (Map.Entry<String, Object> entry : mirror.entrySet()) {
                    Object result = entry.getValue();
                    if (result instanceof ScriptObjectMirror) {
                        list.add(result);
                    } else {
                        list.add(result);
                    }
                }
                evalValue = list;
            }
            return evalValue;
        } catch (Exception e) {
            log.error("操作异常", "运算失败");
            throw new BusinessException("赋值blockly类型处理失败", e);
        }
    }

    /**
    *
    * @param paramValue
    * @return
    */
    public Object handelParamSpecialCharacters(Object paramValue){
        try {
            if (null == paramValue || "".equals(paramValue)) {
                return paramValue;
            }
            if (paramValue instanceof String) {
                String value = String.valueOf(paramValue);
                value = value.replace("&lt;", "<");
                value = value.replace("&gt;", ">");
                value = value.replace("&amp;", "&");
                value = value.replace("&apos;", "'");
                value = value.replace("&quot;", "\"");
                paramValue = value;
            }
        } catch (Exception e) {
            log.debug("处理特殊字符失败", e);
        }
        return paramValue;
    }

}