package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.da.service.SurveyAssistService;
import com.wlos.app.bo.*;
/**
* 新增申请专家审批
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class NewAppForExpertApprovalService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "新增申请专家审批";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private RedisUtil redisService;
    @Autowired
    private SurveyAssistService surveyAssistService;
    /**
    * 新增申请专家审批接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(NewAppForExpertApprovalDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        NewAppForExpertApprovalBO bo = new NewAppForExpertApprovalBO();
        if (Objects.isNull(form)) {
            form = new NewAppForExpertApprovalDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //Redis查询当前用户
        //数据新增
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, NewAppForExpertApprovalBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        redisQueryCurUser(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, NewAppForExpertApprovalBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * Redis查询当前用户
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void redisQueryCurUser(JSONObject paramsJsonContext, NewAppForExpertApprovalBO executeBO) throws BusinessException {
        log.info("========do search value from redis method=======");
        String taskName = "Redis查询当前用户";
        String errorSuffix = "[" + processName + "-" + taskName + "]";

        NewAppForExpertApprovalBO bo = executeBO;
        log.debug("流程名称：{},方法名称: Redis查询当前用户,输入参数: {}",processName,JSON.toJSONString(bo));


        String personnelIDKey = bo.getPersonnelID();
        if (ObjectUtils.isEmpty(personnelIDKey)) {
            throw new BusinessException("查询key为空" + errorSuffix);
        }
        String key = String.valueOf(personnelIDKey);
        //获取值
        Object valueObj = redisService.get(key);
        log.info("========do search value from redis method vo : {}",JSON.toJSONString(valueObj));
        if (!ObjectUtils.isEmpty(valueObj)) {
            //类型转换，赋值
            Long vo = Long.parseLong(String.valueOf(valueObj));
            bo.setRedisQueryCurUser(vo);
        }
        dataAddition(paramsJsonContext, executeBO);
    }

    /**
    * 数据新增
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAddition(JSONObject paramsJsonContext, NewAppForExpertApprovalBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        NewAppForExpertApprovalBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        Long aawvc0 = 0L;
        paramMap.put("assignStatus", aawvc0);
        Object frctc1 = "1";
        paramMap.put("assignType", frctc1);
        String reasonForApp2 = bo.getReasonForApp();
        paramMap.put("reason", reasonForApp2);
        Long tskId3 = bo.getTskId();
        paramMap.put("taskId", tskId3);
        Long redisQueryCurUser4 = bo.getRedisQueryCurUser();
        paramMap.put("userId", redisQueryCurUser4);
        String explorationStage5 = bo.getExplorationStage();
        paramMap.put("surveyStep", explorationStage5);
        List expertID6 = bo.getExpertID();
        paramMap.put("experts", expertID6);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        SurveyAssistBO surveyAssistBO = BeanUtil.mapToBean(paramMap, SurveyAssistBO.class, null);
        String vo = surveyAssistService.insert(surveyAssistBO);
        bo.setDataAddition(vo);
        log.debug("流程名称：{},方法名称: 数据新增,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

}