package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.bo.where.*;
import com.wlos.app.da.service.SurveyFeedbackService;
import com.wlos.app.bo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import com.wlos.app.da.service.SurveyQuestionnaireService;
import com.wlos.app.da.service.SurveyPlanService;
/**
* 修改计划
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class ModifyPlanService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "修改计划";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private QueryPlanBasedOnPlanIDService queryPlanBasedOnPlanIDService;
    @Autowired
    private SurveyFeedbackService surveyFeedbackService;    @Autowired
    private SurveyQuestionnaireService surveyQuestionnaireService;    @Autowired
    private SurveyPlanService surveyPlanService;
    /**
    * 修改计划接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(ModifyPlanDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        ModifyPlanBO bo = new ModifyPlanBO();
        if (Objects.isNull(form)) {
            form = new ModifyPlanDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //同步引用流程
        //运算-查勘反馈id转换
        //运算-当前时间
        //数据修改-查勘反馈
        //运算-问卷id转换
        //数据修改-问卷
        //数据修改-计划
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, ModifyPlanBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        synchronousRefProc(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, ModifyPlanBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 同步引用流程
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronousRefProc(JSONObject paramsJsonContext, ModifyPlanBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        ModifyPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                Long planID0 = bo.getPlanID();
                jsonObjectNewParam.put("planID", planID0);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronousRefProcExecSub(BeanUtil.mapToBean(jsonObjectNewParam, QueryPlanBasedOnPlanIDDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        QueryPlanBasedOnPlanIDVO vo = JSON.parseObject(JSON.toJSONString(voObj),QueryPlanBasedOnPlanIDVO.class);
        bo.setSynchronousRefProc(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程,输出参数: {}",processName,JSON.toJSONString(vo));
        operationSurveyFeedbackIDConversion(paramsJsonContext, executeBO);
    }

    JSONObject synchronousRefProcExecSub(QueryPlanBasedOnPlanIDDTO form) throws BusinessException {
        return queryPlanBasedOnPlanIDService.processMainExecute(form);
    }

    /**
    * 数据修改-查勘反馈
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModificationSurveyFeedback(JSONObject paramsJsonContext, ModifyPlanBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        ModifyPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改-查勘反馈,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                Integer explorationPhase0 = bo.getExplorationPhase();
                paramMap.put("surveyStep", explorationPhase0);
                LocalDateTime operationCurTime1 = bo.getOperationCurTime();
                paramMap.put("modificationTime", operationCurTime1);

        JSONObject whereParamMap = new JSONObject();
                String operationSurveyFeedbackIDConversion2 = bo.getOperationSurveyFeedbackIDConversion();
                whereParamMap.put("surveyFeedbackId", operationSurveyFeedbackIDConversion2);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyFeedbackBO surveyFeedbackBO = BeanUtil.mapToBean(paramMap, SurveyFeedbackBO.class, null);
        ModifyplandataModificationSurveyFeedbackWhereBO modifyplandataModificationSurveyFeedbackWhereBO = BeanUtil.mapToBean(whereParamMap, ModifyplandataModificationSurveyFeedbackWhereBO.class, null);
        Integer vo = surveyFeedbackService.update(surveyFeedbackBO, modifyplandataModificationSurveyFeedbackWhereBO);
        bo.setDataModificationSurveyFeedback(vo);
        log.debug("流程名称：{},方法名称: 数据修改-查勘反馈,输出参数: {}",processName,JSON.toJSONString(vo));
        calculationQuestionnaireIDConversion(paramsJsonContext, executeBO);
    }

    /**
    * 运算-查勘反馈id转换
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationSurveyFeedbackIDConversion(JSONObject paramsJsonContext, ModifyPlanBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        ModifyPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-查勘反馈id转换,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nu_biz_flow_v2_process_output_param_U_054661fa68b6414fa7f7a2d603af2b00_u;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_process_output_param_U_054661fa68b6414fa7f7a2d603af2b00_u";
        String bindType0 = "BigInteger";
        Long bindValue0 = bo.getSynchronousRefProc().getPlanDetails_gKDF().getFeedbackId();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setOperationSurveyFeedbackIDConversion(vo);
        log.debug("流程名称：{},方法名称: 运算-查勘反馈id转换,输出参数: {}",processName,JSON.toJSONString(vo));
        operationCurTime(paramsJsonContext, executeBO);
    }

    /**
    * 运算-当前时间
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationCurTime(JSONObject paramsJsonContext, ModifyPlanBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        ModifyPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-当前时间,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "function mGetCurrentDateTime(){\n              var date = new Date();\n              var year = date.getFullYear();\n              var month = date.getMonth()+1;\n              var dates = date.getDate();\n              var hours = date.getHours();\n              var minutes = date.getMinutes();\n              var seconds = date.getSeconds();\n              month = month < 10 ? \'0\' + month : month;\n              dates = dates < 10 ? \'0\' + dates : dates;\n              hours = hours < 10 ? \'0\' + hours : hours;\n              minutes = minutes < 10 ? \'0\' + minutes : minutes;\n              seconds = seconds < 10 ? \'0\' + seconds : seconds;\n              return String(year + \'-\' + month + \'-\' + dates + \' \' + hours + \':\' + minutes + \':\' + seconds);\n          };\n\n\nreturn mGetCurrentDateTime();\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        LocalDateTime vo = JSON.parseObject(JSON.toJSONString(evalValue),LocalDateTime.class);
        bo.setOperationCurTime(vo);
        log.debug("流程名称：{},方法名称: 运算-当前时间,输出参数: {}",processName,JSON.toJSONString(vo));
        dataModificationSurveyFeedback(paramsJsonContext, executeBO);
    }

    /**
    * 数据修改-问卷
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModificationQuestionnaire(JSONObject paramsJsonContext, ModifyPlanBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        ModifyPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改-问卷,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                LocalDateTime operationCurTime0 = bo.getOperationCurTime();
                paramMap.put("modificationTime", operationCurTime0);
                LocalDateTime startTime1 = bo.getStartTime();
                paramMap.put("beginTime", startTime1);
                LocalDateTime endTime2 = bo.getEndTime();
                paramMap.put("endTime", endTime2);
                Integer explorationPhase3 = bo.getExplorationPhase();
                paramMap.put("surveyStep", explorationPhase3);
                Long siteId4 = bo.getSiteId();
                paramMap.put("venueId", siteId4);
                Long questionnaireId5 = bo.getSynchronousRefProc().getPlanDetails_gKDF().getQuestionnaireId();
                paramMap.put("feedbackId", questionnaireId5);

        JSONObject whereParamMap = new JSONObject();
                String calculationQuestionnaireIDConversion6 = bo.getCalculationQuestionnaireIDConversion();
                whereParamMap.put("surveyQuestionnaireId", calculationQuestionnaireIDConversion6);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyQuestionnaireBO surveyQuestionnaireBO = BeanUtil.mapToBean(paramMap, SurveyQuestionnaireBO.class, null);
        ModifyplandataModificationQuestionnaireWhereBO modifyplandataModificationQuestionnaireWhereBO = BeanUtil.mapToBean(whereParamMap, ModifyplandataModificationQuestionnaireWhereBO.class, null);
        Integer vo = surveyQuestionnaireService.update(surveyQuestionnaireBO, modifyplandataModificationQuestionnaireWhereBO);
        bo.setDataModificationQuestionnaire(vo);
        log.debug("流程名称：{},方法名称: 数据修改-问卷,输出参数: {}",processName,JSON.toJSONString(vo));
        dataModificationPlan(paramsJsonContext, executeBO);
    }

    /**
    * 运算-问卷id转换
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationQuestionnaireIDConversion(JSONObject paramsJsonContext, ModifyPlanBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        ModifyPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-问卷id转换,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nu_biz_flow_v2_process_output_param_U_c71a1fd501814c498bd01c69bc0feb6b_u;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_process_output_param_U_c71a1fd501814c498bd01c69bc0feb6b_u";
        String bindType0 = "BigInteger";
        Long bindValue0 = bo.getSynchronousRefProc().getPlanDetails_gKDF().getQuestionnaireId();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setCalculationQuestionnaireIDConversion(vo);
        log.debug("流程名称：{},方法名称: 运算-问卷id转换,输出参数: {}",processName,JSON.toJSONString(vo));
        dataModificationQuestionnaire(paramsJsonContext, executeBO);
    }

    /**
    * 数据修改-计划
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModificationPlan(JSONObject paramsJsonContext, ModifyPlanBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        ModifyPlanBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改-计划,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                Integer explorationFreq0 = bo.getExplorationFreq();
                paramMap.put("time", explorationFreq0);
                Long siteId1 = bo.getSiteId();
                paramMap.put("venueId", siteId1);
                Integer explorationPhase2 = bo.getExplorationPhase();
                paramMap.put("surveyStep", explorationPhase2);
                LocalDateTime startTime3 = bo.getStartTime();
                paramMap.put("beginTime", startTime3);
                LocalDateTime endTime4 = bo.getEndTime();
                paramMap.put("endTime", endTime4);
                Boolean isItAllDayLong5 = bo.getIsItAllDayLong();
                paramMap.put("allDay", isItAllDayLong5);
                LocalDateTime operationCurTime6 = bo.getOperationCurTime();
                paramMap.put("modificationTime", operationCurTime6);

        JSONObject whereParamMap = new JSONObject();
                String id7 = bo.getSynchronousRefProc().getPlanDetails_gKDF().getId();
                whereParamMap.put("surveyPlanId", id7);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyPlanBO surveyPlanBO = BeanUtil.mapToBean(paramMap, SurveyPlanBO.class, null);
        ModifyplandataModificationPlanWhereBO modifyplandataModificationPlanWhereBO = BeanUtil.mapToBean(whereParamMap, ModifyplandataModificationPlanWhereBO.class, null);
        Integer vo = surveyPlanService.update(surveyPlanBO, modifyplandataModificationPlanWhereBO);
        bo.setDataModificationPlan(vo);
        log.debug("流程名称：{},方法名称: 数据修改-计划,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

}