package com.wlos.app.bl.impl;

import com.wlos.app.bl.ParseService;
import com.alibaba.fastjson.serializer.AfterFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.UnaryOperator;

import static com.alibaba.fastjson.serializer.SerializerFeature.WriteDateUseDateFormat;

@Service
public class JsonParseService implements ParseService {

    @Override
    public boolean support(String fileType) {
        return "json".equalsIgnoreCase(fileType);
    }

    @Override
    public List<Object> parse(Class<Object> clazz, byte[] file) throws Exception {
        return JSON.parseArray(new String(file, StandardCharsets.UTF_8), clazz);
    }

    @Override
    public byte[] importTemplate(Class<Object> clazz) {
        return new byte[0];
    }

    @Override
    public byte[] exportModel(Class<Object> clazz, List<Object> list, List<String> headers, UnaryOperator<Object> fun) {

        var statusFilter = new AfterFilter() {
            @Override
            public void writeAfter(Object object) {
                fun.apply(null);
            }
        };

        return JSON.toJSONString(
                list,
                new SerializeFilter[]{new SimplePropertyPreFilter(headers.toArray(new String[0])), statusFilter},
                WriteDateUseDateFormat
        ).getBytes(StandardCharsets.UTF_8);
    }
}