package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.where.*;
import com.wlos.app.da.service.SurveyPlanService;
import com.wlos.app.da.service.SurveyQuestionnaireService;
/**
* 生成问卷
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class GenQuestionnaireService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "生成问卷";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyInfoAggregateService surveyInfoAggregateService;
    @Autowired
    private SurveyProjectTempAggregateService surveyProjectTempAggregateService;    @Autowired
    private AddQuestionnaireQuestionRecordService addQuestionnaireQuestionRecordService;    @Autowired
    private SurveyQuestionnaireAggregateService surveyQuestionnaireAggregateService;    @Autowired
    private DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDService delCorrespondingRecordsBasedOnQuestionnaireQuestionIDService;    @Autowired
    private GatewayMatchService gatewayMatchService;    @Autowired
    private SurveyPlanService surveyPlanService;    @Autowired
    private SurveyQuestionnaireService surveyQuestionnaireService;
    /**
    * 生成问卷接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(GenQuestionnaireDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        GenQuestionnaireBO bo = new GenQuestionnaireBO();
        if (Objects.isNull(form)) {
            form = new GenQuestionnaireDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //问卷的问题列表
        //分支
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        questionnaireQuestionLst(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 问卷的问题列表
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void questionnaireQuestionLst(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：问卷的问题列表==taskIdentifier：questionnaireQuestionLst==damMethod：dataQuery_rLQS==");
        //调用数据查询
        GenQuestionnaireBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 问卷的问题列表,输入参数: {}",processName,JSON.toJSONString(bo));
        List<SurveyInfo> vo = surveyInfoAggregateService.dataQuery_rLQS(paramsJsonContext,bo);
        bo.setQuestionnaireQuestionLst(vo);
        log.debug("流程名称：{},方法名称: 问卷的问题列表,输出参数: {}",processName,JSON.toJSONString(vo));
        branch(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询-问卷暂存问题
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryQuestionnaireTmpStgQuestion(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-问卷暂存问题==taskIdentifier：dataQueryQuestionnaireTmpStgQuestion==damMethod：dataQuery_YsMU==");
        //调用数据查询
        GenQuestionnaireBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-问卷暂存问题,输入参数: {}",processName,JSON.toJSONString(bo));
        List<SurveyProjectTemp> vo = surveyProjectTempAggregateService.dataQuery_YsMU(paramsJsonContext,bo);
        bo.setDataQueryQuestionnaireTmpStgQuestion(vo);
        log.debug("流程名称：{},方法名称: 数据查询-问卷暂存问题,输出参数: {}",processName,JSON.toJSONString(vo));
        circularAdditionOfTmpStgQuestionsToTheQuestionnaire(paramsJsonContext, executeBO);
    }

    /**
    * 循环新增暂存问题到问卷
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void circularAdditionOfTmpStgQuestionsToTheQuestionnaire(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行循环调用过程方法=======");
        GenQuestionnaireBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 循环新增暂存问题到问卷,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONArray vo = new JSONArray();
        List loopArray = bo.getDataQueryQuestionnaireTmpStgQuestion();
        //获取需要循环的内容
        //执行循环
        if (CollectionUtils.isNotEmpty(loopArray)) {
            log.info("=============循环的数据有数据，准备执行循环子流程处理=================");
            for (int i = 0; i < loopArray.size(); i++) {
                //初始化下一个流程需要的data数据
                Map<String, Object> jsonObjectNewParam = new HashMap<>();
        JSONObject item = JSON.parseObject(JSON.toJSONString(loopArray.get(i)), JSONObject.class);
                Object questionType0 =  item.get("questionType");
                jsonObjectNewParam.put("problemType", questionType0);
                Object sort1 =  item.get("sort");
                jsonObjectNewParam.put("sort", sort1);
                Object answerTip2 =  item.get("answerTip");
                jsonObjectNewParam.put("tips", answerTip2);
                Object aid3 =  item.get("aid");
                jsonObjectNewParam.put("problemID", aid3);
                String surveyStep4 = bo.getDataQueryQuestionnaireInformation().getSurveyStep();
                jsonObjectNewParam.put("explorationPhase", surveyStep4);
                Object questionnaireId5 =  item.get("questionnaireId");
                jsonObjectNewParam.put("questionnaireID", questionnaireId5);
                Object question6 =  item.get("question");
                jsonObjectNewParam.put("problem", question6);
                log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
                JSONObject returnDataJson = addQuestionnaireQuestionRecordService.processMainExecute(BeanUtil.mapToBean(jsonObjectNewParam, AddQuestionnaireQuestionRecordDTO.class, null));
                //取返回结果
                if (null != returnDataJson) {
                    returnDataJson.remove("system_returnBelong");
                    returnDataJson.remove("system_flow_down_file_flag");
                }
                vo.add(returnDataJson);
            }
        } else {
            log.info("=============循环的数据为空，不执行循环子流程处理=================");
        }
        bo.setCircularAdditionOfTmpStgQuestionsToTheQuestionnaire(vo);
        dataModificationPlanSts(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询-问卷信息
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQueryQuestionnaireInformation(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询-问卷信息==taskIdentifier：dataQueryQuestionnaireInformation==damMethod：dataQuery_dqCr==");
        //调用数据查询
        GenQuestionnaireBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询-问卷信息,输入参数: {}",processName,JSON.toJSONString(bo));
        SurveyQuestionnaire vo = surveyQuestionnaireAggregateService.dataQuery_dqCr(paramsJsonContext,bo);
        bo.setDataQueryQuestionnaireInformation(vo);
        log.debug("流程名称：{},方法名称: 数据查询-问卷信息,输出参数: {}",processName,JSON.toJSONString(vo));
        dataQueryQuestionnaireTmpStgQuestion(paramsJsonContext, executeBO);
    }

    /**
    * 循环
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void loop(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行循环调用过程方法=======");
        GenQuestionnaireBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 循环,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONArray vo = new JSONArray();
        List loopArray = bo.getQuestionnaireQuestionLst();
        //获取需要循环的内容
        //执行循环
        if (CollectionUtils.isNotEmpty(loopArray)) {
            log.info("=============循环的数据有数据，准备执行循环子流程处理=================");
            for (int i = 0; i < loopArray.size(); i++) {
                //初始化下一个流程需要的data数据
                Map<String, Object> jsonObjectNewParam = new HashMap<>();
        JSONObject item = JSON.parseObject(JSON.toJSONString(loopArray.get(i)), JSONObject.class);
                Object id0 =  item.get("id");
                jsonObjectNewParam.put("questionnaireQuestionID", id0);
                Object reformId1 =  item.get("reformId");
                jsonObjectNewParam.put("rectificationID", reformId1);
                log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
                JSONObject returnDataJson = delCorrespondingRecordsBasedOnQuestionnaireQuestionIDService.processMainExecute(BeanUtil.mapToBean(jsonObjectNewParam, DelCorrespondingRecordsBasedOnQuestionnaireQuestionIDDTO.class, null));
                //取返回结果
                if (null != returnDataJson) {
                    returnDataJson.remove("system_returnBelong");
                    returnDataJson.remove("system_flow_down_file_flag");
                }
                vo.add(returnDataJson);
            }
        } else {
            log.info("=============循环的数据为空，不执行循环子流程处理=================");
        }
        bo.setLoop(vo);
        dataQueryQuestionnaireInformation(paramsJsonContext, executeBO);
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchLoop(paramsJsonContext, executeBO)){
            loop(paramsJsonContext, executeBO);
        }
        else {
            dataQueryQuestionnaireInformation(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchLoop(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            GenQuestionnaireBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            List questionnaireQuestionLst = bo.getQuestionnaireQuestionLst();
            boolean matchState = (((ObjectUtils.isNotEmpty(questionnaireQuestionLst))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 数据修改-计划状态
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModificationPlanSts(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        GenQuestionnaireBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改-计划状态,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                Object lukle0 = "1";
                paramMap.put("taskStatus", lukle0);

        JSONObject whereParamMap = new JSONObject();
                Long questionnaireID1 = bo.getQuestionnaireID();
                whereParamMap.put("surveyPlanQuestionnaireId", questionnaireID1);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyPlanBO surveyPlanBO = BeanUtil.mapToBean(paramMap, SurveyPlanBO.class, null);
        GenquestionnairedataModificationPlanStsWhereBO genquestionnairedataModificationPlanStsWhereBO = BeanUtil.mapToBean(whereParamMap, GenquestionnairedataModificationPlanStsWhereBO.class, null);
        Integer vo = surveyPlanService.update(surveyPlanBO, genquestionnairedataModificationPlanStsWhereBO);
        bo.setDataModificationPlanSts(vo);
        log.debug("流程名称：{},方法名称: 数据修改-计划状态,输出参数: {}",processName,JSON.toJSONString(vo));
        dataModificationQuestionnaireSts(paramsJsonContext, executeBO);
    }

    /**
    * 数据修改-问卷状态
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModificationQuestionnaireSts(JSONObject paramsJsonContext, GenQuestionnaireBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        GenQuestionnaireBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改-问卷状态,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                Object xekdc0 = "1";
                paramMap.put("taskStatus", xekdc0);
                Object meykp1 = "true";
                paramMap.put("generate", meykp1);

        JSONObject whereParamMap = new JSONObject();
                    String aluyoScript = "\n\n\nString(u_biz_flow_v2_input_param_U_8636fc8311864a21a8482f86d086c128_u) + \'\';\n";
        List<BlocklyBindParamDto> jjghwBindparams = new ArrayList<>();
        String bindKeyynodl0 = "u_biz_flow_v2_input_param_U_8636fc8311864a21a8482f86d086c128_u";
        String bindTypeflokq0 = "BigInteger";
        Long bindValuekhdpt0 = bo.getQuestionnaireID();
        BlocklyBindParamDto paramDtoVariableNameroxyc0 = BlocklyBindParamDto.builder()
            .bindValue(bindValuekhdpt0)
            .bindKey(bindKeyynodl0)
            .bindType(bindTypeflokq0)
            .build();
        jjghwBindparams.add(paramDtoVariableNameroxyc0);
        Object ocbgp2Value = BlocklyUtils.exe(aluyoScript, jjghwBindparams);
        Object ocbgp2 = ocbgp2Value;

                whereParamMap.put("surveyQuestionnaireId", ocbgp2);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyQuestionnaireBO surveyQuestionnaireBO = BeanUtil.mapToBean(paramMap, SurveyQuestionnaireBO.class, null);
        GenquestionnairedataModificationQuestionnaireStsWhereBO genquestionnairedataModificationQuestionnaireStsWhereBO = BeanUtil.mapToBean(whereParamMap, GenquestionnairedataModificationQuestionnaireStsWhereBO.class, null);
        Integer vo = surveyQuestionnaireService.update(surveyQuestionnaireBO, genquestionnairedataModificationQuestionnaireStsWhereBO);
        bo.setDataModificationQuestionnaireSts(vo);
        log.debug("流程名称：{},方法名称: 数据修改-问卷状态,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

}