package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.bo.where.*;
import com.wlos.app.da.service.SurveyPhotoService;
/**
* 删除附件
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class DelAttachmentsService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "删除附件";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPhotoService surveyPhotoService;
    @Autowired
    private GatewayMatchService gatewayMatchService;
    /**
    * 删除附件接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(DelAttachmentsDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        DelAttachmentsBO bo = new DelAttachmentsBO();
        if (Objects.isNull(form)) {
            form = new DelAttachmentsDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //分支
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, DelAttachmentsBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        branch(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, DelAttachmentsBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据删除
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataDeletion(JSONObject paramsJsonContext, DelAttachmentsBO executeBO) throws BusinessException {
        log.info("========执行数据删除方法=======");
        DelAttachmentsBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据删除,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
        String attachmentID0 = bo.getAttachmentID();
        paramMap.put("surveyPhotoId", attachmentID0);
        //调用数据删除
        log.info("============dm params===" + paramMap.toJSONString());
        //获取返回数据存在的key值
        DelattachmentsdataDeletionWhereBO delattachmentsdataDeletionWhereBO = BeanUtil.mapToBean(paramMap, DelattachmentsdataDeletionWhereBO.class, null);
        Integer vo = surveyPhotoService.delete(delattachmentsdataDeletionWhereBO);
        bo.setDataDeletion(vo);
        log.debug("流程名称：{},方法名称: 数据删除,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, DelAttachmentsBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchDataDeletion(paramsJsonContext, executeBO)){
            dataDeletion(paramsJsonContext, executeBO);
        }
        else {
            endEvent(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchDataDeletion(JSONObject paramsJsonContext, DelAttachmentsBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            DelAttachmentsBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            String attachmentID = bo.getAttachmentID();
            boolean matchState = (((ObjectUtils.isNotEmpty(attachmentID))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

}