
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class BaseOpenIssueAggregateServiceImpl implements BaseOpenIssueAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private BaseOpenIssueService baseOpenIssueService;


    /**
    * 聚合查询：暂存固定和开放问题-数据查询开发
    * @return
    */
    @Override
    public List<BaseOpenIssue> dataQuery_vikA(JSONObject paramsJsonContext,TmpStgOfFixedAndOpenIssuesBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
            String viffcScript = "\n\n\nu_biz_flow_v2_input_param_U_c62eba9821924f68ad590e357483a12b_u;\n";
        List<BlocklyBindParamDto> xosfkBindparams = new ArrayList<>();
        String bindKeyzwnid0 = "u_biz_flow_v2_input_param_U_c62eba9821924f68ad590e357483a12b_u";
        String bindTypeiipbe0 = "List";
        List bindValueszcut0 = bo.getProblemIDLst();
        BlocklyBindParamDto paramDtoVariableNameosxgm0 = BlocklyBindParamDto.builder()
            .bindValue(bindValueszcut0)
            .bindKey(bindKeyzwnid0)
            .bindType(bindTypeiipbe0)
            .build();
        xosfkBindparams.add(paramDtoVariableNameosxgm0);
        Object cskwk0Value = BlocklyUtils.exe(viffcScript, xosfkBindparams);
        Object cskwk0 = cskwk0Value;

        queryParams.put("baseOpenIssueId", cskwk0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_vikAWhereBO dataQuery_vikAWhereBO = BeanUtil.toBean(queryParams, DataQuery_vikAWhereBO.class);
        List<BaseOpenIssue> queryResult = baseOpenIssueService.list(dataQuery_vikAWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据层级和名称查询开放问题列表-数据查询
    * @return
    */
    @Override
    public List<BaseOpenIssue> dataQuery_hYiG(JSONObject paramsJsonContext,QueryOpenQuestionLstBasedOnHierarchyAndNameBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String name0 = bo.getName();
        queryParams.put("baseOpenIssueTagOne", name0);
        String name1 = bo.getName();
        queryParams.put("baseOpenIssueTagTwo", name1);
        String name2 = bo.getName();
        queryParams.put("baseOpenIssueTagThire", name2);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_hYiGWhereBO dataQuery_hYiGWhereBO = BeanUtil.toBean(queryParams, DataQuery_hYiGWhereBO.class);
        List<BaseOpenIssue> queryResult = baseOpenIssueService.list(dataQuery_hYiGWhereBO);
        return queryResult;
    }


}