package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.da.service.VenueInformationService;
import com.wlos.app.bo.*;
/**
* 新增场馆信息
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class AddVenueInformationService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "新增场馆信息";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private VenueInformationService venueInformationService;

    /**
    * 新增场馆信息接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(AddVenueInformationDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        AddVenueInformationBO bo = new AddVenueInformationBO();
        if (Objects.isNull(form)) {
            form = new AddVenueInformationDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据新增
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, AddVenueInformationBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataAddition(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, AddVenueInformationBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据新增
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataAddition(JSONObject paramsJsonContext, AddVenueInformationBO executeBO) throws BusinessException {
        log.info("========执行数据新增方法=======");
        AddVenueInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据新增,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
            String nowkrScript = "function mGetCurrentDateTime(){\n              var date = new Date();\n              var year = date.getFullYear();\n              var month = date.getMonth()+1;\n              var dates = date.getDate();\n              var hours = date.getHours();\n              var minutes = date.getMinutes();\n              var seconds = date.getSeconds();\n              month = month < 10 ? \'0\' + month : month;\n              dates = dates < 10 ? \'0\' + dates : dates;\n              hours = hours < 10 ? \'0\' + hours : hours;\n              minutes = minutes < 10 ? \'0\' + minutes : minutes;\n              seconds = seconds < 10 ? \'0\' + seconds : seconds;\n              return String(year + \'-\' + month + \'-\' + dates + \' \' + hours + \':\' + minutes + \':\' + seconds);\n          };\n\n\nreturn mGetCurrentDateTime();\n";
        List<BlocklyBindParamDto> morwmBindparams = new ArrayList<>();
        Object itihx0Value = BlocklyUtils.exe(nowkrScript, morwmBindparams);
        Object itihx0 = itihx0Value;

        paramMap.put("creationTime", itihx0);
        String venueName1 = bo.getVenueName();
        paramMap.put("venueName", venueName1);
        String provinceCode2 = bo.getProvinceCode();
        paramMap.put("province", provinceCode2);
        String cityCode3 = bo.getCityCode();
        paramMap.put("city", cityCode3);
        String contactNum4 = bo.getContactNum();
        paramMap.put("phone", contactNum4);
        String venueAddr5 = bo.getVenueAddr();
        paramMap.put("venueAddress", venueAddr5);
        String venueType6 = bo.getVenueType();
        paramMap.put("venueType", venueType6);
        Object fnghs7 = "0";
        paramMap.put("nature", fnghs7);
        String venueIntroduction8 = bo.getVenueIntroduction();
        paramMap.put("venueIntroduction", venueIntroduction8);
        String regionalLocation9 = bo.getRegionalLocation();
        paramMap.put("regionalLocation", regionalLocation9);
        String businessLicenseAddr10 = bo.getBusinessLicenseAddr();
        paramMap.put("businessLicenseAddr", businessLicenseAddr10);
        String unifiedCreditCode11 = bo.getUnifiedCreditCode();
        paramMap.put("unifiedCreditCode", unifiedCreditCode11);
        Long userID12 = bo.getUserID();
        paramMap.put("userId", userID12);
        //调用数据新增
        log.info("============dm params===" + paramMap.toJSONString());
        VenueInformationBO venueInformationBO = BeanUtil.mapToBean(paramMap, VenueInformationBO.class, null);
        String vo = venueInformationService.insert(venueInformationBO);
        bo.setDataAddition(vo);
        log.debug("流程名称：{},方法名称: 数据新增,输出参数: {}",processName,JSON.toJSONString(vo));
        endEvent(paramsJsonContext, executeBO);
    }

}