package com.wlos.app.bl;

import com.wlos.app.exception.BusinessException;
import com.wlos.app.bo.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.model.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;

/**
 * 聚合查询
 *
 * @author
 * @date
 * @since
 */
public interface BaseFixedIssueAggregateService {

    /**
    * 聚合查询：暂存固定和开放问题-数据查询固定问题
    */
    public List<BaseFixedIssue> dataQuery_ltrJ(JSONObject paramsJsonContext,TmpStgOfFixedAndOpenIssuesBO bo) throws BusinessException;


    /**
    * 聚合查询：根据阶段查询固定问题列表-通用问题查询
    */
    public List<BaseFixedIssue> dataQuery_lINF(JSONObject paramsJsonContext,QueryFixedProblemLstByStageBO bo) throws BusinessException;


    /**
    * 聚合查询：根据阶段查询固定问题列表-根据场地及活动类型查询
    */
    public List<BaseFixedIssue> dataQuery_FuxV(JSONObject paramsJsonContext,QueryFixedProblemLstByStageBO bo) throws BusinessException;


    /**
    * 聚合查询：根据阶段查询问题数量-数据查询
    */
    public Page<BaseFixedIssue> dataQuery_dvJR(JSONObject paramsJsonContext,QueryTheNumOfIssuesByStageBO bo) throws BusinessException;



}