package com.wlos.app.bl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wlos.app.enums.AnalysisEnums;
import com.wlos.app.model.vo.AnalysisDataDTO;
import com.wlos.app.model.vo.SeriesItem;
import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface AnalysisDataService {

    /**
     * chartData 转换
     * @param dataList 数据源
     * @param chartData json
     * @return
     */
    default Map<String, Object> analysis(List<Map<String,Object>> dataList, String chartData) {
        List<AnalysisDataDTO> analysisDataDTOS = new ArrayList<>();
        
        JSONObject jsonObject = JSONObject.parseObject(chartData);
        JSONArray xAxis = jsonObject.getJSONArray("xAxis");
        List<AnalysisDataDTO> xAxisList = Objects.isNull(xAxis)? Lists.newArrayList():xAxis.toJavaList(AnalysisDataDTO.class);
        xAxisList.forEach(x -> x.setAxis(AnalysisEnums.Axis.X));
        analysisDataDTOS.addAll(xAxisList);

        JSONArray yAxis = jsonObject.getJSONArray("yAxis");
        List<AnalysisDataDTO> yXisList = Objects.isNull(yAxis)? Lists.newArrayList():yAxis.toJavaList(AnalysisDataDTO.class);
        yXisList.forEach(y -> y.setAxis(AnalysisEnums.Axis.Y));
        analysisDataDTOS.addAll(yXisList);

        JSONArray seriesArray = jsonObject.getJSONArray("series");
        List<SeriesItem> series = Objects.isNull(seriesArray)?Lists.newArrayList():seriesArray.toJavaList(SeriesItem.class);
        
        return this.analysis(dataList, analysisDataDTOS, series);
    }

    /**
     * 统计图分析
     * @param dataList 数据源
     * @param analysisDataDTOList 分析模型
     * @param series 系列
     * @return
     */
    Map<String, Object> analysis(List<Map<String,Object>> dataList, List<AnalysisDataDTO> analysisDataDTOList, List<SeriesItem> series);

}
