package com.wlos.app.api;

import com.wlos.app.utils.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.HashMap;

/**
 * Debug模式下状态检查协议
 *
 * @author jyh
 * @date 2022年6月30日 上午9:45:12
 * @since v0.1
 */
@RestController
@RequestMapping(Constants.REQUEST_MAPPING_PREFIX)
public class StatusCheckController{
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /***
     * 心跳检查接口
     * @return
     */
    @PostMapping("/wosHeartBeat")
    public Result wosHeartBeat()  {
        return Result.SUCCESS().setData("ack");
    }

    @Autowired
    private JdbcTemplate jdbcTemplate;

    /***
     * 数据库连通性检查任务
     * @return
     */
    @PostMapping("/wosStatusCheck")
    public Result wosStatusCheck()  {
        HashMap<String, Object> statusMap = new HashMap<>();
        statusMap.put("connectionStatus", "error");
        try {
            jdbcTemplate.queryForList("Show tables");
            statusMap.put("connectionStatus", "ok");
        } catch (DataAccessException e) {
           log.error("数据库连失败:",e);
        }
        return Result.SUCCESS().setData(statusMap);
    }


}