package com.wlos.app.api;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.bl.impl.*;
import com.wlos.app.dto.*;
import com.wlos.app.utils.*;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/**
 * 根据计划id查询计划
 * @desc 
 * @author
 * @date 2024-08-30 17:02:53
 */
@RestController
@RequestMapping(Constants.REQUEST_MAPPING_PREFIX)
public class QueryPlanBasedOnPlanIDController extends DefaultController {

    private final Logger log = LoggerFactory.getLogger(getClass());

    @Autowired
    private HttpServletRequest request;
    @Autowired
    private QueryPlanBasedOnPlanIDService queryPlanBasedOnPlanIDService;

   /**
    * 根据计划id查询计划
    * @author
    * @date 2024-08-30 17:02:53
    * @param form
    * @return
    */
    @PostMapping(value = "/bizFlow/queryPlanBasedOnPlanID")
    public Result queryPlanBasedOnPlanIDDo(@Validated @RequestBody QueryPlanBasedOnPlanIDDTO form) {
        log.info("===============执行开始=======");
        //调用执行流程方法
        JSONObject returnDataJson = queryPlanBasedOnPlanIDService.processMainExecute(form);
        //移除过程执行中的临时变量
        if (null != returnDataJson) {
            returnDataJson.remove(Constants.DOWN_FILE_FLAG_KEY);
        }
        log.info("===============执行完成=======");

        return Result.SUCCESS(returnDataJson);

    }

}