package com.bcxin.platform.util.file.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;

import java.io.File;
import java.io.InputStream;

public interface OSSService {

	abstract OSSClient getClient();

	String getServer();

	abstract void createDirectory(String directoryName);

	abstract OSSResultInfo createDirectory(String directoryName,
                                           ObjectMetadata meta);

	abstract boolean deleteDirectory(String directoryName);

	abstract boolean deleteFile(String fileName);

	abstract boolean isExitsDirectory(String directoryName);

	abstract boolean isExitsFile(String file);

	abstract void put(String url, InputStream input);

	abstract File get(String url, String saveFileName);

	abstract OSSResultObject get(String url);

	abstract ObjectMetadata getFileMetadata(String url);

	abstract String getBucketUrl();

	abstract void copy(String srcPath, String desPath);

	abstract void copy(String srcPath, String desPath,
                       ObjectMetadata newMeta);

	abstract void upMeta(String url, ObjectMetadata meta);

}