package com.bcxin.platform.service.wallet.manage;


import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.wallet.PerWalletAccount;
import com.bcxin.platform.dto.SearchParamDTO;

import java.util.List;
import java.util.Map;

/**
 * <b> 个人钱包信息接口 </b>
 * @author ZXF
 * @create 2019/09/02 0002 14:56
 * @version
 * @注意事项 </b>
 */
public interface PerWalletManageService {


    /**
     * <b> 个人钱包列表的分页查询 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pagePerInsList(SearchParamDTO dto) throws V5BusinessException;

    /**
     * <b> 查询个人钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    Result getPerWalletAccountByPerId(SearchParamDTO dto) throws V5BusinessException;

    /**
     * <b> 更新个人钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:48
     * @version
     * @注意事项 </b>
     */
    Result updatePerWalletAccount(PerWalletAccount perWalletAccount) throws V5BusinessException;

    /**
     * <b> 获取个人钱包账户交易明细 </b>
     * @author ZXF
     * @create 2019/09/03 0003 10:36
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> getPerWalletAccountTradeDetail(SearchParamDTO dto,Integer page,Integer rows) throws V5BusinessException;

    /**
     * <b> 电子回单 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:19
     * @version
     * @注意事项 </b>
     */
    Result getPerAccountTradeVoucher(SearchParamDTO dto) throws V5BusinessException;

    /**
     * <b> 交易凭证 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:20
     * @version
     * @注意事项 </b>
     */
    Result getPerAccountPayVoucher(SearchParamDTO dto) throws V5BusinessException;
}
