package com.bcxin.platform.service.wallet;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.IdcardUtils;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.bean.ObjectUtils;
import com.bcxin.platform.domain.wallet.*;
import com.bcxin.platform.dto.wallet.*;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.log.SysSmsLogMapper;
import com.bcxin.platform.mapper.wallet.*;
import com.bcxin.platform.service.bbd.BbdTestService;
import com.bcxin.platform.service.cache.TaskCacheService;
import com.bcxin.platform.service.common.ComTaskResidualAPIService;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.oauth.RedisUtil;
import com.bcxin.platform.util.DateUtils;
import com.bcxin.platform.util.JwtUtil;
import com.bcxin.platform.util.PageInfoUtils;
import com.bcxin.platform.util.ThreadPool;
import com.bcxin.platform.util.constants.CommonConst;
import com.bcxin.platform.util.constants.PaymentServiceConst;
import com.bcxin.platform.util.constants.PublicConst;
import com.bcxin.platform.util.excel.ExcelUtil;
import com.bcxin.platform.util.file.BcxinFileUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.redisson.api.RedissonClient;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.*;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 企业钱包服务
 *
 * @author llc
 * @date 2019-06-21
 */
@Service("comWalletService")
@Transactional("transactionManager")
public class ComWalletServiceImpl implements ComWalletService {

    @Resource
    private ComWalletMapper comWalletMapper;

    @Resource
    private ComWalletAccountMapper comWalletAccountMapper;

    @Resource
    private ComWalletAccountDetailMapper comWalletAccountDetailMapper;

    @Resource
    private ComWalletProcessMapper comWalletProcessMapper;

    @Resource
    private ComWalletTradeMapper comWalletTradeMapper;

    @Resource
    private TaskCacheService taskCacheService;

    @Resource
    private CommonService commonService;

    @Resource
    private ComTaskResidualAPIService comTaskResidualAPIService;

    @Resource
    private ComWalletReconciliationMapper comWalletReconciliationMapper;

    @Resource
    private ComSubsidyGrantEventMapper comSubsidyGrantEventMapper;

    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;

//    @Resource
//    private MQFeignService mqFeignService;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private BbdTestService bbdTestService;

    @Resource
    private SysSmsLogMapper sysSmsLogMapper;

    @Resource
    private IdWorker idWorker;

    @Resource
    private RedisUtil redisUtil;

//    @Resource
//    private RedissonClient redissonClient;

    private final static String TRANSFERKEY = "Transfer:";
    /**
     * 获取企业钱包服务开通情况
     *
     * @param comWallet
     * @return
     * @author llc
     * @date 2019-06-21
     */
    @Override
    public Result getComWalletServiceOpenInfo(ComWallet comWallet) throws V5BusinessException {
        if (comWallet.getComId() == null) {
            return Result.tokenExpired("登录超时或者未登录，请重新登录！");
        }
        if (StringUtils.isEmpty(comWallet.getTlkComId())) {
            comWallet = comWalletMapper.getComWalletByComId(comWallet.getComId());
        } else {
            comWallet = comWalletMapper.getComWalletByTLKComId(comWallet.getTlkComId());
        }

        /*** 如果未查询到数据则表示未授权 ***/
        Map<String, String> resultMap = new HashMap<>();
        if (comWallet == null) {
            resultMap.put("isCompleteOpen", CommonConst.N); // 是否开通服务
            resultMap.put("isAuthorize", CommonConst.N); // 未授权服务
        } else {
            resultMap.put("isCompleteOpen", comWallet.getIsCompleteOpen()); // 是否开通服务
            resultMap.put("isAuthorize", CommonConst.Y); // 已授权服务
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }

    /**
     * 获取企业钱包服务当前开通步骤(因富民银行开户流程调整作废)
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-21
     */
    @Override
    public Result getComWalletCurrentProcess(ComWalletProcess dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            return Result.tokenExpired("登录超时或者未登录，请重新登录！");
        }
        ComWalletProcess processDB = comWalletProcessMapper.getComWalletCurrentProcess(dto.getComId());
        /*** 未查到数据则初始化数据 ***/
        if (processDB == null) {
            /* 插入企业钱包开户流程 ***/
//            comWalletMapper.insertComWallet(dto.getComId());
            comWalletProcessMapper.insertComWalletProcess(dto.getComId(),"openAccountStepDesc");
            processDB = comWalletProcessMapper.getComWalletCurrentProcess(dto.getComId());
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, processDB);
    }


    /**
     * 企业业务发送验证码
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-22
     */
    @Override
    public Result sendVerifyCode(ComWalletAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty(dto.getMobilePhone())) {
            throw new V5BusinessException(Result.ERROR, "手机号不能为空");
        }
        Long orderId = idWorker.nextId();
        /* 调用支付平台接口完成验证码发送 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("id", getMemberNo(dto.getComId()+""));
        p.put("mobilePhone", dto.getMobilePhone());
        p.put("smsType", dto.getSmsType());
        /* 提现先加上需要验证码 */
        if (Integer.parseInt(dto.getSmsType()) == 12) {
            p.put("orderId", orderId + "");
            p.put("amount", dto.getAmount());
        }
        /* 动账交易调用我们自己的验证码接口 */
        if (Integer.parseInt(dto.getSmsType()) == 13) {
            String verifyCode = commonService.sendCode(dto.getMobilePhone());
            /* 支付平台手机验证码放入redis ***/
            taskCacheService.setActiveCodeSerial(dto.getMobilePhone(), verifyCode);
            return Result.success("验证码发送成功", orderId);
        }
        String token = JwtUtil.createJWT(p);
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.SEND_VERIFY_CODE, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /* 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            Map<String, Object> map = (Map<String, Object>) result.getData();
            /* 支付平台手机验证码放入redis ***/
            taskCacheService.setActiveCodeSerial(dto.getMobilePhone(), map.get("msgInfo").toString());
        } else {
            /* 返回失败则抛错 ***/
            return Result.fail(result.getMsg());
        }
        return Result.success("验证码发送成功", orderId);
    }

    /**
     * 保存开户资料第一步
     * TODO 已对接工商
     * 步骤1提交会员档案录入
     * 步骤2查询会员档案获取 保证金账号 当 钱包账号 存储
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-21
     * @update by zxf 2023-02-07
     */
    @Override
    public Result saveAccountInfo(ComWalletAccountDTO dto) throws V5BusinessException {
//        dto.setShareholderInfo("[{\"cerNo\":\"452223196611142517\",\"endDate\":\"2099-12-31\",\"name\":\"赵军辉\",\"cerType\":\"0\",\"startDate\":\"2010-01-01\"}]");
//        dto.setBeneficiaryInfo("[{\"contractPhone\":\"18059865862\",\"cerNo\":\"452223196611142517\",\"endDate\":\"2099-12-31\",\"name\":\"李四\",\"contractAddress\":\"测试地址\",\"cerType\":\"0\",\"startDate\":\"2010-01-01\"}]");
        if (dto.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        if (StringUtil.isEmpty(dto.getActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "验证码不能为空");
        }
        String activeCodeSerial = taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
        if (StringUtil.isEmpty(activeCodeSerial)) {
            throw new V5BusinessException(Result.ERROR, "验证码失效");
        }
        if (!activeCodeSerial.equals(dto.getActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "验证码不正确");
        }
        if (StringUtil.isEmpty(dto.getComName())) {
            throw new V5BusinessException(Result.ERROR, "企业名称不能为空");
        }
        if (StringUtil.isEmpty(dto.getFmComType())) {
            throw new V5BusinessException(Result.ERROR, "企业类型不能为空");
        }
        if (StringUtil.isEmpty(dto.getComCerType())) {
            throw new V5BusinessException(Result.ERROR, "企业证件类型不能为空");
        }
        if (StringUtil.isEmpty(dto.getContractPhone())) {
            throw new V5BusinessException(Result.ERROR, "联系电话不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessAddress())) {
            throw new V5BusinessException(Result.ERROR, "经营地址不能为空");
        }
        if (StringUtil.isEmpty(dto.getLegalRepName())) {
            throw new V5BusinessException(Result.ERROR, "法定代表人姓名不能为空");
        }
        if (StringUtil.isEmpty(dto.getIdCardType())) {
            throw new V5BusinessException(Result.ERROR, "法定代表人证件类型不能为空");
        }
        if (StringUtil.isEmpty(dto.getIdCardNo())) {
            throw new V5BusinessException(Result.ERROR, "法定代表人证件号码不能为空");
        } else {
            if ("0".equals(dto.getIdCardType())&&!IdcardUtils.validateCard(dto.getIdCardNo())) {
                throw new V5BusinessException(Result.ERROR, "法人身份证不合法");
            }
        }

//        if (StringUtil.isEmpty(dto.getIdCardFrontUrl())) {
//            throw new V5BusinessException(Result.ERROR, "法人身份证国徽面不能为空");
//        }
//        if (StringUtil.isEmpty(dto.getIdCardReverseUrl())) {
//            throw new V5BusinessException(Result.ERROR, "法人身份证人像面不能为空");
//        }
        if (StringUtil.isEmpty(dto.getLegalRepPhone())) {
            throw new V5BusinessException(Result.ERROR, "法人手机号不能为空");
        }
        if (StringUtil.isEmpty(dto.getLegalRepPlace())) {
            throw new V5BusinessException(Result.ERROR, "法人常住地不能为空");
        }
        if (StringUtil.isEmpty(dto.getIdCardStartDate())) {
            throw new V5BusinessException(Result.ERROR, "身份证有效期开始日期不能为空");
        }
        if (StringUtil.isEmpty(dto.getIdCardEndDate())) {
            throw new V5BusinessException(Result.ERROR, "身份证有效期截止日期不能为空");
        }
        if (StringUtil.isEmpty(dto.getMobilePhone())) {
            throw new V5BusinessException(Result.ERROR, "手机号不能为空");
        }
//        if (StringUtil.isEmpty(dto.getBankCode())) {
//            throw new V5BusinessException(Result.ERROR, "银行不能为空");
//        }
        if (StringUtil.isEmpty(dto.getBankCardNo())) {
            throw new V5BusinessException(Result.ERROR, "银行卡号不能为空");
        }
//        String shareholderInfo = "";
//        if (StringUtil.isEmpty(dto.getShareholderInfo())) {
//            throw new V5BusinessException(Result.ERROR, "股东信息不能为空");
//        } else {
//            shareholderInfo = dto.getShareholderInfo().replaceAll("name", "shareholder_name").replaceAll("cerType", "shareholder_card_type")
//                    .replaceAll("cerNo", "shareholder_card_no").replaceAll("startDate", "shareholder_card_start_date")
//                    .replaceAll("endDate", "shareholder_card_end_date");
//        }
//        String beneficiaryInfo = "";
//        if (StringUtil.isEmpty(dto.getBeneficiaryInfo())) {
//            throw new V5BusinessException(Result.ERROR, "受益人信息不能为空");
//        } else {
//            beneficiaryInfo = dto.getBeneficiaryInfo().replaceAll("name", "beneficiary_name").replaceAll("cerType", "beneficiary_card_type")
//                    .replaceAll("cerNo", "beneficiary_card_no").replaceAll("startDate", "beneficiary_card_start_date")
//                    .replaceAll("endDate", "beneficiary_card_end_date").replaceAll("contractPhone", "beneficiary_phone")
//                    .replaceAll("contractAddress", "beneficiary_location");
//        }
        ComWalletAccountDTO account = comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        String operType = "1";
        if(account!=null){
            operType = "2";
        }
        /*** 调用支付平台接口完成开户资料上传 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("comId", getMemberNo(dto.getComId()+""));
        p.put("comName", dto.getComName());
        p.put("comCerType", dto.getComCerType());
        p.put("comCerNo", dto.getComCerNo());
        p.put("legalRepName", dto.getLegalRepName());
        p.put("idCardNo", dto.getIdCardNo());
        p.put("idCardType", dto.getIdCardType());//	法人证件类型	Y 0-身份证 1-护照
        p.put("legalRepPhone", dto.getLegalRepPhone());//	 法人联系电话	Y
        p.put("legalRepPlace", dto.getLegalRepPlace());//	法人常住地	Y
        p.put("mobilePhone", dto.getMobilePhone());
        p.put("bankCode", dto.getBankCode());
        p.put("bankCardNo", dto.getBankCardNo());
//        p.put("activeCode", dto.getActiveCode());
        String dealName = perBaseInfoMapper.getNameById(dto.getCreateBy());
        p.put("dealName", dealName);//经办人姓名
//        p.put("mallUrl", "");//商户主页URL
        p.put("icpCode", "闽ICP备14018517号");//ICP备案编号
        p.put("operType", operType);//1新增2修改
        //当前不处理回调
//        p.put("callbackUrl", commonService.getSystemConfig("SYS_PIC_HTTP_ADDR") + "/wallet/com-wallet-register-callback");//回调通知
        p.put("callbackUrl", "");//回调通知

        p.put("corporationIdStartDate", dto.getIdCardStartDate());//法人证件签发日期 yyyy-MM-dd
        p.put("corporationIdEndDate", dto.getIdCardEndDate());//法人证件到期日期 yyyy-MM-dd
        p.put("businessLocation", dto.getBusinessAddress());//经营地址
//        p.put("category", dto.getFmComType());//参考附录四，取值只能为大类200中的值

//        p.put("businessLicenseImage", dto.getComCerUrl());//营业执照图片 图片不超过1.5M base64
//        p.put("corporationCardFrontImage", dto.getIdCardFrontUrl());//法人身份证正面
//        p.put("corporationCardReverseImage", dto.getIdCardReverseUrl());//法人身份证反面
//        p.put("shareholderList", shareholderInfo);//股东信息数组 数组元素不超过5个
//        p.put("beneficiaryList", beneficiaryInfo);//受益人信息数 数组元素不超过5个
        p.put("enterprisePhone", dto.getContractPhone());//企业联系电
//        p.put("activeCodeSerial", taskCacheService.getActiveCodeSerial(dto.getMobilePhone()));
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.OPEN_COM_WALLET_ACCOUNT, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {

            /*** 刚创建未认证没有保证金账号默认0 ***/
            dto.setWalletAccountNo("0");
            Date now = new Date();
            //新增
            if("1".equals(operType)){
                /*** 写入saas钱包账户 ***/
                dto.setCreateTime(now);
                comWalletAccountMapper.insertComWalletAccount(dto);

                /*** 更新企业钱包开户流程 ***/
                ComWalletProcess comWalletProcess = new ComWalletProcess();
                comWalletProcess.setComId(dto.getComId());
                comWalletProcess.setUpdateTime(now);
                comWalletProcess.setUpdateBy(dto.getUpdateBy());
                comWalletProcess.setStep(1);
                comWalletProcess.setIsComplete(CommonConst.Y);
                comWalletProcessMapper.updateComWalletProcess(comWalletProcess);
                comWalletProcessMapper.insertComWalletProcess(dto.getComId(),"confirmAccountStepDesc");
                /*** 更新企业钱包服务为已完成 ***/
                ComWallet comWallet = new ComWallet();
                comWallet.setComId(dto.getComId());
                comWallet.setCreateTime(now);
                comWallet.setCreateBy(dto.getCreateBy());
                comWallet.setIsCompleteOpen(CommonConst.N);
//            comWallet.setOpenTime(now);
                comWalletMapper.insertComWallet(comWallet);
            }else if("2".equals(operType)){
                dto.setUpdateBy(dto.getUpdateBy());
                dto.setUpdateTime(now);
                comWalletAccountMapper.updateComWalletAccountAll(dto);
            } else {
                return Result.fail("类型不匹配，业务无效");
            }

        } else {
            /*** 返回失败则抛错 ***/
            return Result.fail(result.getMsg());
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    private String getMemberNo(String comId){
        String memberNo = comWalletMapper.getMerchantNoByComId(Long.parseLong(comId));
        /*
         * 判断当前环境是否是测试环境，如果是则跳过校验环境
         */
        String envi = commonService.getSystemConfig("PLATFORM_SIGN");
        if (Objects.equals(envi, com.bcxin.platform.util.constants.Constants.ENVI_TEST)) {
            if("961981641130291200".equals(memberNo)){
                memberNo = "cykhdshou009";
            }else if("948152662251671552".equals(memberNo)){
                memberNo = "cyk666";
            }else if("971861431804100608".equals(memberNo)){
                memberNo = "yybsend101";
            }else{
                memberNo = memberNo.substring(memberNo.length()-15,memberNo.length());
            }
        }else{
            if(memberNo.length()>15){
                memberNo = memberNo.substring(memberNo.length()-15,memberNo.length());
            }
        }
        return memberNo;
    }

    /**
     * 保存开户资料第二步
     *
     * @param comWalletAccount
     * @return
     * @author llc
     * @date 2019-06-21
     */
    @Override
    public Result saveAccountInfoStepTwo(ComWalletAccount comWalletAccount) throws V5BusinessException {

        if (comWalletAccount.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        if (StringUtil.isEmpty(comWalletAccount.getComCerUrl())) {
            throw new V5BusinessException(Result.ERROR, "企业证件扫描件必须上传");
        }
        ComWalletAccountDTO account = comWalletAccountMapper.getComWalletAccountByComId(comWalletAccount.getComId());

        /*** 调用支付平台接口完成开户资料上传 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("comId", getMemberNo(comWalletAccount.getComId()+""));
        p.put("comCerType", account.getComCerType());
        p.put("comCerNo", account.getComCerNo());
        p.put("comCerUrl", comWalletAccount.getComCerUrl());
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.UPLOAD_COM_CER_INFO, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            /*** 更新saas钱包账户 ***/
            Date now = new Date();
            comWalletAccount.setUpdateTime(now);
            comWalletAccountMapper.updateComWalletAccount(comWalletAccount);

            /*** 更新企业钱包开户流程 ***/
            ComWalletProcess comWalletProcess = new ComWalletProcess();
            comWalletProcess.setComId(comWalletAccount.getComId());
            comWalletProcess.setUpdateTime(now);
            comWalletProcess.setUpdateBy(comWalletAccount.getUpdateBy());
            comWalletProcess.setStep(2);
            comWalletProcess.setIsComplete(CommonConst.Y);
            comWalletProcessMapper.updateComWalletProcess(comWalletProcess);

            /*** 更新企业钱包服务为已完成 ***/
            ComWallet comWallet = new ComWallet();
            comWallet.setComId(comWalletAccount.getComId());
            comWallet.setUpdateTime(now);
            comWallet.setUpdateBy(comWalletAccount.getUpdateBy());
            comWallet.setIsCompleteOpen(CommonConst.Y);
            comWallet.setOpenTime(now);
            comWalletMapper.updateComWallet(comWallet);

        } else {
            /*** 返回失败则抛错 ***/
            return Result.fail(result.getMsg());
        }
        return Result.success(Result.SUCCESS_MSG);
    }


    /**
     * 获取企业钱包账户
     *
     * @param comWalletAccount
     * @return
     * @author llc
     * @date 2019-06-21
     */
    @Override
    public Result getComWalletAccount(ComWalletAccount comWalletAccount) throws V5BusinessException {
        if (comWalletAccount.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        /*** 调用支付平台接口获取账户相关资料 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("comId", getMemberNo(comWalletAccount.getComId()+""));
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.GET_WALLET_ACCOUNT, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);

        /*** 查出本地的钱包账户资料 ***/
        ComWalletAccountDTO dto = comWalletAccountMapper.getComWalletAccountByComId(comWalletAccount.getComId());

        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            Map<String, Object> map = (Map<String, Object>) result.getData();
            if(map==null||map.get("account_state")==null){
                return Result.success(Result.SUCCESS_QUERY_MSG, dto);
            }

            String status = map.get("account_state").toString();
            String statusStr = PaymentServiceConst.getGSAccountStatus(map.get("account_state").toString());
            ComWallet comWallet = comWalletMapper.getComWalletByComId(comWalletAccount.getComId());
            //如果账户状态为正常，账户开通状态为未开通的情况，将开通状态和步骤状态都改为开通
            if("1".equals(status)&&CommonConst.N.equals(comWallet.getIsCompleteOpen())){
                Date now = new Date();
                /*** 更新企业钱包开户流程 ***/
                ComWalletProcess comWalletProcess = new ComWalletProcess();
                comWalletProcess.setComId(comWalletAccount.getComId());
                comWalletProcess.setUpdateTime(now);
                comWalletProcess.setUpdateBy(comWalletAccount.getUpdateBy());
                comWalletProcess.setStep(4);
                comWalletProcess.setIsComplete(CommonConst.Y);
                comWalletProcessMapper.updateComWalletProcess(comWalletProcess);

                /*** 更新企业钱包服务为已完成 ***/
                comWallet.setComId(comWalletAccount.getComId());
                comWallet.setUpdateTime(now);
                comWallet.setUpdateBy(comWalletAccount.getUpdateBy());
                comWallet.setIsCompleteOpen(CommonConst.Y);
                comWallet.setOpenTime(now);
                comWalletMapper.updateComWallet(comWallet);
            }
            /*** 账户状态 ***/
            dto.setAccountStatus(statusStr);
            /*** 银行名称 ***/
            dto.setBankName(commonService.getConfigBank(dto.getBankCode()));
            if (StringUtil.isEmpty(dto.getBankName())) {
                dto.setBankName(map.get("acct_org_name").toString());
            }
            /*** 银行卡号 ***/
            dto.setBankCardNo(dto.getBankCardNo());
            if (StringUtil.isEmpty(dto.getBankCardNo())) {
                dto.setBankCardNo(map.get("acct").toString());
            }
            String walletAccountNo = dto.getWalletAccountNo();
            String cardnoGS = dto.getCardnoGS();
            dto.setWalletAccountNo(map.get("accnoEnsure").toString());
            dto.setCardnoGS(map.get("cardno").toString());
            //保存保证金账号
            if ("0".equals(walletAccountNo)&&StringUtil.isNotEmpty(map.get("accnoEnsure").toString())) {
                comWalletAccountMapper.updateComWalletAccountNo(dto);
            }
            //保存工行财智卡号
            if (StringUtil.isEmpty(cardnoGS)
                    &&StringUtil.isNotEmpty(walletAccountNo) && walletAccountNo.length()>5
                    &&StringUtil.isNotEmpty(map.get("cardno").toString())) {
                comWalletAccountMapper.updateComWalletAccountNo(dto);
            }
        } else {
            /*** 返回失败则抛错 ***/
            return Result.fail(result.getMsg());
        }

        return Result.success(Result.SUCCESS_QUERY_MSG, dto);
    }

    /**
     * <b> 会员档案认证 </b>
     * @author ZXF
     * @create 2023/02/17 0017 15:55
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getAccountConfirm(ComWalletAccount comWalletAccount) throws V5BusinessException {
        if (comWalletAccount.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        String webUrl = commonService.getSystemConfig(Constants.WEB_URL);
        /*** 调用支付平台接口获取账户相关资料 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("comId", getMemberNo(comWalletAccount.getComId()+""));
        p.put("returnUrl", webUrl+"/user/AuthSuccess");//回调结果页
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.WALLET_ACCOUNT_CONFIRM, requestMap);
        return JSON.parseObject(resultStr, Result.class);
    }

    /**
     * 获取企业钱包账户金额
     *
     * @param comWalletAccount
     * @return
     * @author llc
     * @date 2019-06-24
     */
    @Override
    public Result getComWalletAccountAmount(ComWalletAccount comWalletAccount) throws V5BusinessException {

        if (comWalletAccount.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        ComWalletAccount account;
        Map<Object, Object> p = new HashMap<>();
        if (StringUtils.isEmpty(comWalletAccount.getTlkComId())) {
            account = comWalletAccountMapper.getComWalletAccountByComId(comWalletAccount.getComId());
            p.put("comId", getMemberNo(comWalletAccount.getComId()+""));
        } else {
            account = comWalletAccountMapper.getComWalletAccountByTLKComId(comWalletAccount.getTlkComId());
            if (ObjectUtil.isNull(account.getComId())) {
                return Result.fail(Result.ERROR_MSG + "您的公司数据不完整，请联系客服！");
            } else {
                p.put("comId", getMemberNo(account.getComId()+""));
            }
        }

        /*** 调用支付平台接口获取账户金额 ***/
        /*** 钱包账户号 ***/
        p.put("walletAccountNo", account.getWalletAccountNo());
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_ACCOUNT_AMOUNT, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);

        Map<String, Object> resultMap = new HashMap<>();
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            Map<String, Object> map = (Map<String, Object>) result.getData();
            BigDecimal availableAmount = BigDecimal.ZERO;
            if(map.get("ledger_bal")!=null&&Double.parseDouble(String.valueOf(map.get("ledger_bal")))>0){
                availableAmount = BigDecimal.valueOf(Double.parseDouble(String.valueOf(map.get("ledger_bal")))).subtract(BigDecimal.valueOf(Double.parseDouble(String.valueOf(account.getFrozenAmount()))));
            }
            /*** 账户总额 ***/
//            String ledger_bal = new DecimalFormat("#,##0.00").format(new Double(String.valueOf(map.get("ledger_bal"))));
            String ledger_bal = String.valueOf(map.get("ledger_bal"));
            resultMap.put("totalAmount", ledger_bal);
            /*** 可用余额 ***/
//            String aAmount = new DecimalFormat("#,##0.00").format(availableAmount.doubleValue());
            String aAmount = availableAmount.toString();
            resultMap.put("availableAmount", aAmount);
            /*** 冻结金额 ***/
//            resultMap.put("frozenAmount", map.get("funds_held"));
            resultMap.put("frozenAmount", account.getFrozenAmount());
        } else {
            /*** 返回失败则抛错 ***/
            return Result.fail(result.getMsg());
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }

    /**
     * 获取企业钱包账户交易明细
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-21
     */
    @Override
    public Result getComWalletAccountTradeDetail(ComWalletAccountDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        if (dto.getPageNumber() == null) {
            throw new V5BusinessException(Result.ERROR, "第几页不能为空");
        }
        if (dto.getPageSize() == null) {
            throw new V5BusinessException(Result.ERROR, "每页多少行不能为空");
        }
        if (StringUtil.isEmpty(dto.getStartDate())) {
            throw new V5BusinessException(Result.ERROR, "开始日期不能为空");
        }
        if (StringUtil.isEmpty(dto.getEndDate())) {
            throw new V5BusinessException(Result.ERROR, "结束日期不能为空");
        }
        ComWalletAccountDTO account = comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());

        /* 调用支付平台接口获取账户交易明细 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("id", getMemberNo(dto.getComId()+""));
        p.put("pageNumber", dto.getPageNumber().toString());
        p.put("pageSize", dto.getPageSize().toString());
        p.put("walletAccountNo", account.getWalletAccountNo());
        p.put("startDate", dto.getStartDate());
        p.put("endDate", dto.getEndDate());

        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_ACCOUNT_TRADE_DETAIL, requestMap);
        System.err.println("=========> 请求支付平台收支明细url："+platUrl+PaymentServiceConst.GET_COM_WALLET_ACCOUNT_TRADE_DETAIL);
        System.err.println("=========> 支付平台返回收支明细字符串："+resultStr);
        Result result = JSON.parseObject(resultStr, Result.class);
        List<ComWalletAccountDetail> detailList = Lists.newArrayList();
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {

            Map<String, Object> map = (Map<String, Object>) result.getData();
            if (StringUtils.isEmpty(map.get("total_size").toString()) || Integer.parseInt(map.get("total_size").toString()) == 0) {
                PageInfoUtils pageInfo = new PageInfoUtils(new ArrayList());
                return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
            } else {
                /*** 解析返回的列表数据 ***/
                ArrayList<Map> recordlist = JSON.parseObject(map.get("balance_records").toString(),
                        new TypeReference<ArrayList<Map>>() {
                        });
                System.err.println("=========> 支付平台返回收支明细解析字符串："+JSON.toJSONString(recordlist));

                for (Map<String, Object> record : recordlist) {
                    ComWalletAccountDetail detail = packComWalletAccountDetail(record);
                    detailList.add(detail);
                }
                System.err.println("=========> 收支明细转换后列表字符串："+JSON.toJSONString(detailList));
                PageInfoUtils pageInfo = new PageInfoUtils(detailList);
                pageInfo.setPageSize(dto.getPageSize());
                pageInfo.setPageNumber(dto.getPageNumber());
                pageInfo.setTotal(Integer.parseInt(map.get("total_size").toString())); // 总记录数
                /*** 总页数等于总记录数除以每页记录数+1 ***/
                pageInfo.setTotalPage(Integer.parseInt(map.get("total_size").toString()) / Integer.parseInt(map.get("page_size").toString()) + 1);
                return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
            }
        } else {
            /*** 返回失败则抛错 ***/
            return Result.fail(result.getMsg());
        }

    }

    /**
     * <b> 获取企业钱包账户交易明细（请求转存数据，当天只能查到昨天的数据） </b>
     * @author ZXF
     * @create 2023/04/23 0023 10:37
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result thisComWalletAccountTradeDetail(ComWalletAccountDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        if (dto.getPageNumber() == null) {
            throw new V5BusinessException(Result.ERROR, "第几页不能为空");
        }
        if (dto.getPageSize() == null) {
            throw new V5BusinessException(Result.ERROR, "每页多少行不能为空");
        }
        if (StringUtil.isEmpty(dto.getStartDate())) {
            throw new V5BusinessException(Result.ERROR, "开始日期不能为空");
        }
        if (StringUtil.isEmpty(dto.getEndDate())) {
            throw new V5BusinessException(Result.ERROR, "结束日期不能为空");
        }
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        List<ComWalletAccountDetail> detailList = comWalletAccountDetailMapper.selectByComIdAndDate(dto.getComId(),dto.getStartDate(),dto.getEndDate(),"1");
        return Result.success(Result.SUCCESS_QUERY_MSG, new PageInfoUtils(detailList));
        /*
        ComWalletAccountDTO account = comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());

        //调用支付平台接口获取账户交易明细
        Map<Object, Object> p = new HashMap<>();
        p.put("id", getMemberNo(dto.getComId()+""));
        p.put("pageNumber", dto.getPageNumber().toString());
        p.put("pageSize", dto.getPageSize().toString());
        p.put("walletAccountNo", account.getWalletAccountNo());
        p.put("startDate", dto.getStartDate());
        p.put("endDate", dto.getEndDate());

        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_ACCOUNT_TRADE_DETAIL, requestMap);
        System.err.println("=========> 请求支付平台收支明细url："+platUrl+PaymentServiceConst.GET_COM_WALLET_ACCOUNT_TRADE_DETAIL);
        System.err.println("=========> 支付平台返回收支明细字符串："+resultStr);
        Result result = JSON.parseObject(resultStr, Result.class);
        List<ComWalletAccountDetail> detailList = Lists.newArrayList();
        //如果返回成功
        if (Result.SUCCESS.equals(result.getRetType())) {

            Map<String, Object> map = (Map<String, Object>) result.getData();
            if (StringUtils.isEmpty(map.get("total_size").toString()) || Integer.parseInt(map.get("total_size").toString()) == 0) {
                PageInfoUtils pageInfo = new PageInfoUtils(new ArrayList());
                return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
            } else {
                //解析返回的列表数据
                ArrayList<Map> recordlist = JSON.parseObject(map.get("balance_records").toString(),
                        new TypeReference<ArrayList<Map>>() {
                        });
                System.err.println("=========> 支付平台返回收支明细解析字符串："+JSON.toJSONString(recordlist));

                for (Map<String, Object> record : recordlist) {
                    ComWalletAccountDetail detail = packComWalletAccountDetail(record);
                    detailList.add(detail);
                }
                System.err.println("=========> 收支明细转换后列表字符串："+JSON.toJSONString(detailList));
                PageInfoUtils pageInfo = new PageInfoUtils(detailList);
                pageInfo.setPageSize(dto.getPageSize());
                pageInfo.setPageNumber(dto.getPageNumber());
                pageInfo.setTotal(Integer.parseInt(map.get("total_size").toString())); // 总记录数
                //总页数等于总记录数除以每页记录数+1
                pageInfo.setTotalPage(Integer.parseInt(map.get("total_size").toString()) / Integer.parseInt(map.get("page_size").toString()) + 1);
                return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
            }
        } else {
            //返回失败则抛错
            return Result.fail(result.getMsg());
        }*/

    }

    /**
     * 获取企业钱包账户交易明细
     * @return
     */
    @Override
    public Result comWalletAccountTradeDetailSch() {
        return comWalletAccountTradeDetailTask("","");
    }

    /**
     * 获取企业钱包账户交易明细
     *
     * @return
     * @author lp
     * @date 2019-12-09
     */
    @Override
    public Result comWalletAccountTradeDetailTask(String startDate, String endDate) {
        List<ComWalletAccountDTO> accountList = comWalletAccountMapper.getAllComWalletAccount();
        String yesterday = DateUtil.formatDate(DateUtil.yesterday());
        if (StringUtils.isEmpty(startDate) || StringUtils.isEmpty(endDate)) {
            startDate = yesterday;
            endDate = yesterday;
        }
        List<ComWalletAccountDetailDTO> detailList = Lists.newArrayList();
        List<String> flowNoList = Lists.newArrayList();

        /*  需要剔除掉已经存在的，防止重复下载 */
        List<String> existsFlowNoList = comWalletAccountDetailMapper.selectFlowNoByDate(startDate, endDate);

        for (ComWalletAccountDTO account : accountList) {
            int pageNumber = 1;
            while (true) {
                try{
                    /* 调用支付平台接口获取账户交易明细 ***/
                    Map<Object, Object> p = new HashMap<>();
                    p.put("id", getMemberNo(account.getComId()+""));
                    p.put("pageNumber", pageNumber);
                    p.put("pageSize", 100);
                    p.put("walletAccountNo", account.getWalletAccountNo());
                    p.put("startDate", startDate);
                    p.put("endDate", endDate);

                    String token = JwtUtil.createJWT(p);//加密生成token
                    Map<String, Object> requestMap = new HashMap<>();
                    requestMap.put("token", token);
                    String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
                    String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_ACCOUNT_TRADE_DETAIL, requestMap);
                    Result result = JSON.parseObject(resultStr, Result.class);
                    /*** 如果返回成功 ***/
                    if (Result.SUCCESS.equals(result.getRetType())) {
                        Map<String, Object> map = (Map<String, Object>) result.getData();
                        if (StringUtils.isEmpty(map.get("total_size").toString()) || Integer.parseInt(map.get("total_size").toString()) == 0) {
                            break;
                        }
                        /*** 解析返回的列表数据 ***/
                        ArrayList<Map> recordlist = JSON.parseObject(map.get("balance_records").toString(),
                                new TypeReference<ArrayList<Map>>() {
                                });

                        for (Map<String, Object> record : recordlist) {
                            ComWalletAccountDetailDTO detail = packComWalletAccountDetail(record);
                            detail.setComWalletAccountDetailId(idWorker.nextId());
                            detail.setComId(account.getComId());
                            detail.setWalletAccountNo(account.getWalletAccountNo());
                            /* 记录不存在才允许进行添加 */
                            if (!existsFlowNoList.contains(detail.getFlowNo())) {
                                detailList.add(detail);
                            }
                            if (!flowNoList.contains(detail.getFlowNo())) {
                                flowNoList.add(detail.getFlowNo());
                            }
                        }
                        /* 如果记录数小于100 说明没有下一页了*/
                        if (recordlist.size() < 100) {
                            break;
                        }
                        pageNumber++;
                    } else {
                        /* 如果返回数据异常，则直接循环下一个钱包数据 */
                        break;
                    }
                }catch (Exception e){
                    break;
                }
            }
        }
        /* 数据为空，则下面不需要执行了 */
        if (CollectionUtil.isEmpty(detailList)) {
            return Result.success(Result.SUCCESS_MSG);
        }
        /* 批量插入数据 */
        comWalletAccountDetailMapper.insertBatch(detailList);

        /* 将任务发到rabbitMq */
        for (ComWalletAccountDetailDTO detail : detailList) {
            /* 已经发送消费请求 */
            if (!flowNoList.contains(detail.getFlowNo())) {
                continue;
            }
            Map<String, String> params = Maps.newHashMap();
            /* 明细id */
            params.put("detailId", detail.getComWalletAccountDetailId().toString());
            /* 公司 */
            params.put("comId", getMemberNo(detail.getComId()+""));
            /* 流水号 */
            params.put("bizOrderNo", detail.getFlowNo());
            /* 钱包*/
            params.put("walletAccountNo", detail.getWalletAccountNo());
            ComWalletTradeDTO dto = new ComWalletTradeDTO();
            dto.setComId(detail.getComId());
            dto.setTradeFlowNo(detail.getTradeFlowNo());

            /* 发送队列，电子回单下载 */
//            comTaskResidualAPIService.saveComTaskResidual("taskTradeVoucher","电子回单下载任务","com.bcxin.platform.service.wallet.ComWalletService",1,"com.bcxin.platform.dto.wallet.ComWalletTradeDTO",JSON.toJSONString(dto));
//            taskTradeVoucher(dto);
//            mqFeignService.sendVoucherMQ(JSON.toJSONString(params));

            /* 删除已经发送的 */
            flowNoList.remove(detail.getFlowNo());
        }
        return Result.success(Result.SUCCESS_MSG);
    }


    private ComWalletAccountDetailDTO packComWalletAccountDetail(Map<String, Object> record) {
        String outWalletAccountNo = comWalletAccountMapper.getWalletAccountNoBybankCardNo(ObjectUtils.safeToString(record.get("account_out")));
        if(StringUtils.isEmpty(outWalletAccountNo)){
            outWalletAccountNo = ObjectUtils.safeToString(record.get("account_out"));
        }
        String direction = PaymentServiceConst.getDirection(record.get("direction").toString());
        ComWalletAccountDetailDTO detail = new ComWalletAccountDetailDTO();
        detail.setTradeDate(record.get("trade_date").toString().substring(0, record.get("trade_date").toString().length() - 3)); // 交易时间
        detail.setTradeFlowNo(ObjectUtils.safeToString(record.get("trade_flow_no"))); // 交易流水号
        detail.setFlowNo(ObjectUtils.safeToString(record.get("flow_no"))); // 账务流水号（业务流水号）
        detail.setAccountsDealType(PaymentServiceConst.getAccountDealType(ObjectUtils.safeToString(record.get("accounts_deal_type")))); //账务处理类型
        detail.setAccountsDealDate(record.get("accounts_deal_date").toString().substring(0, record.get("accounts_deal_date").toString().length() - 3));// 账务处理时间
        detail.setAmount(ObjectUtils.safeToString(record.get("amount"))); // 交易金额
//        detail.setBalance("-"); // 交易后余额,工行没有交易后余额的数据 ObjectUtils.safeToString(record.get("balance"))
        detail.setDirection(direction); // 资金流向
        detail.setHandStatus(PaymentServiceConst.getHandStatus(record.get("hand_status").toString())); // 处理状态
        detail.setCreateDate(record.get("create_date").toString().substring(0, record.get("create_date").toString().length() - 3)); // 订单创建时间
        detail.setServiceType(PaymentServiceConst.getServiceType(record.get("service_code").toString())); // 服务类型
        detail.setTradeType(PaymentServiceConst.getTradeType(record.get("trade_type").toString())); // 交易类型
        detail.setAccountIn(ObjectUtils.safeToString(record.get("account_in")));// 收款方账户
        detail.setAccountOut(outWalletAccountNo);// 付款方账户
        if (StringUtil.isEmpty(record.get("account_in").toString())) {
            detail.setAccountInName("无");// 收款方账户
        } else {
            String fullName = getWalletAccountName(record.get("account_in").toString());
            detail.setAccountInName(StringUtils.isEmpty(fullName) ? "无" : fullName); // 收款方账户中文
        }
        if (StringUtil.isEmpty(outWalletAccountNo)) {
            detail.setAccountOutName("无"); // 付款方账户
        } else {
            String fullName = getWalletAccountName(outWalletAccountNo);
            detail.setAccountOutName(StringUtils.isEmpty(fullName) ? "无" : fullName); // 付款方账户中文
        }
        detail.setMemo(ObjectUtils.safeToString(record.get("memo"))); // 备注
        return detail;
    }

    /**
     * 获取企业钱包充值token
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-21
     */
    @Override
    public Result getWalletRechargeToken(ComWalletAccountDTO dto) throws V5BusinessException {
        if (true) {
            throw new V5BusinessException(Result.ERROR, "业务优化中，暂停充值服务！");
        }
        if (dto.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业ID不能为空");
        }
        if (StringUtil.isEmpty(dto.getWalletAccountNo())) {
            throw new V5BusinessException(Result.ERROR, "企业钱包账户号不能为空");
        }
        if (StringUtil.isEmpty(dto.getComName())) {
            throw new V5BusinessException(Result.ERROR, "企业名称不能为空");
        }
        if (dto.getAmount() == null) {
            throw new V5BusinessException(Result.ERROR, "金额不能为空");
        }
//        if (StringUtil.isEmpty(dto.getCallfrontUrl())) {
//            throw new V5BusinessException(Result.ERROR, "回调页面地址不能为空");
//        }
        if (dto.getAmount().compareTo(BigDecimal.ZERO) < 1) {
            throw new V5BusinessException(Result.ERROR, "金额必须大于0");
        }
        String webUrl = commonService.getSystemConfig(Constants.WEB_URL);
        Long orderId = idWorker.nextId();
        Map<Object, Object> p = new HashMap<>();
        p.put("id", getMemberNo(dto.getComId()+"")); // 企业ID
        p.put("biz_channel_orderid", orderId.toString()); // 业务流水号
        p.put("amount", String.valueOf(dto.getAmount())); // 金额
        p.put("walletAccountNo", dto.getWalletAccountNo());  // 钱包账户号
        p.put("name", dto.getComName()); // 实体卡账户名
        p.put("channel", "PASP");// 渠道
        p.put("callfrontUrl", webUrl+"/user/RechargeSuccess");// 回调页面
        p.put("callbackUrl", commonService.getSystemConfig("SYS_PIC_HTTP_ADDR") + "/wallet/com-wallet-recharge-callback"); // 回调接口
        String token = JwtUtil.createJWT(p);//加密生成token

        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(orderId);
        comWalletTrade.setCreateTime(dto.getCreateTime());
        comWalletTrade.setCreateBy(dto.getCreateBy());
        comWalletTrade.setComId(dto.getComId());
        comWalletTrade.setAmount(dto.getAmount());
        comWalletTrade.setTradeType(DictConst.TRADETYPE_QYZHCZ); // 企业账户充值
        comWalletTrade.setTradeStatus(DictConst.TRADESTATUS_DJY); // 待交易
        /*** 插入企业钱包账户交易记录 ***/
        comWalletTradeMapper.insertComWalletTrade(comWalletTrade);

//        Map<String, String> resultMap = Maps.newHashMap();
//        resultMap.put("token", token);
//        resultMap.put("payUrl", commonService.getSystemConfig("PAYMENT_PLATFORM_URL") + "/pay/gongshang/account/b2b/recharge");
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + "/pay/gongshang/account/b2b/recharge", requestMap);
        return JSON.parseObject(resultStr, Result.class);
    }

    /**
     * 企业钱包开户回调
     *
     * @param token
     * @return
     * @author llc
     * @date 2019-06-28
     */
    @Override
    public Result comWalletRegisterCallback(String token) throws V5BusinessException, ParseException {
        if (StringUtil.isEmpty(token)) {
            throw new V5BusinessException(Result.ERROR, "参数为空");
        }
        Claims claims = JwtUtil.parseJWT(token);
        String paramStr = claims.getSubject();
        Map<String, String> paramMap = JSON.parseObject(paramStr, Map.class);
        if (StringUtil.isEmpty(paramMap.get("memberNo"))) {
            return Result.fail("会员号不能为空");
        }
        if (StringUtil.isEmpty(paramMap.get("status"))) {
            return Result.fail("开户状态不能为空");
        }
        if (StringUtil.isEmpty(paramMap.get("cardNo"))) {
            return Result.fail("电子账户卡号不能为空");
        }
        if (!"1".equals(paramMap.get("status"))) {
            System.err.println("=====> comWalletRegisterCallback（工商开户回调）：会员号："+paramMap.get("memberNo")+"，子账户卡号："+paramMap.get("cardNo")+"，开户状态："+paramMap.get("status")+"（0-未启用，1-正常，2-作废，3-待认证，4-认证拒绝）");
        }
        ComWalletAccountDTO comWalletAccount = comWalletAccountMapper.getComWalletAccountByComId(Long.parseLong(paramMap.get("memberNo")));
        comWalletAccount.setWalletAccountNo(paramMap.get("cardNo"));
        comWalletAccountMapper.updateComWalletAccount(comWalletAccount);
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 企业钱包充值回调
     *
     * @param token
     * @return
     * @author llc
     * @date 2019-06-28
     */
    @Override
    public Result comWalletRechargeCallback(String token) throws V5BusinessException, ParseException {
        if (StringUtil.isEmpty(token)) {
            throw new V5BusinessException(Result.ERROR, "参数为空");
        }
        Claims claims = JwtUtil.parseJWT(token);
        String paramStr = claims.getSubject();
        Map<String, String> paramMap = JSON.parseObject(paramStr, Map.class);
        if (StringUtil.isEmpty(paramMap.get("walletTradeId"))) {
            return Result.fail("交易流水号不能为空");
        }
        if (StringUtil.isEmpty(paramMap.get("tradeStatus"))) {
            return Result.fail("交易状态不能为空");
        }
        if (StringUtil.isEmpty(paramMap.get("updateTime"))) {
            return Result.fail("交易完成时间不能为空");
        }
        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(Long.parseLong(paramMap.get("walletTradeId")));
        comWalletTrade.setTradeStatus(paramMap.get("tradeStatus"));
        Date updateTime = DateUtils.parseDate(paramMap.get("updateTime"), DatePattern.NORM_DATETIME_PATTERN);
        comWalletTrade.setUpdateTime(updateTime);
        /*** 更新企业钱包账户交易记录 ***/
        comWalletTradeMapper.updateComWalletTrade(comWalletTrade);
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 企业钱包充值回调
     *
     * @param comWalletTrade
     * @return
     * @author llc
     * @date 2019-06-28
     */
    @Override
    public Result getWalletTradeInfo(ComWalletTrade comWalletTrade) throws V5BusinessException {
        if (comWalletTrade.getComWalletTradeId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业钱包交易流水号不能为空");
        }
        /*** 查询企业钱包交易信息 ***/
        comWalletTrade = comWalletTradeMapper.getComWalletTradeById(comWalletTrade.getComWalletTradeId());
        return Result.success(Result.SUCCESS_MSG, comWalletTrade);
    }

    /**
     * <b> 根据业务编码或业务交易流水号查询交易信息 </b>
     * @author ZXF
     * @create 2023/03/23 0023 10:20
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getComWalletTradeBySeqAndCode(ComWalletTrade comWalletTrade) throws V5BusinessException {
        if (comWalletTrade.getBusinessCode() == null) {
            throw new V5BusinessException(Result.ERROR, "业务编码不能为空");
        }
        /*** 查询企业钱包交易信息 ***/
        List<ComWalletTrade> list = comWalletTradeMapper.getComWalletTradeBySeqAndCode(comWalletTrade);
        return Result.success(Result.SUCCESS_MSG, list);
    }


    /**
     * 企业钱包账户提现
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-06-21
     */
    @Override
    public Result comWalletAccountExtract(ComWalletAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty(dto.getBankCardNo())) {
            throw new V5BusinessException(Result.ERROR, "银行卡号不能为空");
        }
        if (StringUtil.isEmpty(dto.getWalletAccountNo())) {
            throw new V5BusinessException(Result.ERROR, "企业钱包账户号不能为空");
        }
        if (StringUtil.isEmpty(dto.getComName())) {
            throw new V5BusinessException(Result.ERROR, "企业名称不能为空");
        }
        if (dto.getAmount() == null) {
            throw new V5BusinessException(Result.ERROR, "金额不能为空");
        }
        if (dto.getAmount().compareTo(BigDecimal.ZERO) < 1) {
            throw new V5BusinessException(Result.ERROR, "金额必须大于0");
        }
        if (StringUtil.isEmpty(dto.getMobilePhone())) {
            throw new V5BusinessException(Result.ERROR, "手机号不能为空");
        }
        if (StringUtil.isEmpty(dto.getOrderId())) {
            throw new V5BusinessException(Result.ERROR, "订单号不能为空");
        }
        if (StringUtil.isEmpty(dto.getActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "短信验证码不能为空");
        }
        String activeCodeSerial = taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
        if (StringUtil.isEmpty(activeCodeSerial)) {
            throw new V5BusinessException(Result.ERROR, "验证码失效");
        }
        if (!activeCodeSerial.equals(dto.getActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "验证码不正确");
        }

        ComWalletAccountDTO account = comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        //查询账户余额比对提现金额
        Result accRet = getComWalletAccountAmount(account);
        if(Result.SUCCESS.equals(accRet.getRetType())){
            Map<String,Object> map = JSON.parseObject(JSON.toJSONString(accRet.getData()),Map.class);
            if(map != null && map.get("availableAmount")!=null){
                BigDecimal availableAmount = BigDecimal.valueOf(Double.parseDouble(String.valueOf(map.get("availableAmount"))));
                if (availableAmount.compareTo(dto.getAmount()) < 0) {
                    throw new V5BusinessException(Result.ERROR, "提现金额不能大于可用余额");
                }
            }else {
                throw new V5BusinessException(Result.ERROR, "未读取到账户余额相关信息");
            }
        }else {
            throw new V5BusinessException(Result.ERROR, accRet.getMsg());
        }
        /* 调用支付平台接口钱包账户提现 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("comId", getMemberNo(account.getComId()+""));
        p.put("bizOrderNo", dto.getOrderId()); // 业务流水号
        p.put("amount", String.valueOf(dto.getAmount())); // 金额
        p.put("bankCode", account.getBankCode()); // 银行简称
        p.put("bankCardNo", dto.getBankCardNo()); // 银行卡号
        p.put("walletAccountNo", account.getWalletAccountNo());  // 钱包账户号
        p.put("name", account.getComName()); // 实体卡账户名
//        p.put("activeCode", dto.getActiveCode());
//        p.put("activeCodeSerial", taskCacheService.getActiveCodeSerial(dto.getMobilePhone()));
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.WALLET_ACCOUNT_WITHDRAW, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /* 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            /* 插入企业钱包账户交易记录 ***/
            ComWalletTrade comWalletTrade = new ComWalletTrade();
            comWalletTrade.setComWalletTradeId(Long.parseLong(dto.getOrderId()));
            comWalletTrade.setCreateTime(dto.getCreateTime());
            comWalletTrade.setUpdateTime(new Date());
            comWalletTrade.setCreateBy(dto.getCreateBy());
            comWalletTrade.setComId(dto.getComId());
            comWalletTrade.setAmount(dto.getAmount());
            comWalletTrade.setTradeType(DictConst.TRADETYPE_QYZHTX); // 企业账户提现
            comWalletTrade.setTradeStatus(DictConst.TRADESTATUS_JYCG); // 交易失败
            comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
            return Result.success(Result.SUCCESS_MSG);
        } else {
            /* 返回失败则抛错 ***/
            return Result.fail(result.getMsg());
        }
    }

    /**
     * <b> 批量提现 </b>
     * @author ZXF
     * @create 2023/09/01 0001 15:48
     * @version
     * @注意事项 </b>
     */
    public Result batchExtract(ComWallet comWallet) {
        String arrVal = comWallet.getCooperateTreatyUrl();
//        String arrVal = "575734131359744#500000,494399404261376#100000,199672755613697#1000,607130352517121#1000,625550456422401#60000,553249755496448#300000,980270295449601#12000,624980995768321#200000,281302947508224#100000,602776023236609#500000,044441688047616#200000,383879051870208#100000,117418530803712#180000,694212497408001#60000,697302125543425#500000,725824747503617#300000,211069387657216#100000,984247682973697#10000,209410677145600#18000,285661346824193#120000,231193847398400#800000,624584998944769#240000,713822867816449#50000,420915135266816#120000,636768281853953#200000,735852015124481#200000,609175860051969#60000,731747012050945#200000,016117514526721#100000,668404494630913#8000,608708144824321#100000,673326180634624#100000,291282354077697#12000,069779550306304#50000,608537822527489#300000,526887681617921#10000,228050281070593#900000,900121586073600#500000,005350396526593#50000,976820018020353#90000,196351675203584#100000,663748574347265#8000,801934590902272#12000,337910620651521#15000,420231244144641#700,229709652590593#200000,200853#400,740503431151617#200000";
        String[] groupAccount = arrVal.split(",");
        Map<String,String> map = Maps.newHashMap();
        List<String> accList = Lists.newArrayList();
        for (String acc:groupAccount) {
            String[] accArr = acc.split("#");
            map.put(accArr[0],accArr[1]);
            accList.add(accArr[0]);
        }
        List<ComWalletAccountDTO> list = comWalletMapper.findWalletAccounts(accList);
        List<String> errList = Lists.newArrayList();
        for (ComWalletAccountDTO dto:list) {
            dto.setAmount(new BigDecimal(map.get(dto.getCardno())));
            dto.setOrderId(String.valueOf(new IdWorker().nextId()));
            dto.setCreateBy(1L);
            dto.setCreateTime(new Date());
            try{
                extractMock(dto);
            }catch (V5BusinessException e){
                errList.add(dto.getCardno()+"#"+map.get(dto.getCardno())+"#"+e.getMsg());
                System.out.println("========> batchExtract 批量提现业务异常，"+dto.getComName()+" 提现失败，ERR:"+e.getMsg());
            }
        }
        return Result.success(Result.SUCCESS_MSG,errList);
    }

    /**
     * <b> 批量提现用 </b>
     * @author ZXF
     * @create 2023/09/01 0001 15:35
     * @version
     * @注意事项 </b>
     */
    private void extractMock(ComWalletAccountDTO dto) throws V5BusinessException {
        ComWalletAccountDTO account = comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        //查询账户余额比对提现金额
        Result accRet = getComWalletAccountAmount(account);
        if(Result.SUCCESS.equals(accRet.getRetType())){
            Map<String,Object> map = JSON.parseObject(JSON.toJSONString(accRet.getData()),Map.class);
            if(map != null && map.get("availableAmount")!=null){
                BigDecimal availableAmount = BigDecimal.valueOf(Double.parseDouble(String.valueOf(map.get("availableAmount"))));
                if (availableAmount.compareTo(dto.getAmount()) < 0) {
                    throw new V5BusinessException(Result.ERROR, "提现金额不能大于可用余额");
                }
            }else {
                throw new V5BusinessException(Result.ERROR, "未读取到账户余额相关信息");
            }
        }else {
            throw new V5BusinessException(Result.ERROR, accRet.getMsg());
        }
        /* 调用支付平台接口钱包账户提现 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("comId", getMemberNo(account.getComId()+""));
        p.put("bizOrderNo", dto.getOrderId()); // 业务流水号
        p.put("amount", String.valueOf(dto.getAmount())); // 金额
        p.put("bankCode", account.getBankCode()); // 银行简称
        p.put("bankCardNo", dto.getBankCardNo()); // 银行卡号
        p.put("walletAccountNo", account.getWalletAccountNo());  // 钱包账户号
        p.put("name", account.getComName()); // 实体卡账户名
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.WALLET_ACCOUNT_WITHDRAW, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /* 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            /* 插入企业钱包账户交易记录 ***/
            ComWalletTrade comWalletTrade = new ComWalletTrade();
            comWalletTrade.setComWalletTradeId(Long.parseLong(dto.getOrderId()));
            comWalletTrade.setCreateTime(dto.getCreateTime());
            comWalletTrade.setUpdateTime(new Date());
            comWalletTrade.setCreateBy(dto.getCreateBy());
            comWalletTrade.setComId(dto.getComId());
            comWalletTrade.setAmount(dto.getAmount());
            comWalletTrade.setTradeType(DictConst.TRADETYPE_QYZHTX); // 企业账户提现
            comWalletTrade.setTradeStatus(DictConst.TRADESTATUS_JYCG); // 交易失败
            comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
        } else {
            throw new V5BusinessException(Result.ERROR, result.getMsg());
        }
    }

    /**
     * 企业账户金额冻结/解冻
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-27
     */
    @Override
    public Result comWalletAccountLock(ComWalletTransferDTO dto) throws V5BusinessException {
//        String comId = "05".equals(dto.getTradeType())?dto.getInId():dto.getOutId();
        String outId = dto.getOutId();
        String inId = dto.getInId();
        if("05".equals(dto.getTradeType())){
            outId = dto.getInId();
            inId = dto.getOutId();
        }
        if (StringUtil.isEmpty(dto.getAmount())) {
            throw new V5BusinessException(Result.ERROR, "订单金额不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessCode())) {
            throw new V5BusinessException(Result.ERROR, "业务编码不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessPartnerSeq())) {
            throw new V5BusinessException(Result.ERROR, "业务交易流水号不能为空");
        }
        boolean redisRepetition = redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            throw new V5BusinessException(Result.ERROR, "交易已提交，请勿重复操作");
        }
        int countTrade = comWalletTradeMapper.getComWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade>0) {
            throw new V5BusinessException(Result.ERROR, "交易已完成，请勿重复操作");
        }
        if (StringUtil.isEmpty(dto.getGoodsName())) {
            throw new V5BusinessException(Result.ERROR, "订单商品名称不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsNumber())) {
            throw new V5BusinessException(Result.ERROR, "订单商品数量不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsUnit())) {
            throw new V5BusinessException(Result.ERROR, "订单商品单位不能为空");
        }
        if (StringUtil.isEmpty(dto.getNeedActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "是否需要验证码不能为空");
        }
        if (CommonConst.Y.equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty(dto.getMobilePhone())) {
                throw new V5BusinessException(Result.ERROR, "手机号不能为空");
            }
            if (StringUtil.isEmpty(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "短信验证码不能为空");
            }
            String activeCodeSerial = taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty(activeCodeSerial)) {
                throw new V5BusinessException(Result.ERROR, "验证码失效");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "验证码不正确");
            }
        }
        //冻结/解冻业务逻辑判断，计算记录冻结金额并入库
        BigDecimal frozenAmount = extractedLock(Long.parseLong(outId),Long.parseLong(inId),dto.getBusinessCode(), dto.getTradeType(), dto.getAmount());
        //更新冻结金额
//            Long comId = "05".equals(dto.getTradeType())?Long.parseLong(dto.getInId()):Long.parseLong(dto.getOutId());
        comWalletAccountMapper.updateFrozenAmount(Long.parseLong(outId),frozenAmount.toString());

        Long orderId = idWorker.nextId();
        /* 插入企业钱包账户交易记录 ***/
        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(orderId);
        comWalletTrade.setBusinessCode(dto.getBusinessCode());
        comWalletTrade.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
        comWalletTrade.setCreateTime(DateUtil.date());
        comWalletTrade.setUpdateTime(new Date());
        comWalletTrade.setComment(dto.getComment());
        comWalletTrade.setComId(Long.parseLong(outId));
        comWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
        comWalletTrade.setTradeType(dto.getTradeType()); // 企业账户支付
        comWalletTrade.setTradeStatus(DictConst.TRADESTATUS_JYCG); // 交易成功
        comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
        return Result.success(Result.SUCCESS_MSG, orderId);
    }

    /**
     * <b> 冻结/解冻业务逻辑判断，计算记录冻结金额并入库 </b>
     * @param outId 出账方企业id
     * @param inId 入账方企业id
     * @param code 业务编码 例：010001
     * @param tradeType 交易类型 04冻结05解冻
     * @param amount 交易金额
     * @author ZXF
     * @create 2023/03/31 0031 9:58
     * @version
     * @注意事项 </b>
     */
    private BigDecimal extractedLock(Long outId, Long inId, String code, String tradeType, String amount) {

        Long comId = outId;
        //可用余额
        BigDecimal availableAmount;
        //冻结金额
        BigDecimal frozenAmount;
        //当前要操作金额
        BigDecimal updAmount = BigDecimal.valueOf(Double.parseDouble(amount));
        ComWalletAccountDTO account = comWalletAccountMapper.getComWalletAccountByComId(comId);
        //查询账户余额比对提现金额
        Result accRet = getComWalletAccountAmount(account);
        if(Result.SUCCESS.equals(accRet.getRetType())){
            Map<String,Object> map = JSON.parseObject(JSON.toJSONString(accRet.getData()),Map.class);
            if(map != null && map.get("availableAmount")!=null){
                frozenAmount = BigDecimal.valueOf(Double.parseDouble(String.valueOf(map.get("frozenAmount"))));
                availableAmount = BigDecimal.valueOf(Double.parseDouble(String.valueOf(map.get("availableAmount"))));
                if("04".equals(tradeType)){
                    //冻结金额加 可用<变化
                    if(availableAmount.compareTo(updAmount) < 0){
                        throw new V5BusinessException(Result.ERROR, "钱包可用金额不足");
                    }
                    frozenAmount = frozenAmount.add(updAmount);
                }else if("05".equals(tradeType)){
//                    if(frozenAmount.compareTo(updAmount) < 0){
//                        throw new V5BusinessException(Result.ERROR, "钱包可用金额不足");
//                    }
                    //是否开通冻结业务：0否，1只针对冻结金额更新（虚付），2针对冻结金额更新并且完成真实转账（实付）
                    /*Integer isOpenLock = comWalletMapper.isOpenLock(code);
                    if(isOpenLock != null && isOpenLock == 1){//虚付
                        //收方冻结金额 减少
                        account = comWalletAccountMapper.getComWalletAccountByComId(inId);
                        frozenAmount = BigDecimal.valueOf(Double.parseDouble(account.getFrozenAmount()));
                        if(frozenAmount.compareTo(updAmount) < 0){
                            throw new V5BusinessException(Result.ERROR, "金额划拨不对等，请联系管理员");
                        }
                        frozenAmount = frozenAmount.subtract(updAmount);
                    }else if(isOpenLock != null && isOpenLock == 2){//实付
                        if(frozenAmount.compareTo(updAmount) < 0){
                            throw new V5BusinessException(Result.ERROR, "金额划拨不对等，请联系管理员");
                        }
                        //付方冻结金额 减少
                        frozenAmount = frozenAmount.subtract(updAmount);
                    }*/
                    if(frozenAmount.compareTo(updAmount) < 0){
                        throw new V5BusinessException(Result.ERROR, "金额划拨不对等，请联系管理员");
                    }
                    //付方冻结金额 减少
                    frozenAmount = frozenAmount.subtract(updAmount);
                }else if("03".equals(tradeType)){
                    if(availableAmount.compareTo(updAmount) < 0){
                        throw new V5BusinessException(Result.ERROR, "钱包可用金额不足");
                    }
                }
            }else {
                throw new V5BusinessException(Result.ERROR, "未读取到账户余额相关信息");
            }
        }else {
            throw new V5BusinessException(Result.ERROR, accRet.getMsg());
        }
        return frozenAmount;
    }

    /**
     * 企业转账接口
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-27
     */
    @Override
    public Result comWalletAccountTransfer(ComWalletTransferDTO dto) throws V5BusinessException {
        System.err.println(">>>>>>>>> 企业转账接口comWalletAccountTransfer："+dto.getBusinessPartnerSeq()+",开始");
        long a = System.currentTimeMillis();
        if (StringUtil.isEmpty(dto.getAmount())) {
            throw new V5BusinessException(Result.ERROR, "订单金额不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessCode())) {
            throw new V5BusinessException(Result.ERROR, "业务编码不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessPartnerSeq())) {
            throw new V5BusinessException(Result.ERROR, "业务交易流水号不能为空");
        }
        boolean redisRepetition = redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            System.err.println(">>>>>>>>> 企业转账接口comWalletAccountTransfer："+dto.getBusinessPartnerSeq()+",交易已提交，请勿重复操作");
            throw new V5BusinessException(Result.ERROR, "交易已提交，请勿重复操作");
        }
        int countTrade = comWalletTradeMapper.getComWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade>0) {
            System.err.println(">>>>>>>>> 企业转账接口comWalletAccountTransfer："+dto.getBusinessPartnerSeq()+",交易已完成，请勿重复操作");
            throw new V5BusinessException(Result.ERROR, "交易已完成，请勿重复操作");
        }
        if (StringUtil.isEmpty(dto.getGoodsName())) {
            throw new V5BusinessException(Result.ERROR, "订单商品名称不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsNumber())) {
            throw new V5BusinessException(Result.ERROR, "订单商品数量不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsUnit())) {
            throw new V5BusinessException(Result.ERROR, "订单商品单位不能为空");
        }
        if (StringUtil.isEmpty(dto.getNeedActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "是否需要验证码不能为空");
        }
        if (CommonConst.Y.equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty(dto.getMobilePhone())) {
                throw new V5BusinessException(Result.ERROR, "手机号不能为空");
            }
            if (StringUtil.isEmpty(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "短信验证码不能为空");
            }
            String activeCodeSerial = taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty(activeCodeSerial)) {
                throw new V5BusinessException(Result.ERROR, "验证码失效");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "验证码不正确");
            }
        }
        String tradeType = StringUtils.isEmpty(dto.getTradeType())?"05":dto.getTradeType();
        //冻结/解冻业务逻辑判断，计算记录冻结金额并入库(实际转账交易类型默认为 05 解冻)
        BigDecimal frozenAmount = extractedLock(Long.parseLong(dto.getOutId()),Long.parseLong(dto.getInId()),dto.getBusinessCode(), tradeType, dto.getAmount());
        System.err.println(">>>>>>>>> 企业转账接口comWalletAccountTransfer："+dto.getBusinessPartnerSeq()+",冻结金额："+frozenAmount);
        Map<Object, Object> p = new HashMap<>();
        ComWalletAccountDTO outAccount;
        ComWalletAccountDTO inAccount;
        if(StringUtils.isEmpty(dto.getTlkComId())) {
            outAccount = comWalletAccountMapper.getComWalletAccountByComId(Long.parseLong(dto.getOutId()));
            inAccount = comWalletAccountMapper.getComWalletAccountByComId(Long.parseLong(dto.getInId()));
            p.put("outId", getMemberNo(dto.getOutId()+""));
            p.put("inId", getMemberNo(dto.getInId()+""));
        }else{
            outAccount = comWalletAccountMapper.getComWalletAccountByTLKComId(dto.getOutId());
            inAccount = comWalletAccountMapper.getComWalletAccountByTLKComId(dto.getInId());
            p.put("outId", getMemberNo(outAccount.getComId()+""));
            p.put("inId", getMemberNo(inAccount.getComId()+""));
        }

        /* 调用支付平台接口分账接口 ***/
        Long orderId = idWorker.nextId();
        p.put("outName", outAccount.getComName());
        p.put("outWalletAccountNo", outAccount.getWalletAccountNo());

        p.put("inName", inAccount.getComName());
        p.put("inWalletAccountNo", inAccount.getWalletAccountNo());
        p.put("inBankCardNo", inAccount.getBankCardNo());

        p.put("amount", dto.getAmount());
        p.put("bizOrderNo", orderId);
        p.put("comment", dto.getComment());
        //TODO 新增字段待完善
        p.put("goodsName", dto.getGoodsName());//订单商品名称
        p.put("goodsNumber", dto.getGoodsNumber());//订单商品数量
        p.put("goodsUnit", dto.getGoodsUnit());//订单商品单位
        p.put("returnUrl", "");//支付成功后跳转连接
        p.put("callbackUrl", "");//回调通知地址

//        p.put("needActiveCode", dto.getNeedActiveCode());
//        if (CommonConst.Y.equals(dto.getNeedActiveCode())) {
//            p.put("activeCode", dto.getActiveCode());
//            p.put("activeCodeSerial", taskCacheService.getActiveCodeSerial(dto.getMobilePhone()));
//        }

        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.WALLET_ACCOUNT_TRANSFER, requestMap);
        System.err.println(">>>>>>>>> 企业转账接口comWalletAccountTransfer："+dto.getBusinessPartnerSeq()+",支付申请："+resultStr);
        Result result = JSON.parseObject(resultStr, Result.class);
        /* 插入企业钱包账户交易记录 ***/
        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(orderId);
        comWalletTrade.setBusinessCode(dto.getBusinessCode());
        comWalletTrade.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
        comWalletTrade.setCreateTime(DateUtil.date());
        comWalletTrade.setUpdateTime(new Date());
        comWalletTrade.setComment(dto.getComment());
        comWalletTrade.setComId(Long.parseLong(dto.getOutId()));
        comWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
        comWalletTrade.setTradeType(DictConst.TRADETYPE_QYZHZF); // 企业账户支付
        /* 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            //组装确认转账接口参数
            ComCheckTransferDTO comCheckTransferDTO = new ComCheckTransferDTO();
            comCheckTransferDTO.setAmount(dto.getAmount());
            comCheckTransferDTO.setOrderId(orderId+"");
            comCheckTransferDTO.setOutId(getMemberNo(outAccount.getComId()+""));
            comCheckTransferDTO.setInId(getMemberNo(inAccount.getComId()+""));
            comCheckTransferDTO.setInName(inAccount.getComName());
            comCheckTransferDTO.setInWalletAccountNo(inAccount.getWalletAccountNo());
            comCheckTransferDTO.setInBankCardNo(inAccount.getBankCardNo());
            //加入定时任务 5分钟跑一次
            comTaskResidualAPIService.saveComTaskResidual("checkTransfer","申请支付完成后的确认支付任务","com.bcxin.platform.service.wallet.ComWalletService",1,"com.bcxin.platform.dto.wallet.ComCheckTransferDTO",JSON.toJSONString(comCheckTransferDTO));

            //更新冻结金额
            comWalletAccountMapper.updateFrozenAmount(Long.parseLong(dto.getOutId()),frozenAmount.toString());
            comWalletTrade.setTradeStatus(DictConst.TRADESTATUS_JYCG); // 交易成功
            comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
            System.err.println("===>comWalletAccountTransfer.本次转账耗时："+((System.currentTimeMillis()-a)/1000)+"秒");
            System.err.println(">>>>>>>>> 企业转账接口comWalletAccountTransfer："+dto.getBusinessPartnerSeq()+",支付确认：succ");
            return Result.success(Result.SUCCESS_MSG, orderId);
        } else {
            System.err.println(">>>>>>>>> 企业转账接口comWalletAccountTransfer："+dto.getBusinessPartnerSeq()+",支付申请：fail");
            return Result.fail(result.getMsg());
        }
    }

    /**
     * <b> 确认支付：支付申请成功后调这个接口完成最终转账 </b>
     * @author ZXF
     * @create 2023/04/21 0021 10:30
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result checkTransfer(ComCheckTransferDTO comCheckTransferDTO) {
        //调确认支付接口 确认支付状态
        Map<Object, Object> p = new HashMap<>();
        p.put("amount", comCheckTransferDTO.getAmount());
        p.put("bizOrderNo", comCheckTransferDTO.getOrderId());//支付申请的订单号
        p.put("bizOrderNoOrigin", comCheckTransferDTO.getOrderId());//支付申请的流水号
        p.put("comment", "订单（"+comCheckTransferDTO.getOrderId()+"）的确认支付");
        p.put("outId", comCheckTransferDTO.getOutId());
        p.put("inId", comCheckTransferDTO.getInId());
        p.put("inName", comCheckTransferDTO.getInName());
        p.put("inWalletAccountNo", comCheckTransferDTO.getInWalletAccountNo());
        p.put("inBankCardNo", comCheckTransferDTO.getInBankCardNo());
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.WALLET_ACCOUNT_CONFIRMPAYMENT, requestMap);
        System.err.println(">>>>>>>>> 企业转账接口comWalletAccountTransfer："+comCheckTransferDTO.getOrderId()+",支付确认："+resultStr);
        Result result = JSON.parseObject(resultStr, Result.class);
        if (Result.SUCCESS.equals(result.getRetType())) {
            Map<String, Object> map = (Map<String, Object>) result.getData();
            String status = map.get("trade_status").toString();
            if("2".equals(status)){
                return Result.fail("交易失败");
            }else{
                return Result.success(Result.SUCCESS_MSG);
            }
        } else {
            return Result.fail(result.getMsg());
        }
    }

    /**
     * <b> 取消支付：支付申请成功后调这个接口取消转账 </b>
     * @author ZXF
     * @create 2023/04/21 0021 10:30
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result cancelTransfer(ComCheckTransferDTO comCheckTransferDTO) {
        //调取消支付接口
        Map<Object, Object> p = new HashMap<>();
        p.put("amount", comCheckTransferDTO.getAmount());
        p.put("bizOrderNo", comCheckTransferDTO.getOrderId());//支付申请的订单号
        p.put("bizOrderNoOrigin", comCheckTransferDTO.getOrderId());//支付申请的流水号
        p.put("comment", "订单（"+comCheckTransferDTO.getOrderId()+"）的取消支付");
        p.put("outId", comCheckTransferDTO.getOutId());
        p.put("inId", comCheckTransferDTO.getInId());
        p.put("inName", comCheckTransferDTO.getInName());
        p.put("inWalletAccountNo", comCheckTransferDTO.getInWalletAccountNo());
        p.put("inBankCardNo", comCheckTransferDTO.getInBankCardNo());
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.WALLET_ACCOUNT_CANCELPAYMENT, requestMap);
        System.err.println(">>>>>>>>> 企业转账接口comWalletAccountTransfer："+comCheckTransferDTO.getOrderId()+",取消支付："+resultStr);
        Result result = JSON.parseObject(resultStr, Result.class);
        if (Result.SUCCESS.equals(result.getRetType())) {
            Map<String, Object> map = (Map<String, Object>) result.getData();
            String status = map.get("trade_status").toString();
            if("2".equals(status)){
                return Result.fail("交易失败");
            }else{
                return Result.success(Result.SUCCESS_MSG);
            }
        } else {
            return Result.fail(result.getMsg());
        }
    }

    /**
     * <b> 企业异步转账接口 </b>
     * @author ZXF
     * @create 2023/04/06 0006 10:46
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result syncComWalletAccountTransfer(ComWalletTransferDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty(dto.getAmount())) {
            throw new V5BusinessException(Result.ERROR, "订单金额不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessCode())) {
            throw new V5BusinessException(Result.ERROR, "业务编码不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessPartnerSeq())) {
            throw new V5BusinessException(Result.ERROR, "业务交易流水号不能为空");
        }
        boolean redisRepetition = redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            throw new V5BusinessException(Result.ERROR, "交易已提交，请勿重复操作");
        }
        int countTrade = comWalletTradeMapper.getComWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade>0) {
            throw new V5BusinessException(Result.ERROR, "交易已完成，请勿重复操作");
        }
        if (StringUtil.isEmpty(dto.getGoodsName())) {
            throw new V5BusinessException(Result.ERROR, "订单商品名称不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsNumber())) {
            throw new V5BusinessException(Result.ERROR, "订单商品数量不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsUnit())) {
            throw new V5BusinessException(Result.ERROR, "订单商品单位不能为空");
        }
        if (StringUtil.isEmpty(dto.getNeedActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "是否需要验证码不能为空");
        }
        if (CommonConst.Y.equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty(dto.getMobilePhone())) {
                throw new V5BusinessException(Result.ERROR, "手机号不能为空");
            }
            if (StringUtil.isEmpty(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "短信验证码不能为空");
            }
            String activeCodeSerial = taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty(activeCodeSerial)) {
                throw new V5BusinessException(Result.ERROR, "验证码失效");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "验证码不正确");
            }
        }
        //这边保留获取余额业务是为了验证钱包金额条件过滤判断
        //冻结/解冻业务逻辑判断，计算记录冻结金额并入库(实际转账交易类型默认为 05 解冻)
        BigDecimal frozenAmount = extractedLock(Long.parseLong(dto.getOutId()),Long.parseLong(dto.getInId()),dto.getBusinessCode(), "05", dto.getAmount());
        comTaskResidualAPIService.saveComTaskResidual2("comWalletAccountTransfer","企业确认成绩转账任务","com.bcxin.platform.service.wallet.ComWalletService",1,"com.bcxin.platform.dto.wallet.ComWalletTransferDTO",JSON.toJSONString(dto));
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * <b> 平台转账接口 </b>
     * @author ZXF
     * @create 2023/02/27 0027 15:41
     * @version
     * @注意事项 平台转账也是用的上面企业转账接口进行转账，当前接口的目的是将平台转账的信息录入任务表通过异步完成转账调用
     */
    @Override
    public Result syncPlatWalletAccountTransfer(ComWalletTransferDTO dto) throws V5BusinessException {
        if (dto.getOutId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业出账ID不能为空");
        }
        if (dto.getInId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业入账ID不能为空");
        }
        if (StringUtil.isEmpty(dto.getAmount())) {
            throw new V5BusinessException(Result.ERROR, "订单金额不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessCode())) {
            throw new V5BusinessException(Result.ERROR, "业务编码不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessPartnerSeq())) {
            throw new V5BusinessException(Result.ERROR, "业务交易流水号不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsName())) {
            throw new V5BusinessException(Result.ERROR, "订单商品名称不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsNumber())) {
            throw new V5BusinessException(Result.ERROR, "订单商品数量不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsUnit())) {
            throw new V5BusinessException(Result.ERROR, "订单商品单位不能为空");
        }
        if (StringUtil.isEmpty(dto.getNeedActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "是否需要验证码不能为空");
        }
        if (CommonConst.Y.equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty(dto.getMobilePhone())) {
                throw new V5BusinessException(Result.ERROR, "手机号不能为空");
            }
            if (StringUtil.isEmpty(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "短信验证码不能为空");
            }
            String activeCodeSerial = taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty(activeCodeSerial)) {
                throw new V5BusinessException(Result.ERROR, "验证码失效");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "验证码不正确");
            }
        }
        //comTaskResidualAPIService.disposeComTaskResidualList("");方法触发执行任务
        comTaskResidualAPIService.saveComTaskResidual2("comWalletAccountTransfer","平台分账任务","com.bcxin.platform.service.wallet.ComWalletService",1,"com.bcxin.platform.dto.wallet.ComWalletTransferDTO",JSON.toJSONString(dto));
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * <b> 平台转账接口(白天跑) </b>
     * @author ZXF
     * @create 2023/02/27 0027 15:41
     * @version
     * @注意事项 平台转账也是用的上面企业转账接口进行转账，当前接口的目的是将平台转账的信息录入任务表通过异步完成转账调用
     */
    @Override
    public Result platWalletAccountTransfer(ComWalletTransferDTO dto) throws V5BusinessException {
        if (dto.getOutId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业出账ID不能为空");
        }
        if (dto.getInId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业入账ID不能为空");
        }
        if (StringUtil.isEmpty(dto.getAmount())) {
            throw new V5BusinessException(Result.ERROR, "订单金额不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessCode())) {
            throw new V5BusinessException(Result.ERROR, "业务编码不能为空");
        }
        if (StringUtil.isEmpty(dto.getBusinessPartnerSeq())) {
            throw new V5BusinessException(Result.ERROR, "业务交易流水号不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsName())) {
            throw new V5BusinessException(Result.ERROR, "订单商品名称不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsNumber())) {
            throw new V5BusinessException(Result.ERROR, "订单商品数量不能为空");
        }
        if (StringUtil.isEmpty(dto.getGoodsUnit())) {
            throw new V5BusinessException(Result.ERROR, "订单商品单位不能为空");
        }
        if (StringUtil.isEmpty(dto.getNeedActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "是否需要验证码不能为空");
        }
        if (CommonConst.Y.equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty(dto.getMobilePhone())) {
                throw new V5BusinessException(Result.ERROR, "手机号不能为空");
            }
            if (StringUtil.isEmpty(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "短信验证码不能为空");
            }
            String activeCodeSerial = taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty(activeCodeSerial)) {
                throw new V5BusinessException(Result.ERROR, "验证码失效");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "验证码不正确");
            }
        }
        //comTaskResidualAPIService.disposeComTaskResidualList("");方法触发执行任务
        comTaskResidualAPIService.saveComTaskResidual("comWalletAccountTransfer","平台分账任务","com.bcxin.platform.service.wallet.ComWalletService",1,"com.bcxin.platform.dto.wallet.ComWalletTransferDTO",JSON.toJSONString(dto));
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 企业消费分账接口
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-08-20
     */
    @Override
    public Result comWalletAccountConsumeLedger(ComWalletConsumeLedgerDTO dto) throws V5BusinessException {
        if (dto.getOutId() == null) {
            throw new V5BusinessException(Result.ERROR, "企业出账ID不能为空");
        }
        if (StringUtil.isEmpty(dto.getAmount())) {
            throw new V5BusinessException(Result.ERROR, "订单金额不能为空");
        }
        if (CollUtil.isEmpty(dto.getLedgerInfoList())) {
            throw new V5BusinessException(Result.ERROR, "分账信息不能为空");
        }

        if (StringUtil.isEmpty(dto.getMobilePhone())) {
            throw new V5BusinessException(Result.ERROR, "手机号不能为空");
        }
        if (StringUtil.isEmpty(dto.getActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "短信验证码不能为空");
        }
        String activeCodeSerial = taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
        if (StringUtil.isEmpty(activeCodeSerial)) {
            throw new V5BusinessException(Result.ERROR, "验证码失效");
        }
        if (!activeCodeSerial.equals(dto.getActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "验证码不正确");
        }

        List<Map<String, String>> list = Lists.newArrayList();

        ComWalletAccountDTO outAccount = comWalletAccountMapper.getComWalletAccountByComId(Long.parseLong(dto.getOutId()));
        for (ComWalletConsumeLedgerDTO.LedgerInfo ledgerInfo : dto.getLedgerInfoList()) {
            ComWalletAccountDTO inAccount = comWalletAccountMapper.getComWalletAccountByComId(Long.parseLong(ledgerInfo.getInId()));
            Map<String, String> map = Maps.newHashMap();
            map.put("inId", getMemberNo(ledgerInfo.getInId()+""));
            map.put("inWalletAccountNo", inAccount.getWalletAccountNo());
            map.put("amount", ledgerInfo.getAmount());
            list.add(map);
        }

        /*** 调用支付平台接口分账接口 ***/
        Long orderId = idWorker.nextId();
        Map<Object, Object> p = new HashMap<>();
        p.put("outId", getMemberNo(dto.getOutId()+""));
        p.put("bizOrderNo", orderId.toString()); // 业务流水号
        p.put("amount", dto.getAmount()); // 金额
        p.put("outWalletAccountNo", outAccount.getWalletAccountNo()); // 钱包号
        /* put 分账信息*/
        p.put("ledgerInfo", JSON.toJSONString(list));
        /* 激活码 */
        p.put("activeCode", dto.getActiveCode());
        p.put("activeCodeSerial", taskCacheService.getActiveCodeSerial(dto.getMobilePhone()));
        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.WALLET_ACCOUNT_LEDGER, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /*** 插入企业钱包账户交易记录 ***/
        ComWalletTrade comWalletTrade = new ComWalletTrade();
        comWalletTrade.setComWalletTradeId(orderId);
        comWalletTrade.setCreateTime(DateUtil.date());
        comWalletTrade.setUpdateTime(new Date());
        comWalletTrade.setComId(Long.parseLong(dto.getOutId()));
        comWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
        comWalletTrade.setTradeType(DictConst.TRADETYPE_QYZHZF); // 企业账户支付
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            comWalletTrade.setTradeStatus(DictConst.TRADESTATUS_JYCG); // 交易成功
            comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
            return Result.success(Result.SUCCESS_MSG);
        } else {
            comWalletTrade.setTradeStatus(DictConst.TRADESTATUS_JYSB); // 交易失败
            comWalletTradeMapper.insertComWalletTrade(comWalletTrade);
            /*** 返回失败则抛错 ***/
            return Result.fail(result.getMsg());
        }
    }

    /**
     * 电子回单
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-07-08
     */
    @Override
    public String getComAccountTradeVoucher(ComWalletTradeDTO dto) throws V5BusinessException {
        /*** 调用支付平台接口获取电子回单 ***/
        Map<Object, Object> p = Maps.newHashMap();
        p.put("comId", getMemberNo(dto.getComId()+""));
        p.put("tradeFlowNo", dto.getTradeFlowNo());
        //如果saas库存在文件地址先取取库里的，否则去支付平台找富民接口要
        if (dto.getComId() != null && StringUtils.isNotEmpty(dto.getTradeFlowNo())) {
            //根据财务流水号(flowNo)和comId 查询电子回单地址
            String voucherUrl = comWalletAccountDetailMapper.getVoucherUrlByTradeFlowNo(dto.getTradeFlowNo(),dto.getComId());
            if (StringUtils.isNotEmpty(voucherUrl)) {
                return BcxinFileUtils.getInputStreamByUrl(voucherUrl);
            }
        }
//        ComWalletAccountDTO comWalletAccount = comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        String tradeDate = comWalletAccountDetailMapper.getTradeDateByTradeFlowNo(dto.getTradeFlowNo(),dto.getComId());
        String accountIn = comWalletAccountDetailMapper.getAccountInByTradeFlowNo(dto.getTradeFlowNo(),dto.getComId());
        if(StringUtils.isEmpty(tradeDate)){
            throw new V5BusinessException(Result.BUSINESS_ERROR, "未匹配到交易记录");
        }
        p.put("tradeDate", tradeDate);
        p.put("accountIn", accountIn);

        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platform = commonService.getSystemConfig("PLATFORM_SIGN");
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.ACCOUNT_TRADE_VOUCHER, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            Map<String, Object> map = (Map<String, Object>) result.getData();
            if(map != null && map.get("base_content")==null){
                throw new V5BusinessException(Result.BUSINESS_ERROR, "电子回单下载失败：当天进行的交易只能次日才能进行回单下载；不是上述情况请联系客服反馈。");
            }
            /* 上传华为OBS */
            String voucherUrl = BcxinFileUtils.huaweiBase64Upload(map.get("base_content").toString(),dto.getTradeFlowNo()+accountIn + ".pdf", DateUtil.today(),platform);
            /*StringBuilder builder = new StringBuilder(map.get("base_content").toString());
            String tempPath = commonService.getSystemConfig("SYS_PIC_PATH");
            File file = new File(tempPath + dto.getTradeFlowNo() + ".pdf");
            Base64.decodeToFile(builder.toString(), file);
            *//* 上传华为OBS *//*
            String voucherUrl = BcxinFileUtils.huaweiLocalFileUpload(file, DateUtil.today(),platform);
            *//* 删掉临时文件 *//*
            BcxinFileUtils.deleteFolder(file);*/
            comWalletAccountDetailMapper.updateVoucherUrlByComId(dto.getComId(),voucherUrl,dto.getTradeFlowNo());
            return map.get("base_content").toString();
        }else{
            throw new V5BusinessException(Result.BUSINESS_ERROR, result.getMsg());
        }
    }

    /**
     * <b> 电子回单获取任务 </b>
     * @author ZXF
     * @create 2023/04/21 0021 17:06
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result taskTradeVoucher(String tradeDate) throws V5BusinessException {
        if(StringUtils.isEmpty(tradeDate)){
            try {
                tradeDate = DateUtils.dateAdd(CommonConst.BLANK_CHAR,DateUtils.getDate(),"yyyy-MM-dd",-1).replace("-","");
                String tradeDate2 = DateUtils.dateAdd(CommonConst.BLANK_CHAR,DateUtils.getDate(),"yyyy-MM-dd",-2).replace("-","");
                new Thread(()->{ //每次跑昨天的电子回单都异步跑下前天的电子回单
                    try {
                        taskTradeVoucher(tradeDate2);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }).start();
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Map<Object, Object> p = Maps.newHashMap();
        p.put("tradeDate", tradeDate);

        String token = JwtUtil.createJWT(p);//加密生成token
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.ACCOUNT_TRADE_VOUCHERBATCHDECOMPRESSION, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            return Result.success("文件拉取成功");
        }
        return Result.fail("文件拉取失败");
    }


    /**
     * 交易凭证
     *
     * @param dto
     * @return
     * @author lp
     * @date 2019-09-03
     */
    @Override
    public String getComAccountPayVoucher(ComWalletTradeDTO dto) throws V5BusinessException {
        /*** 调用支付平台接口获取电子回单 ***/
        Map<Object, Object> p = new HashMap<>();
        p.put("bizOrderNo", dto.getTradeFlowNo());
        //加密生成token
        String token = JwtUtil.createJWT(p);
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("token", token);
        String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
        String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.ACCOUNT_PAY_VOUCHER, requestMap);
        Result result = JSON.parseObject(resultStr, Result.class);
        /*** 如果返回成功 ***/
        if (Result.SUCCESS.equals(result.getRetType())) {
            Map<String, Object> map = (Map<String, Object>) result.getData();
            return map.get("base_content").toString();
        }
        return "";
    }

    /**
     * 企业钱包账户对账数据生成
     *
     * @author llc
     * @date 2019-08-20
     */
    @Override
    public Result createComWalletReconciliation(String testDate) throws V5BusinessException {

        /*** 获取指定日期的前两天数据 ***/
        String lastDate = DateUtils.getSpecifiedDayBefore(DateUtils.getDate(), 2);
        List<Date> dateList = DateUtils.getBetweenDates(DateUtils.parseDate(lastDate), new Date());
//        List<Date> dateList = DateUtils.getBetweenDates(DateUtils.parseDate("2019-10-11"),new Date());
        if(StringUtils.isNotEmpty(testDate)){
            dateList = Lists.newArrayList();
            dateList.add(DateUtils.parseDate(testDate));
        }
        for (Date date : dateList) {
            /*** 调用支付平台接口获取企业对账数据 ***/
            Map<Object, Object> p = new HashMap<>();
            String tradeDate = DateUtils.formatDate(date).replaceAll("-", "");
            p.put("date", tradeDate);  // YYYYMMDD格式
            //加密生成token
            String token = JwtUtil.createJWT(p);
            Map<String, Object> requestMap = new HashMap<>();
            requestMap.put("token", token);
            String platUrl = commonService.getSystemConfig(CommonConst.PAYMENT_PLATFORM_URL);
//            String platUrl =  "http://pay.bcxin.com.cn:81/";
            String resultStr = HttpUtil.post(platUrl + PaymentServiceConst.GET_COM_WALLET_RECONCILIATION, requestMap);
            if (StringUtil.isNotEmpty(resultStr)) {
                Map<String, Object> map = JSON.parseObject(resultStr, Map.class);

                if (map.get("data") != null && StringUtil.isNotEmpty(map.get("data").toString())) {
                    Map<String, Object> m = JSON.parseObject(map.get("data").toString(), Map.class);
                    /*** 交易数据 ***/
                    String content = m.get("content") != null ? m.get("content").toString() : null;
                    if (StringUtil.isNotEmpty(content)) {

                        String[] tradeInfoStr = content.split("\\|"); // 交易信息数组
                        /*** 如果交易信息有值且笔数不为0
                         e企付综合对账单||||||||||||||||||||||||||||
                         对账日期：20200509|代理银行编码：ICBC|对账单号：20200509001||记录数：13|合作方平台号：00200000XXXXXXXXXXXXX0000128061||合作方平台名称：e企付测试|||||||||||||||||||||
                         合作方平台提交时间|支付平台流水|订单金额|订单币种|交易类型|交易渠道|支付工具|本次支付金额|交易状态|收款账号|收款方户名|收方会员号|收方会员名称|收款行联行号|收款方银行|人民币付方账号|人民币付方户名|购汇币种|购汇金额|外币付方账号|外币付方户名|现汇金额|付方系统内外标志|付款方银行|票据号|票据支付流水号|原保留平台流水号|预留1|预留2
                         20200509094001|50906|413.09|1-人民币(本位币)|101-支付|2-移动|1-现金|413.09|1-成功|0200XXX41XX00004203|北京工行e企付测试信息科技有限公司|||||140xxxxxxx09094852|北京e企付测试1公司|1-人民币(本位币)|0.00|||0.00|3-对公我行||||||
                         20200509100456|50121|30857.73|1-人民币(本位币)|101-支付|2-移动|1-现金|30857.73|1-成功|0200XXX41XX00004204|北京工行e企付测试信息科技有限公司|||||140xxxxxxx09094321|北京e企付测试2公司|1-人民币(本位币)|0.00|||0.00|3-对公我行||||||
                         20200509110627|49336|32902.63|1-人民币(本位币)|101-支付|2-移动|1-现金|32902.63|1-成功|0200XXX41XX00004205|北京工行e企付测试信息科技有限公司|||||140xxxxxxx09093790|北京e企付测试3公司|1-人民币(本位币)|0.00|||0.00|3-对公我行||||||
                         20200509111459|48551|3398.00|1-人民币(本位币)|101-支付|2-移动|1-现金|3398.00|1-成功|0200XXX41XX00004206|北京工行e企付测试信息科技有限公司|||||140xxxxxxx09093259|北京e企付测试4公司|1-人民币(本位币)|0.00|||0.00|3-对公我行||||||
                         *
                         * ***/
                        /*** 如果当天的交易数据不等于0 ***/
                        String limit = tradeInfoStr[32].replace("记录数：","");
                        if (tradeInfoStr.length > 0 && !"0".equals(limit)) {
                            List<String> tradedetailStrList = StrSpliter.split(content, "\n", true, true);
                            tradedetailStrList.remove(0);// 清除第一行标题
                            tradedetailStrList.remove(0);// 清除第二行汇总
                            tradedetailStrList.remove(0);// 清除第三行列名
                            if (tradedetailStrList.size() > 0) {
                                List<ComWalletReconciliation> list = new ArrayList<>();
                                for (String tradedetail : tradedetailStrList) {
                                    /*** 因为后面可能都为空，需要limit负数能全部解析 ***/
                                    String[] detailStr = tradedetail.split("\\|", -1);
                                    ComWalletReconciliation comWalletReconciliation = new ComWalletReconciliation();
                                    comWalletReconciliation.setTradeSerialNo(detailStr[1]); // 交易流水号 *
                                    comWalletReconciliation.setMerchantNo(detailStr[0]); // 商户号
                                    comWalletReconciliation.setRequestSerialNo(detailStr[26]); // 请求流水号*
                                    comWalletReconciliation.setTradeAmount(StringUtils.isEmpty(detailStr[7]) ? BigDecimal.ZERO : new BigDecimal(detailStr[7])); // 交易金额 *
                                    comWalletReconciliation.setTradeStatus(detailStr[8]); //交易状态*
                                    comWalletReconciliation.setBankTradeType(detailStr[4]); // 银行交易类型*
                                    comWalletReconciliation.setTradeStartTime(detailStr[0]); //交易订单创建时间*
                                    comWalletReconciliation.setTradeEndTime(detailStr[0]); //交易订单完成时间
                                    String expendAccountNo = detailStr[15];
                                    if(StringUtils.isNotEmpty(detailStr[15])){
                                        ComWalletAccountDTO account = comWalletAccountMapper.getComWalletAccountByWalletNoORCardnoGS(detailStr[15]);
                                        if(account!=null){
                                            comWalletReconciliation.setExpendComId(account.getComId());
                                            expendAccountNo = account.getWalletAccountNo();
                                        }
                                        comWalletReconciliation.setExpendBankCode("ICBC"); //出账方银行编码* detailStr[23]
                                    }
                                    comWalletReconciliation.setExpendAccountNo(expendAccountNo); //出账方账号*
                                    comWalletReconciliation.setExpendAccountName(detailStr[16]); //出账方户名*
                                    String incomeAccountNo = detailStr[9];
                                    if(StringUtils.isNotEmpty(detailStr[9])){
                                        ComWalletAccountDTO account = comWalletAccountMapper.getComWalletAccountByWalletNoORCardnoGS(detailStr[9]);
                                        if(account!=null){
                                            comWalletReconciliation.setIncomeComId(account.getComId());
                                            incomeAccountNo = account.getWalletAccountNo();
                                        }
                                        comWalletReconciliation.setIncomedBankCode("ICBC"); //入账方银行编码* detailStr[14]
                                    }
                                    comWalletReconciliation.setIncomeAccountNo(incomeAccountNo); //入账方账号*
                                    comWalletReconciliation.setIncomeAccountName(detailStr[10]); //入账方户名*
                                    comWalletReconciliation.setIncomeCerNo(""); //入账方证件号
                                    comWalletReconciliation.setMerchantRetain(""); //商户保留域
                                    comWalletReconciliation.setAllotAccountInfo(""); //分账信息
                                    comWalletReconciliation.setAllotBenefitInfo(""); //分润信息
                                    comWalletReconciliation.setRemark(""); //交易备注
                                    comWalletReconciliation.setServiceCharge(""); //手续费
                                    comWalletReconciliation.setGuaranteeInfo(""); //担保信息
                                    list.add(comWalletReconciliation);
                                }
                                /*** 插入或更新本地数据库 ***/
                                if (list.size() > 0) {
                                    /*** 1.插入临时对帐数据 ***/
                                    comWalletReconciliationMapper.insertTempReconciliationList(list);

                                    /*** 2.更新企业钱包对账数据 ***/
                                    comWalletReconciliationMapper.updateComWalletReconciliation(tradeDate);

                                    /*** 3.插入企业钱包对账数据 ***/
                                    comWalletReconciliationMapper.insertComWalletReconciliation(tradeDate);

                                    /*** 4.清除临时企业钱包对账数据 ***/
                                    comWalletReconciliationMapper.deleteTempWalletReconciliation();
                                }
                            }
                        }
                    }
                }
            }
        }
        return Result.success(Result.SUCCESS_QUERY_MSG);
    }

    /**
     * 获取企业钱包账户对账数据
     *
     * @author llc
     * @date 2019-09-19
     */
    @Override
    public Result getComWalletReconciliation(ComWalletTradeDTO dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (dto.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if (StringUtil.isEmpty(dto.getFundFlowType())) {
            return Result.fail("资金流向不能为空");
        }
        if (dto.getComId() == null) {
            return Result.fail("企业ID不能为空");
        }
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
        /*** 查询企业钱包账户对账数据列表 ***/
        List<Map<String, Object>> list = comWalletReconciliationMapper.getWalletReconciliationList(dto);

        /*** 获取企业钱包账户对账统计数据 ***/
        Map<String, Object> map = comWalletReconciliationMapper.getWalletReconciliationSum(dto);

        PageInfoUtils pageInfo = new PageInfoUtils(list);

        if (map != null) {
            map.put("pageInfo", pageInfo); // 分页信息
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, map);

    }

    /**
     * 导出企业钱包账户对账数据
     *
     * @author llc
     * @date 2019-09-20
     */
    @Override
    public Result exportComWalletReconciliation(ComWalletTradeDTO dto, HttpServletResponse response) throws V5BusinessException {
        if (StringUtil.isEmpty(dto.getFundFlowType())) {
            return Result.fail("资金流向不能为空");
        }
        if (dto.getComId() == null) {
            return Result.fail("企业ID不能为空");
        }
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            String fileName = "对账数据" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("对账数据");


            /*** 查询企业钱包账户对账数据列表 ***/
            List<Map<String, Object>> list = comWalletReconciliationMapper.getWalletReconciliationList(dto);

            /*** 填充文本样式 ***/
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);

            /**** 生成sheet1的内容 ***/
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short) 11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("黑体");
            titleStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);// 水平居中
            titleStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);// 垂直居中
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));

            /**** 生成sheet1的内容 ***/
            /*** 获取企业钱包账户对账统计数据 ***/
            Map<String, Object> map = comWalletReconciliationMapper.getWalletReconciliationSum(dto);
            String headerTitle = "";
            if (map == null) {
                headerTitle = MessageFormat.format("总笔数：【{0}】笔 | 总金额：【{1}】元 | 成功笔数：【{2}】笔 | 成功金额：【{3}】元 | 失败笔数：【{4}】笔 | 失败金额：【{5}】元 | 处理中笔数：【{6}】笔 | 处理中金额：【{7}】元",
                        0, 0, 0, 0, 0, 0, 0, 0);
            } else {
                headerTitle = MessageFormat.format("总笔数：【{0}】笔 | 总金额：【{1}】元 | 成功笔数：【{2}】笔 | 成功金额：【{3}】元 | 失败笔数：【{4}】笔 | 失败金额：【{5}】元 | 处理中笔数：【{6}】笔 | 处理中金额：【{7}】元",
                        map.get("totalCount"), map.get("sumAmount"), map.get("successCount"), map.get("successAmount"), map.get("errorCount"), map.get("errorAmount"), map.get("processingCount"), map.get("processingAmount"));
            }

            /*** 填充第一行数据 ***/
            HSSFCellStyle titleStyle1 = wb.createCellStyle();
            HSSFFont titleFont1 = wb.createFont();
            titleFont1.setFontHeightInPoints((short) 11);
            titleFont1.setColor(HSSFColor.RED.index);
            titleFont1.setFontName("黑体");
            titleStyle1.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);// 垂直居中
            titleStyle1.setFont(titleFont1);
            titleStyle1.setWrapText(true);
            HSSFRow rowFirst = sheet1.createRow(0); // 第一个sheet的第一行为标题
            rowFirst.setHeight((short) (1000));
            sheet1.addMergedRegion(new CellRangeAddress(0, (short) 0, 0, 13));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle1);

            /*** 填充第二行数据 ***/
            HSSFRow secondFirst = sheet1.createRow(1);
            String[] secondArr = {"序号", "交易流水号", "银行交易类型", "交易状态", "交易订单创建时间", "交易金额", "出账方户名", "出账方账号", "出账方银行", "入账方户名", "入账方账号", "入账方银行", "入账方证件号", "备注"};
            int column;
            for (int i = 0; i < secondArr.length; i++) {
                HSSFCell cell = secondFirst.createCell(i); // 获取第二行的每个单元格
                if (i == 0) {
                    column = 1500;
                } else if (i == 4) {
                    column = 5000;
                } else if (i == 1 || i == 7 || i == 10 || i == 13) {
                    column = 8000;
                } else if (i == 6 || i == 9) {
                    column = 10000;
                } else if (i == 13) {
                    column = 14000;
                } else {
                    column = 4000;
                }
                sheet1.setColumnWidth(i, column); // 设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle); // 设置单元格格式 --文本格式
                cell.setCellStyle(titleStyle); // 文本格式
            }

            /*** 填充第二行数据 ***/
            for (int i = 0; i < secondArr.length; i++) {
                HSSFCell cell = secondFirst.createCell(i); // 获取第一行的每个单元格
                cell.setCellValue(secondArr[i]);
                cell.setCellStyle(titleStyle);
            }

            /*** 字体颜色样式 ***/
            CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);// 青绿色样式
            CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index); // 红色样式
            CellStyle blueStyle = ExcelUtil.getColorStyle(wb, IndexedColors.BLUE.index); // 红色样式
            HSSFRow row = null;
            int rowIndex = 2;
            for (Map<String, Object> result : list) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(rowIndex - 1);
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("tradeSerialNo") != null ? result.get("tradeSerialNo").toString() : null); // 交易流水号
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("bankTradeType") != null ? result.get("bankTradeType").toString() : null); // 银行交易类型
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("tradeStatus") != null ? result.get("tradeStatus").toString() : null); // 交易状态
                if (ObjectUtil.equal(result.get("tradeStatus"), "交易成功")) {
                    cell3.setCellStyle(greenStyle);
                } else if (ObjectUtil.equal(result.get("tradeStatus"), "交易失败")) {
                    cell3.setCellStyle(redStyle);
                } else {
                    cell3.setCellStyle(blueStyle);
                }
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("tradeStartTime") != null ? result.get("tradeStartTime").toString() : null); // 交易订单创建时间
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("tradeAmount") != null ? result.get("tradeAmount").toString() : null); // 交易金额
                cell5.setCellStyle(redStyle);
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("expendAccountName") != null ? result.get("expendAccountName").toString() : null);// 出账方户名
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("expendAccountNo") != null ? result.get("expendAccountNo").toString() : null);// 出账方账号
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("expendBank") != null ? result.get("expendBank").toString() : null);// 出账方银行
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("incomeAccountName") != null ? result.get("incomeAccountName").toString() : null);// 入账方户名
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("incomeAccountNo") != null ? result.get("incomeAccountNo").toString() : null);// 入账方账号
                HSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(result.get("incomeBank") != null ? result.get("incomeBank").toString() : null);// 入账方银行
                HSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(result.get("incomeCerNo") != null ? result.get("incomeCerNo").toString() : null);// 入账方证件号
                HSSFCell cell13 = row.createCell(13);
                cell13.setCellValue(result.get("remark") != null ? result.get("remark").toString() : null);// 备注
                rowIndex++;
            }
            wb.write(os);
            os.close();
            wb.close();
        } catch (Exception e) {
            throw new V5BusinessException(Result.ERROR, e);
        } finally {
            try {
                os.close();
                wb.close();
            } catch (IOException e1) {
            }
        }
        return Result.success("导出对账文件失败");
    }


    /**
     * 从缓存中得到钱包账户名称
     */
    private String getWalletAccountName(String key) {
        String redisKey = redisUtil.REDIS_PREFIX_KEY + ":WalletAccountNo:"+key;
        Object value = null;
        if (stringRedisTemplate.hasKey(redisKey)) {
            value = stringRedisTemplate.opsForValue().get(redisKey);
        } else {
            // 查询数据库配置表，存为一个map，放入缓存，设置超时30分钟
            ComWalletAccountDTO comWalletAccount = comWalletAccountMapper.getComWalletAccountByWalletNo(key);
            if(comWalletAccount != null){
                stringRedisTemplate.opsForValue().set(redisKey,comWalletAccount.getComName());
                stringRedisTemplate.expire(redisKey, PublicConst.ONE_DAY_TIMEOUT_MILLISECONDS, TimeUnit.MILLISECONDS);
                value = comWalletAccount.getComName();
            }
        }
        return value == null ? "" : String.valueOf(value);
    }

    /**
     * 查询待发放补贴
     *
     * @author llc
     * @date 2020-10-16
     */
    @Override
    public Result getDffSubsidyList(ComWalletTransferDTO dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (dto.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if (StringUtils.isEmpty(dto.getSubsidyType())) {
            return Result.fail("补贴类型不能为空");
        }
        String resultStr = bbdTestService.bbdGetDffSubsidyList(dto);
        Map<String, Object> resultMap = new HashMap();
        Map dfMap = new HashMap();
        /*** 如果返回成功 ***/
        if (StringUtils.isNotEmpty(resultStr)) {

            Map<String, Object> map = JSON.parseObject(resultStr, Map.class);
            if (Integer.parseInt(map.get("total").toString()) == 0) {
                PageInfoUtils pageInfo = new PageInfoUtils(new ArrayList());
                dfMap.put("money", 0);
                dfMap.put("count", 0);
                resultMap.put("pageInfo", pageInfo);
                resultMap.put("dfMap", dfMap);
                return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
            } else {
                /*** 解析返回的列表数据 ***/
                ArrayList<Map> list = JSON.parseObject(map.get("data").toString(), new TypeReference<ArrayList<Map>>() {
                });
                PageInfoUtils pageInfo = new PageInfoUtils(list);
                pageInfo.setTotal(Integer.parseInt(map.get("total").toString())); // 总记录数
                pageInfo.setTotalPage(Integer.parseInt(map.get("totalPage").toString()));
                dfMap = JSON.parseObject(map.get("userData").toString(), Map.class);
                resultMap.put("pageInfo", pageInfo);
                resultMap.put("dfMap", dfMap);
                return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
            }
        } else {
            PageInfoUtils pageInfo = new PageInfoUtils(new ArrayList());
            dfMap.put("money", 0);
            dfMap.put("count", 0);
            resultMap.put("pageInfo", pageInfo);
            resultMap.put("dfMap", dfMap);
            return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
        }
    }


    /**
     * 发放保安员资格证补贴
     *
     * @author llc
     * @date 2020-10-14
     */
    @Override
    public Result sendsubSidyVerificationCode(ComWalletTransferDTO dto) throws V5BusinessException {
        commonService.sendCode(dto.getMobilePhone());
        return Result.success("短信发送成功");
    }

    /**
     * 获取百保盾补贴详情页面地址
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-10-23
     */
    @Override
    public Result getBbdSubsidyPageUrl(ComWalletTransferDTO dto) throws V5BusinessException {
        String bbdSubsidyPageUrl = bbdTestService.bbdGetBbdSubsidyPageUrl(dto);
        return Result.success(Result.SUCCESS_QUERY_MSG, bbdSubsidyPageUrl);
    }

    /**
     * 发放保安员资格证补贴
     *
     * @author llc
     * @date 2020-10-14
     */
    @Override
    public Result grantBayZgzSubsidy(ComWalletTransferDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty(dto.getLastschriftAmount())) {
            return Result.fail("划账金额不能为空");
        }
        if (StringUtil.isEmpty(dto.getBatchNo())) {
            return Result.fail("补贴批次号不能为空");
        }
        if (StringUtil.isEmpty(dto.getBatchName())) {
            return Result.fail("补贴批次名称不能为空");
        }
        if (StringUtil.isEmpty(dto.getInId())) {
            return Result.fail("收入企业ID不能空");
        }
        if (StringUtil.isEmpty(dto.getMobilePhone())) {
            throw new V5BusinessException(Result.ERROR, "手机号不能为空");
        }
        if (StringUtil.isEmpty(dto.getActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "短信验证码不能为空");
        } else {
            String activeCodeSerial = taskCacheService.getActiveCodeSerial(dto.getMobilePhone());
            if (StringUtil.isEmpty(activeCodeSerial)) {
                throw new V5BusinessException(Result.ERROR, "验证码失效");
            }
            if (!activeCodeSerial.equals(dto.getActiveCode())) {
                throw new V5BusinessException(Result.ERROR, "验证码不正确");
            }
        }
        dto.setNeedActiveCode(CommonConst.N);
        dto.setComment(dto.getBatchName() + "_保安资格证考务补贴发放"); // 备注
        dto.setOutId(dto.getComId().toString());
        dto.setGoodsName("保安资格证考务补贴");
        dto.setGoodsNumber("1");
        dto.setGoodsUnit("批");
        /*** 先发放给培训机构 ***/
        Result result = comWalletAccountTransfer(dto);
        if (ObjectUtils.equals(result.getRetType(), Result.SUCCESS)) {

            /***  企业补贴发放事件 ***/
            ComSubsidyGrantEvent comSubsidyGrantEvent = new ComSubsidyGrantEvent();
            comSubsidyGrantEvent.setComSubsidyGrantId(idWorker.nextId());
            comSubsidyGrantEvent.setCreateTime(new Date());
            comSubsidyGrantEvent.setCreateBy(dto.getCreateBy());
            comSubsidyGrantEvent.setSubsidyType(DictConst.SUBSIDYTYPE_BAYZGZKWBT);
            comSubsidyGrantEvent.setSubsidyComId(Long.parseLong(dto.getInId())); // 收入的企业为补贴企业
            comSubsidyGrantEvent.setBatchNo(dto.getBatchNo());
            comSubsidyGrantEvent.setBatchName(dto.getBatchName());
            comSubsidyGrantEvent.setComId(dto.getComId());
            comSubsidyGrantEvent.setComWalletTradeId(Long.parseLong(result.getData().toString())); // 交易流水号
            comSubsidyGrantEventMapper.insertComSubsidyGrantEvent(comSubsidyGrantEvent);
        } else {
            return result;
        }

        /*** 培训机构分账给平台 ***/

        ComWalletTransferDTO transferDTO = new ComWalletTransferDTO();
        transferDTO.setOutId(dto.getInId()); // 出账方为培训机构
        transferDTO.setInId(commonService.getSystemConfig(CommonConst.PLAT_COMID)); // 入账方为平台企业
        transferDTO.setNeedActiveCode(CommonConst.N); // 不需要验证码
        transferDTO.setAmount(dto.getLastschriftAmount()); // 划账金额
        transferDTO.setComment(dto.getBatchName() + "_保安资格证考务补贴发放_平台服务费"); // 备注
        transferDTO.setGoodsName("保安资格证考务补贴_平台服务费");
        transferDTO.setGoodsNumber("1");
        transferDTO.setGoodsUnit("批");
        /*** 调用转账接口进行划账 ***/
        Result result2 = comWalletAccountTransfer(transferDTO);

        if (!ObjectUtils.equals(result2.getRetType(), Result.SUCCESS)) {
            return result;
        }

        /*** 开线程同步百保盾 ***/
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable() {
            @Override
            public void run() {
                Result result3 = bbdTestService.bbdSyncSubsidyGrantStatus(dto);
                if (ObjectUtils.equals(result2.getRetType(), Result.SUCCESS)) {

                }
            }
        });
        return Result.success(Result.SUCCESS_MSG);
    }


    /**
     * 发放职业技能培训补贴
     *
     * @author llc
     * @date 2020-10-14
     */
    @Override
    public Result grantZyjnpxSubsidy(ComWalletTransferDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty(dto.getLastschriftAmount())) {
            return Result.fail("划账金额不能为空");
        }
        if (StringUtil.isEmpty(dto.getBatchNo())) {
            return Result.fail("补贴批次号不能为空");
        }
        if (StringUtil.isEmpty(dto.getBatchName())) {
            return Result.fail("补贴批次名称不能为空");
        }
        if (StringUtil.isEmpty(dto.getInId())) {
            return Result.fail("收入企业ID不能空");
        }
        if (StringUtil.isEmpty(dto.getActiveCode())) {
            throw new V5BusinessException(Result.ERROR, "短信验证码不能为空");
        }
        dto.setNeedActiveCode(CommonConst.Y);
        dto.setComment(dto.getBatchName() + "_职业技能培训补贴"); // 备注
        dto.setOutId(dto.getComId().toString());
        dto.setGoodsName("职业技能培训补贴");
        dto.setGoodsNumber("1");
        dto.setGoodsUnit("批");
        /*** 先发放给培训机构 ***/
        Result result = comWalletAccountTransfer(dto);
        if (ObjectUtils.equals(result.getRetType(), Result.SUCCESS)) {

            /***  企业补贴发放事件 ***/
            ComSubsidyGrantEvent comSubsidyGrantEvent = new ComSubsidyGrantEvent();
            comSubsidyGrantEvent.setComSubsidyGrantId(idWorker.nextId());
            comSubsidyGrantEvent.setCreateTime(new Date());
            comSubsidyGrantEvent.setCreateBy(dto.getCreateBy());
            comSubsidyGrantEvent.setSubsidyType(DictConst.SUBSIDYTYPE_ZYJNPXBT);
            comSubsidyGrantEvent.setSubsidyComId(Long.parseLong(dto.getInId())); // 收入的企业为补贴企业
            comSubsidyGrantEvent.setBatchNo(dto.getBatchNo());
            comSubsidyGrantEvent.setBatchName(dto.getBatchName());
            comSubsidyGrantEvent.setComId(dto.getComId());
            comSubsidyGrantEvent.setComWalletTradeId(Long.parseLong(result.getData().toString())); // 交易流水号
            comSubsidyGrantEventMapper.insertComSubsidyGrantEvent(comSubsidyGrantEvent);
        } else {
            return result;
        }

        /*** 培训机构分账给平台 ***/

        ComWalletTransferDTO transferDTO = new ComWalletTransferDTO();
        transferDTO.setOutId(dto.getInId()); // 出账方为培训机构
        transferDTO.setInId(commonService.getSystemConfig(CommonConst.PLAT_COMID)); // 入账方为平台企业
        transferDTO.setNeedActiveCode(CommonConst.N); // 不需要验证码
        transferDTO.setAmount(dto.getLastschriftAmount()); // 划账金额
        transferDTO.setComment(dto.getBatchName() + "_职业技能培训补贴_平台服务费"); // 备注
        transferDTO.setGoodsName("职业技能培训补贴_平台服务费");
        transferDTO.setGoodsNumber("1");
        transferDTO.setGoodsUnit("批");

        /*** 调用转账接口进行划账 ***/
        Result result2 = comWalletAccountTransfer(transferDTO);

        if (!ObjectUtils.equals(result2.getRetType(), Result.SUCCESS)) {
            return result;
        }

        /*** 开线程同步百保盾 ***/
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable() {
            @Override
            public void run() {
                Result result3 = bbdTestService.bbdSyncSubsidyGrantStatus(dto);
                if (ObjectUtils.equals(result2.getRetType(), Result.SUCCESS)) {

                }
            }
        });
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * 查询企业已发放补贴列表
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-10-16
     */
    @Override
    public Result getYffSubsidyList(ComWalletTransferDTO dto) throws V5BusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail("第几页不能为空");
        }
        if (dto.getPageSize() == null) {
            return Result.fail("每页多少行不能为空");
        }
        if (StringUtils.isEmpty(dto.getSubsidyType())) {
            return Result.fail("补贴类型不能为空");
        }
        PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());

        List<Map<String, Object>> list = comSubsidyGrantEventMapper.getYffSubsidyList(dto);

        PageInfoUtils pageInfo = new PageInfoUtils(list);

        return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
    }


    /**
     * 查询已发放补贴统计信息
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-10-22
     */
    @Override
    public Result getYffSubsidyInfo(ComWalletTransferDTO dto) throws V5BusinessException {
        if (StringUtils.isEmpty(dto.getSubsidyType())) {
            return Result.fail("补贴类型不能为空");
        }
        Map<String, Object> map = comSubsidyGrantEventMapper.getYffSubsidyInfo(dto);
        return Result.success(Result.SUCCESS_QUERY_MSG, map);
    }

}