package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtil;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.*;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.app.AppAttendSchedulDto;
import com.bcxin.platform.dto.app.AppAttendShiftDto;
import com.bcxin.platform.dto.attend.*;
import com.bcxin.platform.mapper.attend.*;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.attend.AttendSchedulService;
import com.bcxin.platform.service.attend.AttendShiftService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 考勤排班Service业务层处理
 * 
 * @author lin
 * @date 2021-08-10
 */
@Service
@Transactional("transactionManager")
public class AttendSchedulServiceImpl implements AttendSchedulService {

    /**
     * 日志对象
     */
    protected Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private AttendSchedulMapper attendSchedulMapper;

    @Autowired
    private AttendSchedulDetailMapper attendSchedulDetailMapper;

    @Autowired
    private AttendSchedulConflictMapper attendSchedulConflictMapper;

    @Autowired
    private AttendSchedulConflictDetailMapper attendSchedulConflictDetailMapper;

    @Autowired
    private AttendCalendarRestDetailMapper attendCalendarRestDetailMapper;

    @Autowired
    private PerOrgRelationMapper perOrgRelationMapper;

    @Autowired
    private AttendShiftMapper attendShiftMapper;

    @Autowired
    private AttendShiftService attendShiftService;

    @Autowired
    private AttendPerMapper attendPerMapper;

    @Autowired
    private AttendClockMapper attendClockMapper;

    @Autowired
    private AttendMapper attendMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤排班
     * 
     * @param id 考勤排班ID
     * @return 考勤排班
     */
    @Override
    public AttendSchedulDetail findById(Long id){
        return attendSchedulDetailMapper.findById(id);
    }

    /**
     * 查询考勤排班列表
     * 
     * @param searchDto 考勤排班
     * @return 考勤排班
     */
    @Override
    public List<AttendSchedulPerPageDto> selectList(AttendSchedulPerPageDto searchDto){
        //加上数据权限
        if(!searchDto.isDomainAdmin() && (searchDto.getAdminDepartIds()== null || searchDto.getAdminDepartIds().size() == 0)){
            return new ArrayList<>();
        }
        return attendSchedulDetailMapper.selectList(searchDto);
    }

    /**
     * 修改考勤排班
     * 
     * @param attendSchedul 考勤排班
     * @return 结果
     */
    @Override
    public int update(AttendSchedulDetail attendSchedul){
        if(attendSchedul.getId() == null){
            attendSchedul.setCreateTime(DateUtils.getNowDate());
            attendSchedul.setId(idWorker.nextId());
        }else{
            AttendSchedulDetail dbAttendSchedul = attendSchedulDetailMapper.findById(attendSchedul.getId());
            BeanUtils.copyPropertiesIgnore(attendSchedul,dbAttendSchedul,true);
            BeanUtils.copyPropertiesIgnore(dbAttendSchedul,attendSchedul,false);
        }
        attendSchedul.setUpdateTime(DateUtils.getNowDate());
        return attendSchedulDetailMapper.save(attendSchedul);
    }

    /**
     * 考勤排班
     *
     * @param attendSchedulDto 考勤排班
     * @return 结果
     */
    @Override
    public int save(AttendSchedulDto attendSchedulDto){
        Date startDate = DateUtils.parseDate(attendSchedulDto.getStartDate()) ;
        Date endDate = DateUtils.parseDate(attendSchedulDto.getEndDate());

        //排班
        if(startDate.getTime() < DateUtils.getNowDate().getTime()){
            //最早从今天之后开始
            //startDate = DateUtils.addDays(DateUtils.getNowDate(),1);
            //最早从今天开始
            startDate = DateUtils.parseDate(DateUtils.dateTimeNow(DateUtils.YYYY_MM_DD));
        }

        if(startDate.getTime()>endDate.getTime()){
            throw new BusinessException("日期区间不在有效范围内");
        }

        if(attendSchedulDto.isRemoveOld()) {
            attendClockMapper.remove(attendSchedulDto);
            attendSchedulDetailMapper.remove(attendSchedulDto);
        }

        List<AttendSchedulDetail> schedulList = new ArrayList<>();


        List<AttendPer> attendPerList = attendPerMapper.findByPerIds(attendSchedulDto);
        if(attendPerList.size()< attendSchedulDto.getPerIds().length){
            throw new BusinessException("存在非本考勤套人员!");
        }

        Attend attend = attendMapper.findById(attendSchedulDto.getAttendId());
        List<AttendShift> shiftList = attendShiftMapper.findByArrIds(attendSchedulDto.getShiftIds());

        if(DictConst.SHIFTTYPE_JCBC.equals(attend.getShiftType())){
            //排班冲突判断
            Long conflictCount = attendSchedulDetailMapper.getConflictCount(attendSchedulDto, DateUtils.formatDate(startDate, DateUtils.YYYY_MM_DD), DateUtils.formatDate(endDate, DateUtils.YYYY_MM_DD));
            if (conflictCount > 0) {
                throw new BusinessException("排班冲突");
            }
        }else {
            //排班班次冲突判断
            for (AttendShift attendShift : shiftList) {
                Date startTime = DateUtils.parseDate(DateUtils.getDate() + " " + attendShift.getStartTime());
                Date endTime = DateUtils.parseDate(DateUtils.getDate() + " " + attendShift.getEndTime());

                if (endTime.getTime() < startTime.getTime()) {
                    endTime = DateUtils.addDays(endTime, 1);
                }

                for (AttendShift shift : shiftList) {
                    Date startShiftTime = DateUtils.parseDate(DateUtils.getDate() + " " + shift.getStartTime());
                    Date endShiftTime = DateUtils.parseDate(DateUtils.getDate() + " " + shift.getEndTime());
                    if (endShiftTime.getTime() < startShiftTime.getTime()) {
                        endShiftTime = DateUtils.addDays(endShiftTime, 1);
                    }
                    if (shift.getId().longValue() != attendShift.getId().longValue()) {
                        //if(startTime.getTime() >= startShiftTime.getTime() &&  endTime.getTime() <= endShiftTime.getTime()){
                        //    throw new BusinessException("班次【"+shift.getShiftName()+"】与【"+attendShift.getShiftName()+"】时间存在冲突!");
                        //}
                        //if(startShiftTime.getTime() >= startTime.getTime() &&  endShiftTime.getTime() <= endTime.getTime()){
                        //    throw new BusinessException("班次【"+shift.getShiftName()+"】与【"+attendShift.getShiftName()+"】时间存在冲突!");
                        //}
                        if (startTime.getTime() >= startShiftTime.getTime() && startTime.getTime() < endShiftTime.getTime()) {
                            throw new BusinessException("班次【" + shift.getShiftName() + "】与【" + attendShift.getShiftName() + "】时间存在冲突!");
                        }
                        if (endTime.getTime() > startShiftTime.getTime() && endTime.getTime() <= endShiftTime.getTime()) {
                            throw new BusinessException("班次【" + shift.getShiftName() + "】与【" + attendShift.getShiftName() + "】时间存在冲突!");
                        }
                        if (startShiftTime.getTime() >= startTime.getTime() && startShiftTime.getTime() < endTime.getTime()) {
                            throw new BusinessException("班次【" + shift.getShiftName() + "】与【" + attendShift.getShiftName() + "】时间存在冲突!");
                        }
                        if (endShiftTime.getTime() > startTime.getTime() && endShiftTime.getTime() <= endTime.getTime()) {
                            throw new BusinessException("班次【" + shift.getShiftName() + "】与【" + attendShift.getShiftName() + "】时间存在冲突!");
                        }
                    }
                }
            }

            //排班冲突判断
            Long conflictCount = attendSchedulDetailMapper.getConflictSchedulCount(attendSchedulDto, DateUtils.formatDate(startDate, DateUtils.YYYY_MM_DD), DateUtils.formatDate(endDate, DateUtils.YYYY_MM_DD));
            if (conflictCount > 0) {
                throw new BusinessException("排班冲突");
            }
        }

        Map<Long, AttendShift> shiftMap =  shiftList.stream().collect(Collectors.toMap(AttendShift::getId, Function.identity()));

        List<Date> dateList = DateUtil.getBetweenDates(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,startDate), attendSchedulDto.getEndDate());
        //List<Date> dateList = DateUtil.getBetweenDates(attendSchedulDto.getStartDate(), attendSchedulDto.getEndDate());

        Map<String, AttendCalendarRestDetailDto> restMap = new HashMap<>();

        AttendSchedul attendSchedul = new AttendSchedul();
        attendSchedul.setId(idWorker.nextId());
        attendSchedul.setAttendId(attendSchedulDto.getAttendId());
        attendSchedul.setCalendarId(attendSchedulDto.getCalendarId());
        attendSchedul.setNeedCalendar(attendSchedulDto.getNeedCalendar());
        attendSchedul.setPerIds( String.join(",", attendSchedulDto.getPerIds()));
        attendSchedul.setShiftIds( String.join(",", attendSchedulDto.getShiftIds()));
        attendSchedul.setStartDate(attendSchedulDto.getStartDate());
        attendSchedul.setEndDate(attendSchedulDto.getEndDate());
        attendSchedul.setComId(attendSchedulDto.getComId());
        attendSchedul.setCreateBy(attendSchedulDto.getCreateBy());
        attendSchedul.setCreateTime(new Date());
        attendSchedul.setUpdateBy(attendSchedulDto.getUpdateBy());
        attendSchedul.setUpdateTime(new Date());
        attendSchedul.setIsDelete(Constants.N);

        AttendSchedulDetail tempSchedulDetail = new AttendSchedulDetail();
        tempSchedulDetail.setSchedulId(attendSchedul.getId());
        tempSchedulDetail.setAttendId(attendSchedulDto.getAttendId());
        tempSchedulDetail.setNeedCalendar(attendSchedulDto.getNeedCalendar());
        if(Constants.Y.equals(attendSchedulDto.getNeedCalendar())) {

            if(attendSchedulDto.getCalendarId() == null){
                throw new BusinessException("日历套不能为空");
            }

            tempSchedulDetail.setCalendarId(attendSchedulDto.getCalendarId());

            AttendCalendarRestDetailDto searchDto = new AttendCalendarRestDetailDto();
            searchDto.setCalendarId(attendSchedulDto.getCalendarId());
            List<AttendCalendarRestDetailDto> restList = attendCalendarRestDetailMapper.selectList(searchDto);
            restMap = restList.stream().collect(Collectors.toMap(AttendCalendarRestDetailDto::getRestDate, Function.identity()));
        }
        tempSchedulDetail.setCreateTime(DateUtils.getNowDate());
        tempSchedulDetail.setUpdateTime(DateUtils.getNowDate());
        tempSchedulDetail.setCreateBy(attendSchedulDto.getCreateBy());
        tempSchedulDetail.setUpdateBy(attendSchedulDto.getUpdateBy());
        tempSchedulDetail.setIsDelete(Constants.N);

        AttendSchedulDetail attendSchedulDetail = null;
        AttendShift attendShift = null;
        for (Date date : dateList) {
            for (String perId : attendSchedulDto.getPerIds()) {
                if(restMap.get(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,date)) != null){
                    try {
                        attendSchedulDetail = tempSchedulDetail.clone();
                        attendSchedulDetail.setId(idWorker.nextId());
                        attendSchedulDetail.setPerId(Long.parseLong(perId));

                        PerOrgRelation relation = perOrgRelationMapper.findByPerId(Long.parseLong(perId));
                        attendSchedulDetail.setDeptId(relation.getOrgId());
                        attendSchedulDetail.setSchedulDate(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,date));
                        attendSchedulDetail.setSchedulType(Constants.N);
                        schedulList.add(attendSchedulDetail);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }else{
                    for (String shiftId : attendSchedulDto.getShiftIds()) {
                        attendShift = shiftMap.get(Long.parseLong(shiftId));
                        try {
                            attendSchedulDetail = tempSchedulDetail.clone();
                        } catch (CloneNotSupportedException e) {
                            e.printStackTrace();
                        }
                        attendSchedulDetail.setId(idWorker.nextId());
                        attendSchedulDetail.setPerId(Long.parseLong(perId));
//                        PerOrgRelation relation = perOrgRelationMapper.findByPerId(Long.parseLong(perId));
//                        attendSchedulDetail.setDeptId(relation.getOrgId());
                        attendSchedulDetail.setSchedulType(Constants.Y);
                        attendSchedulDetail.setSchedulDate(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,date));

                        attendSchedulDetail.setNeedRest(attendShift.getNeedRest());
                        if(Constants.Y.equals(attendShift.getNeedRest())){
                            Date restStart = DateUtils.parseDate(attendSchedulDetail.getSchedulDate() + " " + attendShift.getRestStart());
                            Date restEnd = DateUtils.parseDate(attendSchedulDetail.getSchedulDate() + " " + attendShift.getRestEnd());
                            if(restStart.getTime() > restEnd.getTime()){
                                restEnd = DateUtils.addDays(restEnd,1);
                            }
                            attendSchedulDetail.setRestStart(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM,restStart));
                            attendSchedulDetail.setRestEnd(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM,restEnd));
                        }

                        Date startTime = DateUtils.parseDate(attendSchedulDetail.getSchedulDate() + " " + attendShift.getStartTime());
                        attendSchedulDetail.setStartTime(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM,startTime));

                        if(DictConst.SHIFTTYPE_JSBC.equals(attend.getShiftType())){
                            Date endTime = DateUtils.parseDate(attendSchedulDetail.getSchedulDate() + " " + attendShift.getEndTime());
                            if(startTime.getTime() > endTime.getTime()){
                                endTime = DateUtils.addDays(endTime,1);
                            }
                            attendSchedulDetail.setEndTime(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM,endTime));
                        }

                        attendSchedulDetail.setShiftId(attendShift.getId());
                        schedulList.add(attendSchedulDetail);
                    }
                }
            }
        }
        if(schedulList.size() >0){
            attendSchedulDetailMapper.saveBatch(schedulList);
        }

        return attendSchedulMapper.save(attendSchedul);
    }

    /**
     * 考勤排班
     *
     * @param attendSchedulDto 考勤排班
     * @return 结果
     */
    @Override
    public AjaxResult saveForWeeks(AttendSchedulDto attendSchedulDto){
        Date startDate = DateUtils.parseDate(attendSchedulDto.getStartDate()) ;
        Date endDate = DateUtils.parseDate(attendSchedulDto.getEndDate());
        //排班
        if(startDate.getTime() < DateUtils.getNowDate().getTime()){
            //最早从今天之后开始
            //startDate = DateUtils.addDays(DateUtils.getNowDate(),1);
            //最早从今天开始
            startDate = DateUtils.parseDate(DateUtils.dateTimeNow(DateUtils.YYYY_MM_DD));
        }

        if(startDate.getTime()>endDate.getTime()){
            throw new BusinessException("日期区间不在有效范围内");
        }

        List<AttendShift> shiftList = attendShiftMapper.findByArrIds(attendSchedulDto.getShiftIds());
        for (AttendShift attendShift : shiftList) {
            if(!Constants.Y.equals(attendShift.getActive())){
                throw new BusinessException("存在使用未启动的班次！");
            }
        }

        if(attendSchedulDto.isRemoveOld()) {
            attendClockMapper.remove(attendSchedulDto);
            attendSchedulDetailMapper.remove(attendSchedulDto);
        }

        List<AttendSchedulDetail> schedulList = new ArrayList<>();
        List<AttendSchedulConflict> schedulConflictList = new ArrayList<>();
        List<AttendSchedulConflictDetail> schedulConflictDetailList = new ArrayList<>();


        List<AttendPer> attendPerList = attendPerMapper.findByPerIds(attendSchedulDto);
        if(attendPerList.size()< attendSchedulDto.getPerIds().length){
            throw new BusinessException("存在非本考勤套人员!");
        }

        Attend attend = attendMapper.findById(attendSchedulDto.getAttendId());

        if(DictConst.SHIFTTYPE_JSBC.equals(attend.getShiftType())){
            //排班班次冲突判断
            for (AttendShift attendShift : shiftList) {
                Date startTime = DateUtils.parseDate(DateUtils.getDate() + " " + attendShift.getStartTime());
                Date endTime = DateUtils.parseDate(DateUtils.getDate() + " " + attendShift.getEndTime());

                if (endTime.getTime() < startTime.getTime()) {
                    endTime = DateUtils.addDays(endTime, 1);
                }

                for (AttendShift shift : shiftList) {
                    Date startShiftTime = DateUtils.parseDate(DateUtils.getDate() + " " + shift.getStartTime());
                    Date endShiftTime = DateUtils.parseDate(DateUtils.getDate() + " " + shift.getEndTime());
                    if (endShiftTime.getTime() < startShiftTime.getTime()) {
                        endShiftTime = DateUtils.addDays(endShiftTime, 1);
                    }
                    if (shift.getId().longValue() != attendShift.getId().longValue()) {
                        if (startTime.getTime() >= startShiftTime.getTime() && startTime.getTime() < endShiftTime.getTime()) {
                            throw new BusinessException("班次【" + shift.getShiftName() + "】与【" + attendShift.getShiftName() + "】时间存在冲突!");
                        }
                        if (endTime.getTime() > startShiftTime.getTime() && endTime.getTime() <= endShiftTime.getTime()) {
                            throw new BusinessException("班次【" + shift.getShiftName() + "】与【" + attendShift.getShiftName() + "】时间存在冲突!");
                        }
                        if (startShiftTime.getTime() >= startTime.getTime() && startShiftTime.getTime() < endTime.getTime()) {
                            throw new BusinessException("班次【" + shift.getShiftName() + "】与【" + attendShift.getShiftName() + "】时间存在冲突!");
                        }
                        if (endShiftTime.getTime() > startTime.getTime() && endShiftTime.getTime() <= endTime.getTime()) {
                            throw new BusinessException("班次【" + shift.getShiftName() + "】与【" + attendShift.getShiftName() + "】时间存在冲突!");
                        }
                    }
                }
            }
        }

        Map<Long, AttendShift> shiftMap =  shiftList.stream().collect(Collectors.toMap(AttendShift::getId, Function.identity()));

        List<Date> dateList = DateUtil.getBetweenDatesByWeeks(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,startDate), attendSchedulDto.getEndDate(),attendSchedulDto.getWeeks());
        //List<Date> dateList = DateUtil.getBetweenDates(attendSchedulDto.getStartDate(), attendSchedulDto.getEndDate(),attendSchedulDto.getWeeks());

        Map<String, AttendCalendarRestDetailDto> restMap = new HashMap<>();

        AttendSchedul attendSchedul = new AttendSchedul();
        attendSchedul.setId(idWorker.nextId());
        attendSchedul.setAttendId(attendSchedulDto.getAttendId());
        attendSchedul.setCalendarId(attendSchedulDto.getCalendarId());
        attendSchedul.setNeedCalendar(attendSchedulDto.getNeedCalendar());
        attendSchedul.setPerIds( String.join(",", attendSchedulDto.getPerIds()));
        attendSchedul.setShiftIds( String.join(",", attendSchedulDto.getShiftIds()));
        attendSchedul.setStartDate(attendSchedulDto.getStartDate());
        attendSchedul.setEndDate(attendSchedulDto.getEndDate());
        attendSchedul.setComId(attendSchedulDto.getComId());
        attendSchedul.setCreateBy(attendSchedulDto.getCreateBy());
        attendSchedul.setCreateTime(new Date());
        attendSchedul.setUpdateBy(attendSchedulDto.getUpdateBy());
        attendSchedul.setUpdateTime(new Date());
        attendSchedul.setIsDelete(Constants.N);
        attendSchedul.setWeeks(StringUtils.join(attendSchedulDto.getWeeks(),","));

        AttendSchedulDetail tempSchedulDetail = new AttendSchedulDetail();
        tempSchedulDetail.setSchedulId(attendSchedul.getId());
        tempSchedulDetail.setAttendId(attendSchedulDto.getAttendId());
        tempSchedulDetail.setNeedCalendar(attendSchedulDto.getNeedCalendar());
        if(Constants.Y.equals(attendSchedulDto.getNeedCalendar())) {
            if(attendSchedulDto.getCalendarId() == null){
                throw new BusinessException("日历套不能为空");
            }
            tempSchedulDetail.setCalendarId(attendSchedulDto.getCalendarId());
            AttendCalendarRestDetailDto searchDto = new AttendCalendarRestDetailDto();
            searchDto.setCalendarId(attendSchedulDto.getCalendarId());
            List<AttendCalendarRestDetailDto> restList = attendCalendarRestDetailMapper.selectList(searchDto);
            restMap = restList.stream().collect(Collectors.toMap(AttendCalendarRestDetailDto::getRestDate, Function.identity()));
        }
        tempSchedulDetail.setCreateTime(DateUtils.getNowDate());
        tempSchedulDetail.setUpdateTime(DateUtils.getNowDate());
        tempSchedulDetail.setCreateBy(attendSchedulDto.getCreateBy());
        tempSchedulDetail.setUpdateBy(attendSchedulDto.getUpdateBy());
        tempSchedulDetail.setIsDelete(Constants.N);

        AttendSchedulDetail attendSchedulDetail = null;
        AttendShift attendShift = null;
        List<AttendSchedulDetail> conflictSchedulList = attendSchedulDetailMapper.getConflictSchedulList(attendSchedulDto, DateUtils.formatDate(startDate, DateUtils.YYYY_MM_DD), DateUtils.formatDate(endDate, DateUtils.YYYY_MM_DD));

        conflictSchedulList.stream();
        Map<String,List<AttendSchedulDetail>> schedulClockMap = conflictSchedulList.stream().collect(Collectors.groupingBy(AttendSchedulDetail::getSchedulDate));
        for (Date date : dateList) {
            List<AttendSchedulDetail> attendSchedulDetails = schedulClockMap.get(DateUtil.convertDateToString(date, DateUtil.FORMAT2));
            Map<Long, List<AttendSchedulDetail>> perSchedulMap = new HashMap<>();
            if(attendSchedulDetails != null) {
                perSchedulMap = attendSchedulDetails.stream().collect(Collectors.groupingBy(AttendSchedulDetail::getPerId));
            }
            for (String perId : attendSchedulDto.getPerIds()) {
                //日历套 休息日
                if(restMap.get(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,date)) != null){
                    try {
                        attendSchedulDetail = tempSchedulDetail.clone();
                        attendSchedulDetail.setId(idWorker.nextId());
                        attendSchedulDetail.setPerId(Long.parseLong(perId));

                        PerOrgRelation relation = perOrgRelationMapper.findByPerId(Long.parseLong(perId));
                        attendSchedulDetail.setDeptId(relation.getOrgId());
                        attendSchedulDetail.setSchedulDate(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,date));
                        attendSchedulDetail.setSchedulType(Constants.N);
                        schedulList.add(attendSchedulDetail);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }else{
                    //上班排班
                    for (String shiftId : attendSchedulDto.getShiftIds()) {
                        attendShift = shiftMap.get(Long.parseLong(shiftId));
                        try {
                            attendSchedulDetail = tempSchedulDetail.clone();
                        } catch (CloneNotSupportedException e) {
                            e.printStackTrace();
                        }
                        attendSchedulDetail.setId(idWorker.nextId());
                        attendSchedulDetail.setPerId(Long.parseLong(perId));
                        PerOrgRelation relation = perOrgRelationMapper.findByPerId(Long.parseLong(perId));
                        attendSchedulDetail.setDeptId(relation.getOrgId());
                        attendSchedulDetail.setSchedulType(Constants.Y);
                        attendSchedulDetail.setSchedulDate(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,date));

                        attendSchedulDetail.setNeedRest(attendShift.getNeedRest());
                        if(Constants.Y.equals(attendShift.getNeedRest())){
                            Date restStart = DateUtils.parseDate(attendSchedulDetail.getSchedulDate() + " " + attendShift.getRestStart());
                            Date restEnd = DateUtils.parseDate(attendSchedulDetail.getSchedulDate() + " " + attendShift.getRestEnd());
                            if(restStart.getTime() > restEnd.getTime()){
                                restEnd = DateUtils.addDays(restEnd,1);
                            }
                            attendSchedulDetail.setRestStart(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM,restStart));
                            attendSchedulDetail.setRestEnd(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM,restEnd));
                        }

                        Date startTime = DateUtils.parseDate(attendSchedulDetail.getSchedulDate() + " " + attendShift.getStartTime());
                        attendSchedulDetail.setStartTime(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM,startTime));

                        if(DictConst.SHIFTTYPE_JSBC.equals(attend.getShiftType())){
                            Date endTime = DateUtils.parseDate(attendSchedulDetail.getSchedulDate() + " " + attendShift.getEndTime());
                            if(startTime.getTime() > endTime.getTime()){
                                endTime = DateUtils.addDays(endTime,1);
                            }
                            attendSchedulDetail.setEndTime(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM,endTime));
                        }

                        attendSchedulDetail.setShiftId(attendShift.getId());

                        boolean conflict = false;
                        //冲突判断
                        if(perSchedulMap.get(Long.parseLong(perId)) != null){
                            List<AttendSchedulDetail> schedulDetails = perSchedulMap.get(Long.parseLong(perId));
                            for (AttendSchedulDetail schedulDetail : schedulDetails) {
                                if(DictConst.SHIFTTYPE_JCBC.equals(attend.getShiftType())){
                                    if(schedulDetail.getShiftId().equals(attendSchedulDetail.getShiftId())){
                                        conflict = true;
                                        AttendSchedulConflictDetail conflictDetail = new AttendSchedulConflictDetail();
                                        conflictDetail.setId(idWorker.nextId());
                                        conflictDetail.setConflictId(attendSchedulDetail.getId());
                                        conflictDetail.setSchedulDetailId(schedulDetail.getId());
                                        conflictDetail.setCreateTime(DateUtils.getNowDate());
                                        conflictDetail.setUpdateTime(DateUtils.getNowDate());
                                        conflictDetail.setCreateBy(attendSchedulDto.getCreateBy());
                                        conflictDetail.setUpdateBy(attendSchedulDto.getUpdateBy());
                                        conflictDetail.setIsDelete(Constants.N);
                                        schedulConflictDetailList.add(conflictDetail);
                                    }
                                }else{
                                    if((DateUtil.convertStringToDate(schedulDetail.getStartTime()).getTime()>= DateUtil.convertStringToDate(attendSchedulDetail.getStartTime()).getTime()
                                    && DateUtil.convertStringToDate(schedulDetail.getEndTime()).getTime()<= DateUtil.convertStringToDate(attendSchedulDetail.getEndTime()).getTime())
                                    ||(schedulDetail.getShiftId().equals(attendSchedulDetail.getShiftId())
                                            &&DateUtil.convertStringToDate(schedulDetail.getStartTime()).getTime()> DateUtil.convertStringToDate(attendSchedulDetail.getStartTime()).getTime()
                                            && DateUtil.convertStringToDate(schedulDetail.getEndTime()).getTime()< DateUtil.convertStringToDate(attendSchedulDetail.getEndTime()).getTime())){
                                        conflict = true;
                                        AttendSchedulConflictDetail conflictDetail = new AttendSchedulConflictDetail();
                                        conflictDetail.setId(idWorker.nextId());
                                        conflictDetail.setConflictId(attendSchedulDetail.getId());
                                        conflictDetail.setSchedulDetailId(schedulDetail.getId());
                                        conflictDetail.setCreateTime(DateUtils.getNowDate());
                                        conflictDetail.setUpdateTime(DateUtils.getNowDate());
                                        conflictDetail.setCreateBy(attendSchedulDto.getCreateBy());
                                        conflictDetail.setUpdateBy(attendSchedulDto.getUpdateBy());
                                        conflictDetail.setIsDelete(Constants.N);
                                        schedulConflictDetailList.add(conflictDetail);
                                    }
                                }
                            }
                        }
                        if(conflict){
                            AttendSchedulConflict attendSchedulConflict = new AttendSchedulConflict();
                            BeanUtils.copyPropertiesIgnore(attendSchedulDetail,attendSchedulConflict,true);
                            attendSchedulConflict.setConflictState(Constants.N);
                            schedulConflictList.add(attendSchedulConflict);
                        }else{
                            schedulList.add(attendSchedulDetail);
                        }
                    }
                }
            }
        }
        if(schedulList.size() >0){
            attendSchedulDetailMapper.saveBatch(schedulList);
        }
        if(schedulConflictList.size() >0){
            attendSchedulConflictMapper.saveBatch(schedulConflictList);
        }
        if(schedulConflictDetailList.size() >0){
            attendSchedulConflictDetailMapper.saveBatch(schedulConflictDetailList);
        }


        attendSchedulMapper.save(attendSchedul);

        if(schedulConflictList.size() > 0){
            return AjaxResult.warn("出现排班冲突");
        }
        return AjaxResult.success();
    }

    @Override
    public List<PerBaseInfo> getDepartPersonList(AttendSchedulPerDto searchDto) {
        //加上数据权限
        if(!searchDto.isDomainAdmin() && (searchDto.getAdminDepartIds()== null || searchDto.getAdminDepartIds().size() == 0)){
            return new ArrayList<>();
        }
        return attendSchedulDetailMapper.getDepartPerSonList(searchDto);
    }

    @Override
    public List<AppAttendSchedulDto> monthDetail(AppAttendSchedulDto searchDto) {
        AttendShiftDto attendShiftDto = new AttendShiftDto();
        attendShiftDto.setAttendId(searchDto.getAttendId());
        attendShiftDto.setActive(Constants.Y);
        List<AppAttendShiftDto> shiftList = attendShiftService.findByAttendId(attendShiftDto);
        if(shiftList.size() == 0){
            throw new BusinessException("该考勤套不存在启用的班次！");
        }
        Map<Long,String> shiftMap = shiftList.stream().collect(Collectors.toMap(AppAttendShiftDto::getId, AppAttendShiftDto::getLetterTag));
        List<AppAttendSchedulDto> list = attendSchedulDetailMapper.monthDetail(searchDto);
        for (AppAttendSchedulDto appAttendSchedulDto : list) {
            List<String> letterTagList = new ArrayList<>();
            for (String shiftId : appAttendSchedulDto.getShiftIds().split(",")) {
                if(shiftMap.get(Long.parseLong(shiftId)) != null){
                letterTagList.add(shiftMap.get(Long.parseLong(shiftId)));
                }
            }
            Collections.sort(letterTagList);
            appAttendSchedulDto.setShiftNames(StringUtils.join(letterTagList,","));
        }
        
        return list;
    }

    /**
     * 删除考勤排班对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        return attendSchedulDetailMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除考勤排班信息
     * 
     * @param id 考勤排班ID
     * @return 结果
     */
    @Override
    public int deleteById(Long id){
        return attendSchedulDetailMapper.deleteById(id);
    }
}
