package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendCharge;
import com.bcxin.platform.mapper.attend.AttendChargeMapper;
import com.bcxin.platform.service.attend.AttendChargeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 考勤套负责人Service业务层处理
 * 
 * @author lin
 * @date 2021-09-30
 */
@Service
@Transactional
public class AttendChargeServiceImpl implements AttendChargeService{

    @Autowired
    private AttendChargeMapper attendChargeMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤套负责人
     * 
     * @param id 考勤套负责人ID
     * @return 考勤套负责人
     */
    @Override
    public AttendCharge findById(Long id){
        return attendChargeMapper.findById(id);
    }

    /**
     * 查询考勤套负责人列表
     * 
     * @param attendCharge 考勤套负责人
     * @return 考勤套负责人
     */
    @Override
    public List<AttendCharge> selectList(AttendCharge attendCharge){
        return attendChargeMapper.selectList(attendCharge);
    }

    /**
     * 修改考勤套负责人
     * 
     * @param attendCharge 考勤套负责人
     * @return 结果
     */
    @Override
    public int update(AttendCharge attendCharge){
        if(attendCharge.getId() == null){
            attendCharge.setCreateTime(DateUtils.getNowDate());
            attendCharge.setId(idWorker.nextId());
        }else{
            AttendCharge dbAttendCharge = attendChargeMapper.findById(attendCharge.getId());
            BeanUtils.copyPropertiesIgnore(attendCharge,dbAttendCharge,true);
            BeanUtils.copyPropertiesIgnore(dbAttendCharge,attendCharge,false);
        }
        attendCharge.setUpdateTime(DateUtils.getNowDate());
        return attendChargeMapper.save(attendCharge);
    }

    /**
     * 删除考勤套负责人对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        return attendChargeMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除考勤套负责人信息
     * 
     * @param id 考勤套负责人ID
     * @return 结果
     */
    @Override
    public int deleteById(Long id){
        return attendChargeMapper.deleteById(id);
    }
}
