package com.bcxin.platform.dto.wallet;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业补贴发放事件
 *
 * @author llc
 * @date 2020-10-15
 */
@Data
@TableName("com_subsidy_grant_event")
public class ComSubsidyGrantEvent extends BaseEntity<ComSubsidyGrantEvent> {

    /**
     * 企业补贴发放ID
     */
    @ApiModelProperty(value = "企业补贴发放ID")
    private Long comSubsidyGrantId;

    /**
     * 补贴类型
     */
    @ApiModelProperty(value = "补贴类型")
    private String subsidyType;

    /**
     * 补贴企业ID
     */
    @ApiModelProperty(value = "补贴企业ID")
    private Long subsidyComId;

    /**
     * 补贴批次号(同百保盾关联)
     */
    @ApiModelProperty(value = "补贴批次号(同百保盾关联)")
    private String batchNo;

    /**
     * 补贴批次名称
     */
    @ApiModelProperty(value = "补贴批次名称")
    private String batchName;

    /**
     * 企业钱包交易流水号
     */
    @ApiModelProperty(value = "企业钱包交易流水号")
    private Long comWalletTradeId;


    @JsonSerialize(using = ToStringSerializer.class)
    public Long getComSubsidyGrantId() {
        return comSubsidyGrantId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getSubsidyComId() {
        return subsidyComId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getComWalletTradeId() {
        return comWalletTradeId;
    }


}