package com.bcxin.platform.dto.app;

import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.List;

/**
 * @author linqinglin
 * @date 2022/2/15 13:14
 */
@Data
public class AppAttendSchedulConflictDto extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 考勤排班详情ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    private String name;

    private String mobilePhone;

    /** 考勤套ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long attendId;

    /** 上班日期 */
    private String schedulDate;

    /** 上班时间 */
    private String startTime;

    /** 下班时间 */
    private String endTime;

    private List<AppAttendSchedulConflictDto> srcSchedulList;

}
