package com.bcxin.oaflow.service.impl;

import com.bcxin.oaflow.domain.WorkOvertime;
import com.bcxin.oaflow.mapper.WorkOvertimeMapper;
import com.bcxin.oaflow.service.WorkOvertimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 加班Service业务层处理
 * 
 * @author lin
 * @date 2021-09-01
 */
@Service
public class WorkOvertimeServiceImpl implements WorkOvertimeService {

    @Autowired
    private WorkOvertimeMapper workOvertimeMapper;

    /**
     * 查询加班
     * 
     * @param id 加班ID
     * @return 加班
     */
    @Override
    public WorkOvertime findById(String id){
        return workOvertimeMapper.findById(id);
    }

    /**
     * 查询加班列表
     *
     * @param tlkPerIds
     * @param schedulDate
     * @return 加班
     */
    @Override
    public List<WorkOvertime> selectList(List<String> tlkPerIds,String schedulDate){
        return workOvertimeMapper.selectList(tlkPerIds,schedulDate);
    }

}
