/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.grant;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.grant.ComBhAccount;
import com.bcxin.platform.dto.grant.ComBhAccountDTO;
import com.bcxin.platform.mapper.grant.ComBhAccountMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.grant.ComBhAccountService;
import com.bcxin.platform.util.JwtUtil;
import com.bcxin.platform.util.ObjectUtils;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class ComBhAccountServiceImpl
implements ComBhAccountService {
    @Resource
    private ComBhAccountMapper comBhAccountMapper;
    @Resource
    private CommonService commonService;
    @Resource
    private IdWorker idWorker;

    @Override
    public Result getComBhAccount(ComBhAccount comBhAccount) throws V5BusinessException {
        if ((comBhAccount = this.comBhAccountMapper.getComBhAccountByComId(comBhAccount.getComId())) == null) {
            return Result.success((String)"");
        }
        HashMap p = Maps.newHashMap();
        p.put("MerUserId", comBhAccount.getComId().toString());
        String token = JwtUtil.createJWT(p);
        HashMap requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/accountInformation"), (Map)requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        ComBhAccountDTO dto = new ComBhAccountDTO();
        ObjectUtils.copyProperties(dto, comBhAccount);
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            dto.setAccountStatus(map.get("Status").toString());
        }
        return Result.success((String)"", (Object)dto);
    }

    @Override
    public Result getComBhAccountAmount(ComBhAccount comBhAccount) throws V5BusinessException {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("MerUserId", comBhAccount.getComId().toString());
        p.put("VirlAcctType", "01");
        String token = JwtUtil.createJWT(p);
        HashMap requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/accountBalance"), (Map)requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        HashMap resultMap = new HashMap();
        if (!"0".equals(result.getRetType())) {
            return Result.fail((String)result.getMsg());
        }
        Map map = (Map)result.getData();
        resultMap.put("totalAmount", map.get("TotalAmt"));
        resultMap.put("availableAmount", map.get("AviAmt"));
        resultMap.put("frozenAmount", map.get("CongealAmt"));
        return Result.success((String)"", resultMap);
    }

    @Override
    public Result sendOpenAccountVerifyCode(ComBhAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getIdCardNo())) {
            throw new V5BusinessException("-1", "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBankCardNo())) {
            throw new V5BusinessException("-1", "\u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getComName())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("MerUserId", dto.getComId().toString());
        p.put("UserType", "2");
        p.put("CertNo", dto.getIdCardNo());
        p.put("MobilePhone", dto.getMobilePhone());
        p.put("AccountNo", dto.getBankCardNo());
        p.put("AcctName", dto.getComName());
        String token = JwtUtil.createJWT(p);
        HashMap requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/bindAccountDynamicPassword"), (Map)requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            return Result.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result saveComBhAccount(ComBhAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getComName())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getComCerType())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getComCerNo())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getLegalRepName())) {
            throw new V5BusinessException("-1", "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getIdCardNo())) {
            throw new V5BusinessException("-1", "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getIsBhBank())) {
            throw new V5BusinessException("-1", "\u8bf7\u9009\u62e9\u662f\u5426\u6e24\u6d77\u94f6\u884c");
        }
        if (StringUtil.isEmpty((String)dto.getBankNo())) {
            throw new V5BusinessException("-1", "\u94f6\u884c\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBankOutlets())) {
            throw new V5BusinessException("-1", "\u94f6\u884c\u7f51\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBankCardNo())) {
            throw new V5BusinessException("-1", "\u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("MerUserId", dto.getComId().toString());
        p.put("VirlAcctType", "01");
        p.put("UserType", "2");
        p.put("EleAcctName", dto.getComName());
        p.put("CertNo", dto.getIdCardNo());
        p.put("BusPermitId", dto.getComCerNo());
        p.put("MobilePhone", dto.getMobilePhone());
        p.put("BossName", dto.getLegalRepName());
        p.put("AcctNo", dto.getBankCardNo());
        p.put("AcctName", dto.getComName());
        p.put("VerifyNo", dto.getActiveCode());
        p.put("AcctBankId", dto.getBankNo());
        p.put("AcctBankName", dto.getBankOutlets());
        p.put("AcctBHFlag", dto.getIsBhBank());
        p.put("JQOrderId", null);
        p.put("NonAuthFlag", "1");
        p.put("izAddress", null);
        p.put("VisaDate", null);
        p.put("LostDate", null);
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/bindAccount"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if (!"0".equals(result.getRetType())) {
            return Result.fail((String)result.getMsg());
        }
        Map map = (Map)result.getData();
        Date now = new Date();
        dto.setCreateTime(now);
        dto.setBhVirlAcctNo(map.get("VirlAcctNo").toString());
        this.comBhAccountMapper.insertComBhAccount(dto);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result updateComBhAccount(ComBhAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBankOutlets())) {
            throw new V5BusinessException("-1", "\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBankCardNo())) {
            throw new V5BusinessException("-1", "\u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("MerUserId", dto.getComId().toString());
        p.put("VerifyNo", dto.getActiveCode());
        p.put("VirlAcctType", "01");
        p.put("TransCodeIdx", "XXBG");
        p.put("AccountNo", dto.getBankCardNo());
        p.put("AcctName", dto.getComName());
        p.put("AcctBankId", dto.getBankNo());
        p.put("AcctBankName", dto.getBankOutlets());
        p.put("AcctBHFlag", dto.getIsBhBank());
        p.put("MobilePhone", dto.getMobilePhone());
        p.put("JQOrderId", null);
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/accountBindOrChange"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if (!"0".equals(result.getRetType())) {
            return Result.fail((String)result.getMsg());
        }
        this.comBhAccountMapper.updateComBhAccount(dto);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result getBhBankList(ComBhAccount comBhAccount) throws V5BusinessException {
        return Result.success((String)"", (Object)comBhAccount);
    }

    @Override
    public Result sendVerifyCode(ComBhAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getTransCode())) {
            throw new V5BusinessException("-1", "\u4ea4\u6613\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getTransCode().equals("HQJQ")) {
            if (StringUtil.isEmpty((String)dto.getComName())) {
                throw new V5BusinessException("-1", "\u6237\u540d(\u4f01\u4e1a\u540d)\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getBankCardNo())) {
                throw new V5BusinessException("-1", "\u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (dto.getTransCode().equals("XNCZ") || dto.getTransCode().equals("XNTX") || dto.getTransCode().equals("XNZZ")) {
            if (dto.getAmount() == null) {
                return Result.fail((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (dto.getAmount() != null && BigDecimal.ZERO.compareTo(dto.getAmount()) == 0) {
                return Result.fail((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a0");
            }
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("MerUserId", dto.getComId().toString());
        p.put("TransCode", dto.getTransCode());
        p.put("MobilePhone", dto.getMobilePhone());
        p.put("AccountNo", dto.getBankCardNo());
        p.put("AcctName", dto.getComName());
        p.put("TransAmount", dto.getAmount());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/dynamicPassword"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            return Result.success((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result bhAccountRecharge(ComBhAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            return Result.fail((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getAmount() == null) {
            return Result.fail((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getAmount() != null && BigDecimal.ZERO.compareTo(dto.getAmount()) == 0) {
            return Result.fail((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a0");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("MerUserId", dto.getComId().toString());
        p.put("VirlAcctType", "01");
        p.put("Amount", dto.getAmount().toString());
        p.put("VerifyNo", dto.getActiveCode());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/virtualTopUp"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            return Result.success((String)"\u5145\u503c\u6210\u529f");
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result bhAccountWithdrawa(ComBhAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            return Result.fail((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getAmount() == null) {
            return Result.fail((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getAmount() != null && BigDecimal.ZERO.compareTo(dto.getAmount()) == 0) {
            return Result.fail((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a0");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("MerUserId", dto.getComId().toString());
        p.put("VirlAcctType", "01");
        p.put("Amount", dto.getAmount().toString());
        p.put("VerifyNo", dto.getActiveCode());
        p.put("Memo", null);
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/virtualWithdrawal"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            return Result.success((String)"\u63d0\u73b0\u6210\u529f");
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result getAccountHistoryDetailList(ComBhAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getStartDate())) {
            return Result.fail((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getEndDate())) {
            return Result.fail((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap p = Maps.newHashMap();
        p.put("MerUserId", dto.getComId().toString());
        p.put("VirlAcctType", "01");
        p.put("BeginDate", dto.getStartDate());
        p.put("EndDate", dto.getEndDate());
        String token = JwtUtil.createJWT(p);
        HashMap requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/accountHistoryDetail"), (Map)requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            result.setMsg("");
            return result;
        }
        return Result.fail((String)result.getMsg());
    }

    @Override
    public Result updateMobilePhone(ComBhAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComBhAccount comBhAccount = this.comBhAccountMapper.getComBhAccountByComId(dto.getComId());
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("MerUserId", dto.getComId().toString());
        p.put("VerifyNo", dto.getActiveCode());
        p.put("VirlAcctType", "01");
        p.put("TransCodeIdx", "XXBG");
        p.put("AccountNo", comBhAccount.getBankCardNo());
        p.put("AcctName", comBhAccount.getComName());
        p.put("AcctBankId", comBhAccount.getBankNo());
        p.put("AcctBankName", comBhAccount.getBankOutlets());
        p.put("AcctBHFlag", comBhAccount.getIsBhBank());
        p.put("MobilePhone", dto.getMobilePhone());
        p.put("JQOrderId", null);
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/accountBindOrChange"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if (!"0".equals(result.getRetType())) {
            return Result.fail((String)result.getMsg());
        }
        this.comBhAccountMapper.updateComBhAccount(dto);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public List<ComBhAccountDTO> pageComBhAccountList(ComBhAccountDTO dto) {
        if (StringUtil.isNotEmpty((String)dto.getKeyword())) {
            dto.setKeyword(dto.getKeyword().trim());
        }
        return this.comBhAccountMapper.pageComBhAccountList(dto);
    }

    @Override
    public List pagePaymentDetailsList(ComBhAccountDTO dto) throws V5BusinessException {
        if (StringUtil.isEmpty((String)dto.getStartDate())) {
            throw new V5BusinessException("-1", "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getEndDate())) {
            throw new V5BusinessException("-1", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap p = Maps.newHashMap();
        p.put("MerUserId", dto.getComId().toString());
        p.put("VirlAcctType", "01");
        p.put("BeginDate", dto.getStartDate());
        p.put("EndDate", dto.getEndDate());
        String token = JwtUtil.createJWT(p);
        HashMap requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/accountHistoryDetail"), (Map)requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            List listW = (List)result.getData();
            List listN = (List)listW.get(0);
            return listN;
        }
        throw new V5BusinessException("-1", result.getMsg());
    }

    @Override
    public ComBhAccountDTO getComBhAccount(String comId) {
        ComBhAccount comBhAccount = this.comBhAccountMapper.getComBhAccountByComId(Long.parseLong(comId));
        if (comBhAccount == null) {
            return null;
        }
        HashMap p = Maps.newHashMap();
        p.put("MerUserId", comBhAccount.getComId().toString());
        String token = JwtUtil.createJWT(p);
        HashMap requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/bohai/accountInformation"), (Map)requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        ComBhAccountDTO cDto = new ComBhAccountDTO();
        ObjectUtils.copyProperties(cDto, comBhAccount);
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            String status = map.get("Status").toString();
            cDto.setAccountStatus("0".equals(status) ? "\u6b63\u5e38" : ("7".equals(status) ? "\u5ba2\u6237\u7ed1\u5361\u672a\u6fc0\u6d3b" : ("8".equals(status) ? "\u5e73\u53f0\u6237\u5f00\u6237\u5904\u7406\u4e2d" : ("9".equals(status) ? "\u666e\u901a\u5ba2\u6237\u5f00\u6237\u5904\u7406\u4e2d" : ""))));
        }
        return cDto;
    }

    @Override
    public Result updateOpenSalaryAuth(ComBhAccountDTO dto) {
        if (dto.getComId() == null) {
            return Result.fail((String)"comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getIsOpenSalaryAuth())) {
            return Result.fail((String)"isOpenSalaryAuth\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.comBhAccountMapper.updateOpenSalaryAuth(dto);
        return Result.success((String)("1".equals(dto.getIsOpenSalaryAuth()) ? "\u53d1\u85aa\u6743\u9650\u5df2\u5f00\u901a\uff01" : "\u53d1\u85aa\u6743\u9650\u5df2\u5173\u95ed\uff01"));
    }
}

