/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.company.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.dto.company.ComBaseInfoDto;
import com.bcxin.platform.dto.company.ComDTO;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.service.company.ComBaseInfoService;
import com.bcxin.platform.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ComBaseInfoServiceImpl
implements ComBaseInfoService {
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public ComBaseInfo selectComBaseInfoById(Long comId) {
        return this.comBaseInfoMapper.selectComBaseInfoById(comId);
    }

    @Override
    public List<ComBaseInfo> selectComBaseInfoList(ComBaseInfo comBaseInfo) {
        return this.comBaseInfoMapper.selectComBaseInfoList(comBaseInfo);
    }

    @Override
    public int insertComBaseInfo(ComBaseInfo comBaseInfo) {
        comBaseInfo.setComId(this.idWorker.nextId());
        comBaseInfo.setCreateTime(DateUtils.getNowDate());
        return this.comBaseInfoMapper.insertComBaseInfo(comBaseInfo);
    }

    @Override
    public int updateComBaseInfo(ComBaseInfo comBaseInfo) {
        ComBaseInfo dbComBaseInfo = this.comBaseInfoMapper.selectComBaseInfoByTlkId(comBaseInfo.getTlkComId());
        if (dbComBaseInfo == null) {
            comBaseInfo.setComId(this.idWorker.nextId());
            comBaseInfo.setCreateTime(DateUtils.getNowDate());
            return this.comBaseInfoMapper.insertComBaseInfo(comBaseInfo);
        }
        comBaseInfo.setUpdateTime(DateUtils.getNowDate());
        return this.comBaseInfoMapper.updateComBaseInfo(comBaseInfo);
    }

    @Override
    public int deleteComBaseInfoByIds(String ids) {
        return this.comBaseInfoMapper.deleteComBaseInfoByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int deleteComBaseInfoById(Long comId) {
        return this.comBaseInfoMapper.deleteComBaseInfoById(comId);
    }

    @Override
    public Result getByPrimaryKey(ComBaseInfoDto comBaseInfoDto) {
        long a = System.currentTimeMillis();
        ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoById(comBaseInfoDto.getComId());
        if (comBaseInfo != null) {
            ObjectUtils.copyProperties(comBaseInfoDto, comBaseInfo);
        }
        return Result.success((String)"", (Object)comBaseInfoDto);
    }

    @Override
    public ComBaseInfo selectComBaseInfoByTlkId(String tklComId) {
        return this.comBaseInfoMapper.selectComBaseInfoByTlkId(tklComId);
    }

    @Override
    public ComDTO selectByID(ComDTO dto) {
        return this.comBaseInfoMapper.selectDetialByID(dto.getComId());
    }

    @Override
    public List<Map> queryCompanyCombobox() {
        return this.comBaseInfoMapper.queryCompanyCombobox();
    }
}

