package com.bcxin.identify.business.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> App版本配置 </b>
 * @author ZXF
 * @create 2021/03/22 0022 10:08
 * @version
 * @注意事项 </b>
 */
@Data
@TableName("app_version")
public class AppVersion extends Model<AppVersion> {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(type = IdType.ID_WORKER)
	private Long oid;

	/**
	 * 热更新版本号
	 */
	private String version;

	/**
	 * Android端版本号，版本号示例1.0.1，如果修复bug下一版为1.0.2，如果小版本增加功能下一版为1.1.1，如果大版本改动下一版为2.1.1
	 */
	private String androidVerName;

	/**
	 * IOS端版本号，IOS版本号同上
	 */
	private String iOSVerName;

	/**
	 * App更新提示，￥为换行分隔符
	 */
	private String apkSize;

	/**
	 * 0：代表整包更新，1：代表热更新，注意：如果升级了HX版本就需要使用整包更新，热更新无效，其他时候如果代码有少量改的可以使用热更新；2代表强制更新，页面上只出现更新按钮，没有取消按钮
	 */
	private String isWgt;

	/**
	 * 如果IsWgt为1时，会通过此地址下载热更新包
	 */
	private String appWgtURL;
	/**
	 * Android端App包下载地址，如果IsWgt为0时且当AndroidVerName大于当前版本时，需要使用此地址下载安装包执行更新
	 */
	private String apkWebURL;
	/**
	 * IOS端AppStore唤起地址，如果IsWgt为0时且当IOSVerName大于当前版本时，自动吊起应用的AppStore页面进行更新
	 */
	private String iOSLinkURL;
	/**
	 * 创建时间
	 */
	private Date createOn;

	/**
	 * 修改时间
	 */
	private Date updateOn;

	@Override
	protected Serializable pkVal() {
		return this.oid;
	}
}
