package com.bcxin.identify.api.huawei.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.identify.business.service.LogBusinessrequestService;
import com.bcxin.identify.startup.CacheService;
import com.bcxin.identify.util.Result;
import com.bcxin.identify.util.codes.HuaweiMeetConst;
import com.bcxin.identify.util.common.Const;
import com.bcxin.identify.util.common.StringUtil;
import com.bcxin.identify.util.huawei.HttpBuildUtil;
import com.bcxin.identify.util.huawei.RestRequest;
import com.bcxin.identify.util.huawei.RestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * <b> 百度认证相关接口业务处理 </b>
 * @author ZXF
 * @create 2021/01/28 0028 16:45
 * @version
 * @注意事项 </b>
 */
@Service
public class HuaweiMeetService {

    private Logger log = LoggerFactory.getLogger(getClass());

//    @Value("${BOHAI_CER_PATH}")
//    private String BOHAI_CER_PATH;

    @Resource
    private CacheService cacheService;
    @Resource
    private LogBusinessrequestService logBusinessrequestService;

    /**
     * <b> 获取企业华为云会议管理资源 </b>
     * @author ZXF
     * @create 2021/01/31 0031 10:44
     * @version
     * @注意事项 </b>
     */
    public Result getHuaweiManageResource(Map<String,Object> params) {
        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getHuaweiMeetAccessToken(String.valueOf(params.get("huaweiUserName")), String.valueOf(params.get("huaweiPassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_MANAGE_RESOURCE;
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("GET-HUAWEI-MANAGE-RESOURCE", Const.N, "", response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if(StringUtil.isNotEmpty(resultMsg)){
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, HttpBuildUtil.getMapData(response));
    }

    /**
     * <b> 预约会议 </b>
     * @author ZXF
     * @create 2020/01/13 0013 17:18
     * @version
     * @注意事项 </b>
     */
    public Result buildHuaweiMeet(Map<String,Object> params) {

        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getHuaweiMeetAccessToken(String.valueOf(params.get("huaweiUserName")), String.valueOf(params.get("huaweiPassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.ADD_MEET;
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        String param = String.valueOf(params.get("restScheduleConf"));
        log.info(" ========== 预约会议接口");
        log.info(" ========== 请求地址："+url);
        log.info(" ========== 请求报文："+param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        //如果返回报文处理resultMsg有值，说明有失败信息
        log.info(" ========== 返回报文："+response.getEntity());
        logBusinessrequestService.save("BUILD-HUAWEI-MEET", Const.N, params.toString(), response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if(StringUtil.isNotEmpty(resultMsg)){
            return Result.fail(resultMsg);
        }
        JSONArray arr = JSON.parseArray(response.getEntity());
        return Result.success(Result.SUCCESS_QUERY_MSG, arr);
    }

    /**
     * <b> 用户查询自己的信息 </b>
     * @author ZXF
     * @create 2020/01/13 0013 17:18
     * @version
     * @注意事项 </b>
     */
    public Result getHuaweiUserDetail(Map<String,Object> params) {

        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getHuaweiMeetAccessToken(String.valueOf(params.get("huaweiUserName")), String.valueOf(params.get("huaweiPassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_USER_DETAIL;
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        log.info(" ========== 用户查询自己的信息");
        log.info(" ========== 请求地址："+url);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        log.info(" ========== 返回报文："+response.getEntity());
        logBusinessrequestService.save("GET-HUAWEI-USER-DETAIL", Const.N, params.toString(), response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if(StringUtil.isNotEmpty(resultMsg)){
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, HttpBuildUtil.getMapData(response));
    }

    /**
     * 获取企业华为专用云会议室
     * @param params
     * @auth zxf
     * @date 2020-02-17
     * @return
     */
    public Result getHuaweiCloudMeetRoomList(Map<String,Object> params) {
        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getComManageHuaweiMeetAccessToken(String.valueOf(params.get("huaweiManageUserName")), String.valueOf(params.get("huaweiManagePassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_CLOUD_MEET_ROOM_LIST;
        /*** 调用华为云会议接口 ***/
        Map<String, String> map = new HashMap<>();
        map.put("offset", String.valueOf(params.get("offset")));
        map.put("limit", String.valueOf(params.get("limit")));
        String searchKey = String.valueOf(params.get("searchKey"));
        if (StringUtil.isNotEmpty(searchKey)) {
            map.put("searchKey", searchKey);
        }
        map.put("status", String.valueOf(params.get("status")));
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("GET-HUAWEI-CLOUD-MEET-ROOM-LIST", Const.N, map.toString(), response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if(StringUtil.isNotEmpty(resultMsg)){
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, HttpBuildUtil.getMapData(response));
    }

    /**
     * <b> 修改用户云会议室 </b>
     * @author ZXF
     * @create 2020/02/19 0019 10:55
     * @version
     * @注意事项 </b>
     */
    public Result updateHuaweiCloudMemberVmr(Map<String,Object> params) {
        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getHuaweiMeetAccessToken(String.valueOf(params.get("huaweiUserName")), String.valueOf(params.get("huaweiPassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.UPDATE_MEMBER_VMR+params.get("vmrId");
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        Map<String, Object> map = new HashMap<>();
        map.put("vmrName", String.valueOf(params.get("vmrName")));
        map.put("gustPwd", String.valueOf(params.get("gustPwd")));
        map.put("chairPwd", String.valueOf(params.get("chairPwd")));
        map.put("allowGustFirst", params.get("allowGustFirst"));
        map.put("gustFirstNotice", params.get("gustFirstNotice"));
        String param = JSON.toJSONString(map);
        log.info(" ========== 修改用户云会议室接口");
        log.info(" ========== 请求地址："+url);
        log.info(" ========== 请求报文："+param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("PUT", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("UPDATE-HUAWEI-CLOUD-MEMBER-VMR", Const.N, map.toString(), response.getEntity());
        log.info(" ========== 返回报文："+response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if(StringUtil.isNotEmpty(resultMsg)){
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * <b> 回收专用云会议室 </b>
     * @author ZXF
     * @create 2020/02/19 0019 10:55
     * @version
     * @注意事项 </b>
     */
    public Result recycleFromMember(Map<String,Object> params) {
        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getComManageHuaweiMeetAccessToken(String.valueOf(params.get("huaweiManageUserName")), String.valueOf(params.get("huaweiManagePassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.RECYCLE_FROM_MEMBER+params.get("account");
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        String param = String.valueOf(params.get("vmrIds"));
        log.info(" ========== 回收专用云会议室接口");
        log.info(" ========== 请求地址："+url);
        log.info(" ========== 请求报文："+param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("RECYCLE-FROM-MEMBER", Const.N, param, response.getEntity());
        log.info(" ========== 返回报文："+response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if(StringUtil.isNotEmpty(resultMsg)){
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_MSG);
    }


    /**
     * <b> 分配专用云会议室 </b>
     * @author ZXF
     * @create 2020/02/19 0019 10:55
     * @version
     * @注意事项 </b>
     */
    public Result assignToMember(Map<String,Object> params) {
        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getComManageHuaweiMeetAccessToken(String.valueOf(params.get("huaweiManageUserName")), String.valueOf(params.get("huaweiManagePassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.ASSIGN_TO_MEMBER+params.get("account");
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        String param = String.valueOf(params.get("vmrIds"));
        log.info(" ========== 分配专用云会议室接口");
        log.info(" ========== 请求地址："+url);
        log.info(" ========== 请求报文："+param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("ASSIGN-TO-MEMBER", Const.N, param, response.getEntity());
        log.info(" ========== 返回报文："+response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if(StringUtil.isNotEmpty(resultMsg)){
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * <b> 删除专用云会议室 </b>
     * @author ZXF
     * @create 2020/02/19 0019 10:55
     * @version
     * @注意事项 </b>
     */
    public Result deleteMemberVmr(Map<String,Object> params) {
        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getComManageHuaweiMeetAccessToken(String.valueOf(params.get("huaweiManageUserName")), String.valueOf(params.get("huaweiManagePassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.DELETE_MEMBER_VMR;
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        String param = String.valueOf(params.get("vmrIds"));
        log.info(" ========== 删除专用云会议室接口");
        log.info(" ========== 请求地址："+url);
        log.info(" ========== 请求报文："+param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("DELETE-MEMBER-VMR", Const.N, param, response.getEntity());
        log.info(" ========== 返回报文："+response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if(StringUtil.isNotEmpty(resultMsg)){
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * <b> 分页查询用户云会议室 </b>
     * @author ZXF
     * @create 2020/02/20 0020 10:43
     * @version
     * @注意事项 </b>
     */
    public Result getHuaweiCloudMemberVmrList(Map<String,Object> params) {
        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getHuaweiMeetAccessToken(String.valueOf(params.get("huaweiUserName")), String.valueOf(params.get("huaweiPassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_MEMBER_VMR_LIST;
        /*** 调用华为云会议接口 ***/
        Map<String, String> map = new HashMap<>();
        map.put("offset", String.valueOf(params.get("offset")));
        map.put("limit", String.valueOf(params.get("limit")));
        String searchKey = String.valueOf(params.get("searchKey"));
        if (params.get("searchKey")!=null) {
            map.put("searchKey", searchKey);
        }
        map.put("specialVmr", params.get("specialVmr") == null ? "" : String.valueOf(params.get("specialVmr")));
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("GET-HUAWEI-CLOUD-MEMBER-VMR-LIST", Const.N, map.toString(), response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if(StringUtil.isNotEmpty(resultMsg)){
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, HttpBuildUtil.getMapData(response));
    }

    /**
     * <b> 华为云鉴权 </b>
     * @author ZXF
     * @create 2021/01/31 0031 9:58
     * @version
     * @注意事项 </b>
     */
    public Result getHuaweiAccessToken(Map<String,Object> params) {

        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getHuaweiMeetAccessToken(String.valueOf(params.get("huaweiUserName")), String.valueOf(params.get("huaweiPassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, accessToken);
    }

    /**
     * <b> 新增用户 </b>
     * @author ZXF
     * @create 2021/01/31 0031 9:59
     * @version
     * @注意事项 </b>
     */
    public Result addUser(Map<String,Object> params) {

        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getComManageHuaweiMeetAccessToken(String.valueOf(params.get("huaweiManageUserName")), String.valueOf(params.get("huaweiManagePassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/
        Map<String, Object> map = new HashMap<>();
        map.put("name", String.valueOf(params.get("name")));
        map.put("account", String.valueOf(params.get("account")));
        map.put("pwd", String.valueOf(params.get("pwd")));
        map.put("phone", String.valueOf(params.get("phone")));
        map.put("sendNotify", String.valueOf(params.get("sendNotify"))); // 不发送邮件和短信通知。
        map.put("country", String.valueOf(params.get("country")));  // 当填写手机号时 “country”参数必填。
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.ADD_USER;
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, JSON.toJSONString(map), null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("ADD-USER", Const.N, map.toString(), response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtil.isNotEmpty(resultMsg)) {
            return Result.fail(resultMsg);
        }
        Map<String, Object> resultMap = HttpBuildUtil.getMapData(response);

        return Result.success("添加成功",resultMap);
    }

    /**
     * <b> 批量删除用户 </b>
     * TODO leaveJonBatchDeleteUser(离职自动批量删除用户) 也是用这个接口
     * @author ZXF
     * @create 2021/01/31 0031 10:08
     * @version
     * @注意事项 </b>
     */
    public Result batchDeleteUser(Map<String,Object> params) {
        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getComManageHuaweiMeetAccessToken(String.valueOf(params.get("huaweiManageUserName")), String.valueOf(params.get("huaweiManagePassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.BATCH_DELETE_USER;
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, String.valueOf(params.get("accounts")), null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("BATCH-DELETE-USER", Const.N, "", response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtil.isNotEmpty(resultMsg)) {
            return Result.fail(resultMsg);
        }
        return Result.success("删除成功");
    }

    /**
     * <b> 查询会议列表 </b>
     * @author ZXF
     * @create 2021/01/31 0031 10:21
     * @version
     * @注意事项 </b>
     */
    public Result getHuaweiMeetList(Map<String,Object> params) {

        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getHuaweiMeetAccessToken(String.valueOf(params.get("huaweiUserName")), String.valueOf(params.get("huaweiPassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/

        Map<String, String> map = new HashMap<>();
        map.put("userUUID", String.valueOf(params.get("userUUID")));
        map.put("offset", String.valueOf(params.get("offset")));
        map.put("limit", String.valueOf(params.get("limit")));
        map.put("sortType", String.valueOf(params.get("sortType")));
        String searchKey = String.valueOf(params.get("searchKey"));
        if(params.get("searchKey")!=null){ // 关键字
            map.put("searchKey", searchKey);
        }
        String queryConfMode = String.valueOf(params.get("queryConfMode"));
        if(params.get("queryConfMode")!=null){ // 查询维度
            map.put("queryConfMode", queryConfMode);
        }
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_MEET_LIST;
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("GET-HUAWEI-MEET-LIST", Const.N, map.toString(), response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtil.isNotEmpty(resultMsg)) {
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, HttpBuildUtil.getMapData(response));
    }

    /**
     * <b> 获取录播文件列表 </b>
     * @author ZXF
     * @create 2021/01/31 0031 10:30
     * @version
     * @注意事项 </b>
     */
    public Result getTranscribeFileList(Map<String,Object> params) {
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = DateUtil.parse(params.get("startTime") + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
            endTime = DateUtil.parse(params.get("endTime") + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
        } catch (Exception e) {
        }

        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getHuaweiMeetAccessToken(String.valueOf(params.get("huaweiUserName")), String.valueOf(params.get("huaweiPassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/

        Map<String, String> map = new HashMap<>();
        map.put("userUUID", String.valueOf(params.get("userUUID")));
        map.put("offset", String.valueOf(params.get("offset")));
        map.put("limit", String.valueOf(params.get("limit")));
        String searchKey = String.valueOf(params.get("searchKey"));
        if (params.get("searchKey")!=null) {
            map.put("searchKey", searchKey);
        }
        map.put("startDate", String.valueOf(startTime.getTime()));
        map.put("endDate", String.valueOf(endTime.getTime()));
        map.put("sortType", String.valueOf(params.get("sortType")));
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_TRANSCRIBE_FILE_LIST;
        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("GET-TRANSCRIBE-FILE-LIST", Const.N, map.toString(), response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtil.isNotEmpty(resultMsg)) {
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, HttpBuildUtil.getMapData(response));
    }

    /**
     * <b> 批量删除录播文件 </b>
     * @author ZXF
     * @create 2021/01/31 0031 10:33
     * @version
     * @注意事项 </b>
     */
    public Result batchDeleteTranscribeFile(Map<String,Object> params) {
        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getHuaweiMeetAccessToken(String.valueOf(params.get("huaweiUserName")), String.valueOf(params.get("huaweiPassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/

        Map<String, String> map = new HashMap<>();
        map.put("confUUIDs", String.valueOf(params.get("confUUIDs")));
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.DELETE_TRANSCRIBE_FILE;

        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("DELETE", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("BATCH-DELETE-TRANSCRIBE-FILE", Const.N, map.toString(), response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtil.isNotEmpty(resultMsg)) {
            return Result.fail(resultMsg);
        }
        return Result.success("删除成功");
    }

    /**
     * <b> 查询会议详情 </b>
     * @author ZXF
     * @create 2021/01/31 0031 10:39
     * @version
     * @注意事项 </b>
     */
    public Result getHuaweiMeetDetail(Map<String,Object> params) {

        /*** 获取华为云会议的accessToken ***/
        String accessToken = cacheService.getHuaweiMeetAccessToken(String.valueOf(params.get("huaweiUserName")), String.valueOf(params.get("huaweiPassWord")));
        if (StringUtil.isEmpty(accessToken)) {
            return Result.fail("华为云会议鉴权失败");
        }
        /*** 调用华为云会议接口 ***/

        Map<String, String> map = new HashMap<>();
        map.put("conferenceID", String.valueOf(params.get("conferenceID")));
        map.put("userUUID", String.valueOf(params.get("userUUID")));
        String offset = String.valueOf(params.get("offset"));
        if(params.get("offset")!=null) {
            map.put("offset", offset);
        }
        String limit = String.valueOf(params.get("limit"));
        if(params.get("limit")!=null) {
            map.put("limit", limit);
        }
        String searchKey = String.valueOf(params.get("searchKey"));
        if(params.get("searchKey")!=null){ // 关键字
            map.put("searchKey", searchKey);
        }
        String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_MEET_DETAIL;

        Map<String, String> headMap = new HashMap<>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        logBusinessrequestService.save("GET-HUAWEI-MEET-DETAIL", Const.N, map.toString(), response.getEntity());
        //如果返回报文处理resultMsg有值，说明有失败信息
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtil.isNotEmpty(resultMsg)) {
            return Result.fail(resultMsg);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, HttpBuildUtil.getMapData(response));
    }
}
